/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client;

import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.ZkSessionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkThreadLocalScope
implements ZkSessionScope {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ZkThreadLocalScope.class);
    private ThreadLocal<ZkSession> scope = new ThreadLocal();
    private final Object guard = new Object();

    @Override
    public ZkSession getSession() {
        return this.scope.get();
    }

    @Override
    public void removeSession(ZkSession c) {
        ZkSession session = this.scope.get();
        if (session == null) {
            throw new IllegalStateException("Not set yet.");
        }
        this.scope.set(null);
        L.debug("Session removed.");
    }

    @Override
    public void putSession(ZkSession session) {
        ZkSession c = this.scope.get();
        if (c != null) {
            throw new IllegalStateException("Already set.");
        }
        L.debug("Session installed.");
        this.scope.set(session);
    }

    @Override
    public void clear() {
        this.scope = null;
        L.debug("Scope cleared.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withLock(ZkSessionScope.Action what) {
        Object object = this.guard;
        synchronized (object) {
            what.doIt(this, this.guard);
        }
    }
}

