/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client;

import com.ez.keeper.client.ZkEvent;
import com.ez.keeper.client.ZkEventListener;
import com.ez.keeper.client.ZkEventListenerAdapter;
import com.ez.keeper.client.ZkException;
import com.ez.keeper.client.ZkMonitor;
import com.ez.keeper.client.ZkNodeEvent;
import com.ez.keeper.client.ZkRequestEvent;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.ZkSessionEvent;
import com.ez.keeper.client.request.ZkBaseRequest;
import com.ez.keeper.client.request.ZkRequest;
import com.ez.keeper.client.request.ZkResult;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkRequestMonitor
implements ZkMonitor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ZkRequestMonitor.class);
    private ZkRequest request;
    private StateImpl stateImpl;
    private final Object stateGuard = new Object();
    private ZkEventListener sessionListener;
    private CommandEventListener commandListener;
    private ZkSession session;
    private int flags;
    private ZkEventListener clientListener;
    private String watcherName;
    private final StateImpl CREATED = new StateImpl(State.CREATED){

        @Override
        protected synchronized void onEnterState() {
        }

        @Override
        protected synchronized void onLeaveState() {
            ZkRequestMonitor.this.onRootStart();
        }

        @Override
        protected synchronized void onStart() {
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.SENDING, "onStart");
        }
    };
    private final StateImpl SENDING = new StateImpl(State.SENDING){

        @Override
        protected synchronized void onEnterState() {
            ZkRequestMonitor.this.submit();
        }

        @Override
        protected synchronized void onRequestDone(ZkRequestEvent e) {
            if (!e.hasError()) {
                ZkBaseRequest re = (ZkBaseRequest)e.getRequest();
                ZkResult r = e.getResult();
                ZkNodeEvent ne = new ZkNodeEvent(re.getFinishEventType(), re.getPath(), r.getData(), r.getStat());
                ZkRequestMonitor.this.dispatchEvent(ne);
                ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.WATCHING, "onRequestDone");
            } else if (ZkRequestMonitor.this.noSuchNodeException(e.getException())) {
                if (L.isDebugEnabled()) {
                    L.debug("No such node for request: " + e.getRequest());
                }
                ZkRequestMonitor.this.dispatchEvent(e);
                ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.DELETED, "onRequestDone");
            } else {
                L.trace("Request failed.", (Throwable)e.getException());
                ZkRequestMonitor.this.dispatchEvent(e);
                ZkRequestMonitor.this.submit();
            }
        }

        @Override
        protected synchronized void onDisconnect(ZkEvent e) {
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.DISCONNECTED, "onDisconnect");
        }

        @Override
        protected synchronized void onSessionExpired(ZkEvent e) {
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.EXPIRED, "onSessionExpired");
        }

        @Override
        protected synchronized void onStop() {
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.FINISHED, "onStop");
        }
    };
    private final StateImpl WATCHING = new StateImpl(State.WATCHING){

        @Override
        protected synchronized void onNodeDeleted(ZkEvent e) {
            ZkRequestMonitor.this.dispatchEvent(e);
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.DELETED, "onNodeDeleted");
        }

        @Override
        protected synchronized void onNodeCreated(ZkEvent e) {
            ZkRequestMonitor.this.dispatchEvent(e);
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.SENDING, "onNodeCreated");
        }

        @Override
        protected synchronized void onNodeDataChanged(ZkEvent e) {
            ZkRequestMonitor.this.dispatchEvent(e);
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.SENDING, "onNodeDataChanged");
        }

        @Override
        protected synchronized void onNodeChildrenChanged(ZkEvent e) {
            ZkRequestMonitor.this.dispatchEvent(e);
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.SENDING, "onNodeChildrenChanged");
        }

        @Override
        protected synchronized void onSessionExpired(ZkEvent e) {
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.EXPIRED, "onSessionExpired");
        }

        @Override
        protected synchronized void onStop() {
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.FINISHED, "onStop");
        }
    };
    private final StateImpl DELETED = new StateImpl(State.DELETED){

        @Override
        protected synchronized void onEnterState() {
            if ((this.m.flags & 1) > 0) {
                ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.SENDING, "onEnterState");
            }
        }
    };
    private final StateImpl DISCONNECTED = new StateImpl(State.DISCONNECTED){

        @Override
        protected synchronized void onSessionExpired(ZkEvent e) {
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.EXPIRED, "onSessionExpired");
        }

        @Override
        protected synchronized void onStop() {
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.FINISHED, "onStop");
        }
    };
    private final StateImpl EXPIRED = new StateImpl(State.EXPIRED){

        @Override
        protected synchronized void onStop() {
            ZkRequestMonitor.this.moveState(ZkRequestMonitor.this.FINISHED, "onStop");
        }
    };
    private final StateImpl FINISHED = new StateImpl(State.FINISHED){

        @Override
        protected synchronized void onEnterState() {
            ZkRequestMonitor.this.onRootEnd();
        }
    };

    void onRootStart() {
        L.debug(this.fmsg("starting monitor..."));
        this.session.registerListener(this.sessionListener);
    }

    void onRootEnd() {
        L.debug(this.fmsg("stopping monitor..."));
        this.session.removeListener(this.sessionListener);
    }

    private void submit() {
        this.session.executeAsync(this.request, this.commandListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveState(StateImpl newState, String onEvent) {
        L.debug(this.fmsg("state transition {}->{} on {}"), new Object[]{this.stateImpl.state, newState.state.name(), onEvent});
        Object object = this.stateGuard;
        synchronized (object) {
            this.stateImpl.onLeaveState();
            this.stateImpl = newState;
            this.stateImpl.onEnterState();
        }
    }

    public ZkRequestMonitor(ZkSession session, ZkRequest request, ZkEventListener eventListener, String watcherName) {
        this(session, request, eventListener, watcherName, 0);
    }

    public ZkRequestMonitor(ZkSession session, ZkRequest request, ZkEventListener eventListener, String watcherName, int flags) {
        if (session == null) {
            throw new IllegalArgumentException("session");
        }
        if (request == null) {
            throw new IllegalArgumentException("request");
        }
        if (eventListener == null) {
            throw new IllegalArgumentException("eventListener");
        }
        if (watcherName == null) {
            throw new IllegalArgumentException("watcherName");
        }
        this.session = session;
        this.request = request;
        this.flags = flags;
        this.clientListener = eventListener;
        this.watcherName = watcherName;
        this.sessionListener = new SessionEventListener(this);
        this.commandListener = new CommandEventListener(this);
        this.stateImpl = this.CREATED;
    }

    @Override
    public void start() {
        this.stateImpl.onStart();
    }

    @Override
    public void stop() {
        this.stateImpl.onStop();
    }

    public State getState() {
        return this.stateImpl.state;
    }

    private void dispatchEvent(ZkEvent e) {
        try {
            this.clientListener.notifyEvent(e);
        }
        catch (Exception ex) {
            L.error("Uncaught error during listener call.", (Throwable)ex);
        }
    }

    private boolean noSuchNodeException(Exception e) {
        Throwable c = e.getCause();
        return e instanceof ZkException && c != null && c instanceof KeeperException && ((KeeperException)c).code() == KeeperException.Code.NONODE;
    }

    protected String fmsg(String msg) {
        return String.format("%s: %s", this.watcherName, msg);
    }

    private class CommandEventListener
    extends ZkEventListenerAdapter {
        ZkRequestMonitor monitor;

        CommandEventListener(ZkRequestMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void notifyNodeChildrenChanged(ZkNodeEvent e) {
            this.monitor.stateImpl.onNodeChildrenChanged(e);
        }

        @Override
        public void notifyNodeDeleted(ZkNodeEvent e) {
            this.monitor.stateImpl.onNodeDeleted(e);
        }

        @Override
        public void notifyNodeCreated(ZkNodeEvent e) {
            this.monitor.stateImpl.onNodeCreated(e);
        }

        @Override
        public void notifyNodeDataChanged(ZkNodeEvent e) {
            this.monitor.stateImpl.onNodeDataChanged(e);
        }

        @Override
        protected void dontCare(ZkEvent e) {
            this.monitor.stateImpl.onAnotherEvents(e);
        }

        @Override
        public void notifyRequestFinished(ZkRequestEvent e) {
            this.monitor.stateImpl.onRequestDone(e);
        }
    }

    private class SessionEventListener
    extends ZkEventListenerAdapter {
        ZkRequestMonitor monitor;

        SessionEventListener(ZkRequestMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void notifySessionEvent(ZkSessionEvent e) {
            if (e.getState() == Watcher.Event.KeeperState.Expired) {
                this.monitor.stateImpl.onSessionExpired(e);
            } else if (e.getState() == Watcher.Event.KeeperState.SyncConnected || e.getState() == Watcher.Event.KeeperState.ConnectedReadOnly) {
                this.monitor.stateImpl.onConnect(e);
            } else if (e.getState() == Watcher.Event.KeeperState.Disconnected) {
                this.monitor.stateImpl.onDisconnect(e);
            }
        }
    }

    private class StateImpl {
        ZkRequestMonitor m;
        State state;

        public StateImpl(State state) {
            this.m = ZkRequestMonitor.this;
            this.state = state;
        }

        protected synchronized void onLeaveState() {
        }

        protected synchronized void onEnterState() {
        }

        protected synchronized void onStart() {
            this.logInvalidEvent("onStart");
        }

        protected synchronized void onStop() {
            this.logInvalidEvent("onStop");
        }

        protected synchronized void onConnect(ZkEvent e) {
            this.logInvalidEvent("onConnect");
        }

        protected synchronized void onDisconnect(ZkEvent e) {
            this.logInvalidEvent("onDisconnect");
        }

        protected synchronized void onSessionExpired(ZkEvent e) {
            this.logInvalidEvent("onSessionExpired");
        }

        protected synchronized void onNodeCreated(ZkEvent e) {
            this.logInvalidEvent("onNodeCreate");
        }

        protected synchronized void onNodeDeleted(ZkEvent e) {
            this.logInvalidEvent("onNodeDeleted");
        }

        protected synchronized void onNodeDataChanged(ZkEvent e) {
            this.logInvalidEvent("onNodeDataChanged");
        }

        protected synchronized void onNodeChildrenChanged(ZkEvent e) {
            this.logInvalidEvent("onNodeChildrenChanged");
        }

        protected synchronized void onRequestDone(ZkRequestEvent e) {
            this.logInvalidEvent("onRequestDone");
        }

        protected synchronized void onAnotherEvents(ZkEvent e) {
            ZkRequestMonitor.this.dispatchEvent(e);
        }

        private void logInvalidEvent(String event) {
            L.debug(ZkRequestMonitor.this.fmsg("State {}: unhandled / ignored event {}"), (Object)this.state, (Object)event);
        }
    }

    public static enum State {
        CREATED("CREATED"),
        SENDING("SENDING"),
        WATCHING("WATCHING"),
        NO_SUCH_NODE("NO_SUCH_NODE"),
        DELETED("DELETED"),
        WAIT_CREATION("WAIT_CREATION"),
        DISCONNECTED("DISCONNECTED"),
        EXPIRED("EXPIRED"),
        FAILED("FAILED"),
        FINISHED("FINISHED");

        private String name;

        public String getStateName() {
            return this.name;
        }

        private State(String name) {
            this.name = name;
        }
    }
}

