/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client;

import com.ez.keeper.client.ZkEvent;
import com.ez.keeper.client.ZkEventType;
import com.ez.keeper.client.request.ZkRequest;
import com.ez.keeper.client.request.ZkResult;

public class ZkRequestEvent
extends ZkEvent {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    ZkResult result;
    boolean hasError;
    Exception ex;
    ZkRequest request;

    public ZkRequestEvent(ZkRequest request, ZkResult result) {
        super(ZkEventType.RequestFinished);
        if (result == null) {
            throw new IllegalArgumentException("result");
        }
        if (request == null) {
            throw new IllegalArgumentException("type");
        }
        this.result = result;
        this.request = request;
    }

    public ZkRequestEvent(ZkRequest request, Exception ex) {
        super(ZkEventType.RequestFinished);
        this.request = request;
        this.hasError = true;
        this.ex = ex;
    }

    public ZkRequest getRequest() {
        return this.request;
    }

    public ZkResult getResult() {
        return this.result;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public Exception getException() {
        return this.ex;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        b.append("class: ");
        b.append(this.getClass().getSimpleName());
        b.append(", request: ");
        b.append(this.request);
        b.append(", result: ");
        b.append(this.result);
        b.append(", hasError: ");
        b.append(this.hasError);
        b.append("]");
        return b.toString();
    }
}

