/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client;

import java.util.ArrayList;
import java.util.regex.Pattern;

public class ZkPath {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String PATH_RE = "(/([^/]+(/[^/]+)*)?)|([^/]+(/[^/]+)*)";
    private static final Pattern PATH_PATTERN = Pattern.compile("(/([^/]+(/[^/]+)*)?)|([^/]+(/[^/]+)*)");
    public static final String SEPERATOR = String.valueOf('/');
    public static final String ROOT = String.valueOf('/');
    public static final String SYNC_PATH_ROOT = "/sync";

    public static String normalize(String p) {
        if (p == null || p.length() == 0) {
            throw new IllegalArgumentException("p");
        }
        if (p.length() > 1 && p.endsWith(SEPERATOR)) {
            p = p.substring(0, p.length() - 1);
        }
        return p;
    }

    public static boolean validate(String path) {
        return PATH_PATTERN.matcher(path).matches();
    }

    public static String relative(String root, String path) {
        String r = null;
        if (root == null) {
            throw new IllegalArgumentException("root");
        }
        if (path == null) {
            throw new IllegalArgumentException("path");
        }
        if (!ZkPath.isAbsolute(root)) {
            throw new IllegalArgumentException("Path not absolute: " + root);
        }
        if (!ZkPath.isAbsolute(path)) {
            throw new IllegalArgumentException("Path not absolute: " + path);
        }
        root = ZkPath.normalize(root);
        if (!(path = ZkPath.normalize(path)).startsWith(root) || path.length() == root.length()) {
            return null;
        }
        r = path.substring(root.length());
        if (!r.startsWith(SEPERATOR)) {
            return null;
        }
        return r.substring(1, r.length());
    }

    public static String relative2(String root, String path) {
        String r = null;
        if (root == null) {
            throw new IllegalArgumentException("root");
        }
        if (path == null) {
            throw new IllegalArgumentException("path");
        }
        if (!ZkPath.isAbsolute(root)) {
            throw new IllegalArgumentException("Path not absolute: " + root);
        }
        if (!ZkPath.isAbsolute(path)) {
            throw new IllegalArgumentException("Path not absolute: " + path);
        }
        root = ZkPath.normalize(root);
        if ((path = ZkPath.normalize(path)).equals(root)) {
            return "";
        }
        if (!path.startsWith(root)) {
            return null;
        }
        r = path.substring(root.length());
        if (!r.startsWith(SEPERATOR)) {
            return null;
        }
        return r.substring(1, r.length());
    }

    public static boolean areEquals(String p1, String p2) {
        if (p1 == null) {
            throw new IllegalArgumentException("p1");
        }
        if (p2 == null) {
            throw new IllegalArgumentException("p1");
        }
        if (ZkPath.isAbsolute(p1) != ZkPath.isAbsolute(p2)) {
            throw new IllegalArgumentException("Paths must be either absolute or relative.");
        }
        p1 = ZkPath.normalize(p1);
        p2 = ZkPath.normalize(p2);
        return p1.equals(p2);
    }

    public static String[] split(String path) {
        ArrayList<String> r = new ArrayList<String>();
        String[] arr = new String[]{};
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        if (!ZkPath.validate(path)) {
            throw new IllegalArgumentException(path);
        }
        boolean absolute = ZkPath.isAbsolute(path);
        if (absolute) {
            path = path.substring(1);
        }
        if (path.length() > 0) {
            arr = path.split(SEPERATOR);
        }
        if (absolute) {
            r.add(ROOT);
        }
        for (String s : arr) {
            r.add(s);
        }
        return r.toArray(new String[0]);
    }

    public static String join(String path, String ... paths) {
        StringBuilder b = new StringBuilder();
        String npath = ZkPath.normalize(path);
        boolean bsep = false;
        if (!ZkPath.validate(npath)) {
            throw new IllegalArgumentException("path");
        }
        b.append(npath);
        bsep = npath.endsWith(SEPERATOR);
        for (String p : paths) {
            String np = ZkPath.normalize(p);
            if (!ZkPath.validate(np)) {
                throw new IllegalArgumentException("Invalid path segment: " + p);
            }
            if (!bsep && !np.startsWith(SEPERATOR)) {
                b.append(SEPERATOR);
            }
            bsep = npath.endsWith(SEPERATOR);
            b.append(np);
        }
        return b.toString();
    }

    public static String join(String[] paths) {
        StringBuilder b = new StringBuilder();
        boolean bsep = true;
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("path");
        }
        for (String p : paths) {
            String np = ZkPath.normalize(p);
            if (!ZkPath.validate(np)) {
                throw new IllegalArgumentException("Invalid path segment: " + p);
            }
            if (!bsep && !p.startsWith(SEPERATOR)) {
                b.append(SEPERATOR);
            }
            bsep = np.endsWith(SEPERATOR);
            b.append(np);
        }
        return b.toString();
    }

    public static boolean isAbsolute(String p) {
        if (p == null) {
            throw new IllegalArgumentException("p");
        }
        return p.startsWith(ROOT);
    }

    public static String getSyncPath(String p) {
        return ZkPath.join(SYNC_PATH_ROOT, p);
    }
}

