/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client;

import com.ez.keeper.client.ZkNetworkException;
import com.ez.keeper.client.ZkNoSuchNodeException;
import com.ez.keeper.client.ZkSessionExpiredException;
import com.ez.keeper.client.ZkStaleDataException;
import java.io.IOException;
import java.util.Map;
import org.apache.zookeeper.KeeperException;

public class ZkException
extends RuntimeException {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected long sessionId;
    protected Map<String, String> args;
    protected String message = null;
    protected String extMessage = null;

    public static ZkException create(Exception e, long sessionId) {
        KeeperException ke;
        ZkException ez = e instanceof IOException ? new ZkNetworkException(sessionId, "Network exception.", e) : (e instanceof KeeperException.ConnectionLossException ? new ZkNetworkException(sessionId, "Connection loss exception.", e) : (e instanceof KeeperException.SessionExpiredException ? new ZkSessionExpiredException(sessionId, "Session expired.", e) : (e instanceof KeeperException.NoNodeException ? new ZkNoSuchNodeException(sessionId, ((KeeperException.NoNodeException)e).getPath(), "No such node.", e) : (e instanceof KeeperException ? ((ke = (KeeperException)e).code() == KeeperException.Code.BADVERSION ? new ZkStaleDataException(sessionId, "Stale data.", (Throwable)ke) : new ZkException(sessionId, "Zookeeper exception.", e)) : (e instanceof ZkException ? (ZkException)e : new ZkException(sessionId, "Unexpected error.", e))))));
        return ez;
    }

    public ZkException(long sessionId, String message) {
        this.sessionId = sessionId;
        this.message = message;
    }

    public ZkException(long sessionId, String message, Throwable cause) {
        super(null, cause);
        this.sessionId = sessionId;
        this.message = message;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getMessage() {
        if (this.extMessage == null) {
            StringBuilder b = new StringBuilder();
            b.append(String.format("Session 0x%x ", this.sessionId));
            if (this.args != null) {
                b.append("[ ");
                int i = 0;
                for (Map.Entry<String, String> k : this.args.entrySet()) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append(k.getKey());
                    b.append("=");
                    b.append(k.getValue());
                    ++i;
                }
                b.append(" ]");
            }
            b.append(": ");
            b.append(this.message);
            this.extMessage = b.toString();
        }
        return this.extMessage;
    }
}

