/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client;

import com.ez.keeper.client.ZkEvent;
import com.ez.keeper.client.ZkEventType;
import com.ez.keeper.client.ZkNodeEvent;
import com.ez.keeper.client.ZkRequestEvent;
import com.ez.keeper.client.ZkSessionEvent;
import com.ez.keeper.client.request.ZkRequest;
import com.ez.keeper.client.request.ZkResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class ZkEvents {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static boolean isConnectionEvent(WatchedEvent e) {
        return e.getPath() == null;
    }

    public static boolean isNodeDeletedEvent(WatchedEvent e) {
        return e.getType().equals((Object)Watcher.Event.EventType.NodeDeleted);
    }

    public static ZkRequestEvent createRequestEvent(ZkRequest request, ZkResult r) {
        return new ZkRequestEvent(request, r);
    }

    public static ZkRequestEvent createRequestEvent(ZkRequest request, Exception ex) {
        return new ZkRequestEvent(request, ex);
    }

    public static ZkEvent createFromWatchedEvent(WatchedEvent e) {
        ZkEvent newEvent;
        if (ZkEvents.isConnectionEvent(e)) {
            newEvent = new ZkSessionEvent(ZkEventType.ConnectionStateChanged, e.getState());
        } else {
            ZkEventType newType = ZkEventType.fromEventType(e.getType());
            if (newType == null) {
                throw new IllegalArgumentException("Can't map type " + e.getType());
            }
            newEvent = new ZkNodeEvent(newType, e.getPath(), null, null);
        }
        return newEvent;
    }
}

