/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client;

import com.ez.keeper.client.ZkEvent;
import com.ez.keeper.client.ZkEventListenerAdapter;
import com.ez.keeper.client.ZkNodeEvent;
import com.ez.keeper.client.ZkRequestEvent;
import com.ez.keeper.client.ZkSessionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.zookeeper.Watcher;

public abstract class ZkEventType {
    public static final int USER_EVENT_CODE = 1000;
    public static final ZkEventType NodeCreated = new ZkEventType(Watcher.Event.EventType.NodeCreated, 0, "NodeCreated"){

        @Override
        public void dispatch(ZkEvent e, ZkEventListenerAdapter la) {
            la.notifyNodeCreated((ZkNodeEvent)e);
        }
    };
    public static final ZkEventType NodeDeleted = new ZkEventType(Watcher.Event.EventType.NodeDeleted, 1, "NodeDeleted"){

        @Override
        public void dispatch(ZkEvent e, ZkEventListenerAdapter la) {
            la.notifyNodeDeleted((ZkNodeEvent)e);
        }
    };
    public static final ZkEventType DataChanged = new ZkEventType(Watcher.Event.EventType.NodeDataChanged, 2, "DataChanged"){

        @Override
        public void dispatch(ZkEvent e, ZkEventListenerAdapter la) {
            la.notifyNodeDataChanged((ZkNodeEvent)e);
        }
    };
    public static final ZkEventType NodeChildrenChanged = new ZkEventType(Watcher.Event.EventType.NodeChildrenChanged, 3, "NodeChildrenChanged"){

        @Override
        public void dispatch(ZkEvent e, ZkEventListenerAdapter la) {
            la.notifyNodeChildrenChanged((ZkNodeEvent)e);
        }
    };
    public static final ZkEventType NodeDataAvailable = new ZkEventType(null, 4, "NodeDataAvailable"){

        @Override
        public void dispatch(ZkEvent e, ZkEventListenerAdapter la) {
            la.notifyNodeDataAvailable((ZkNodeEvent)e);
        }
    };
    public static final ZkEventType NodeChildrenAvailable = new ZkEventType(null, 5, "NodeChildrenAvailable"){

        @Override
        public void dispatch(ZkEvent e, ZkEventListenerAdapter la) {
            la.notifyChildrenAvailable((ZkNodeEvent)e);
        }
    };
    public static final ZkEventType NodeStatAvailable = new ZkEventType(null, 6, "NodeStatAvailable"){

        @Override
        public void dispatch(ZkEvent e, ZkEventListenerAdapter la) {
            la.notifyNodeStatAvailable((ZkNodeEvent)e);
        }
    };
    public static final ZkEventType ConnectionStateChanged = new ZkEventType(null, 7, "ConnectionStateChanged"){

        @Override
        public void dispatch(ZkEvent e, ZkEventListenerAdapter la) {
            la.notifySessionEvent((ZkSessionEvent)e);
        }
    };
    public static final ZkEventType RequestFinished = new ZkEventType(null, 10, "RequestFinished"){

        @Override
        public void dispatch(ZkEvent e, ZkEventListenerAdapter la) {
            la.notifyRequestFinished((ZkRequestEvent)e);
        }
    };
    private int code;
    private Watcher.Event.EventType type;
    private String label;
    private String toString = null;

    protected ZkEventType(int code, String label) {
        this(null, code, label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZkEventType(Watcher.Event.EventType type, int code, String label) {
        this.code = code;
        this.type = type;
        this.label = label;
        Object object = G.GUARD;
        synchronized (object) {
            if (type != null) {
                ZkEventType ot = G.TYPES.put(type, this);
                if (ot != null) {
                    throw new IllegalArgumentException(type + " event type already registered.");
                }
                ot = G.CODES.put(code, this);
                if (ot != null) {
                    throw new IllegalArgumentException(code + "code already registered.");
                }
            }
        }
        this.createString();
    }

    public int getCode() {
        return this.code;
    }

    public abstract void dispatch(ZkEvent var1, ZkEventListenerAdapter var2);

    public static ZkEventType fromEventType(Watcher.Event.EventType e) {
        return (ZkEventType)G.TYPES.get(e);
    }

    public String toString() {
        return this.toString;
    }

    private void createString() {
        StringBuilder b = new StringBuilder("[");
        b.append(this.label);
        b.append(" eventType: ");
        b.append(this.type);
        b.append(", code: ");
        b.append(this.code);
        b.append("]");
        this.toString = b.toString();
    }

    private static class G {
        private static final Object GUARD = new Object();
        private static Map<Watcher.Event.EventType, ZkEventType> TYPES = new HashMap<Watcher.Event.EventType, ZkEventType>();
        private static Map<Integer, ZkEventType> CODES = new HashMap<Integer, ZkEventType>();

        private G() {
        }
    }
}

