/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client;

import com.ez.keeper.client.ZkEvent;
import com.ez.keeper.client.ZkEventListener;
import com.ez.keeper.client.ZkNodeEvent;
import com.ez.keeper.client.ZkRequestEvent;
import com.ez.keeper.client.ZkSessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZkEventListenerAdapter
implements ZkEventListener {
    private final Logger L = LoggerFactory.getLogger(this.getClass());

    @Override
    public void notifyEvent(ZkEvent e) {
        this.L.trace("Event received: " + e.toString());
        e.getType().dispatch(e, this);
    }

    public void notifySessionEvent(ZkSessionEvent e) {
        this.dontCare(e);
    }

    public void notifyNodeCreated(ZkNodeEvent e) {
        this.dontCare(e);
    }

    public void notifyNodeDeleted(ZkNodeEvent e) {
        this.dontCare(e);
    }

    public void notifyNodeDataChanged(ZkNodeEvent e) {
        this.dontCare(e);
    }

    public void notifyNodeChildrenChanged(ZkNodeEvent e) {
        this.dontCare(e);
    }

    public void notifyNodeDataAvailable(ZkNodeEvent e) {
        this.dontCare(e);
    }

    public void notifyChildrenAvailable(ZkNodeEvent e) {
        this.dontCare(e);
    }

    public void notifyNodeStatAvailable(ZkNodeEvent e) {
        this.dontCare(e);
    }

    public void notifyRequestFinished(ZkRequestEvent e) {
        this.dontCare(e);
    }

    protected void dontCare(ZkEvent e) {
    }
}

