/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client;

import com.ez.keeper.client.ZkApplicationScope;
import com.ez.keeper.client.ZkEventListener;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.ZkSessionConfiguration;
import com.ez.keeper.client.ZkSessionFactory;
import com.ez.keeper.client.ZkSessionImpl;
import com.ez.keeper.client.ZkSessionScope;
import com.ez.keeper.client.log4j.MDCLoggingProxy;
import com.ez.keeper.client.policy.ZkSessionPolicy;
import com.ez.keeper.client.session.RequestExecutorFactory;
import com.ez.keeper.client.session.ThreadRequestExecutorFactory;
import com.ez.keeper.client.session.ZkDefaultSession;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkDefaultSessionFactory
implements ZkSessionFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ZkDefaultSessionFactory.class);
    private Configuration conf;
    private final Object guard = new Object();
    private final ZkSessionScope scope;
    private State state = State.Created;
    private Set<ZkEventListener> eventListeners;
    private boolean noListenerWarn;
    private ZkSessionPolicy policy;
    private RequestExecutorFactory ref;

    public ZkDefaultSessionFactory(ZkSessionPolicy policy) {
        this(policy, null, new ZkApplicationScope(), null);
    }

    public ZkDefaultSessionFactory(ZkSessionPolicy policy, Configuration userConf) {
        this(policy, userConf, new ZkApplicationScope(), null);
    }

    public ZkDefaultSessionFactory(ZkSessionPolicy policy, Configuration userConf, ZkSessionScope scope) {
        this(policy, userConf, scope, null);
    }

    public ZkDefaultSessionFactory(ZkSessionPolicy policy, Configuration userConf, ZkSessionScope scope, RequestExecutorFactory ref) {
        if (scope == null) {
            throw new IllegalArgumentException("scope");
        }
        if (policy == null) {
            throw new IllegalArgumentException("policy");
        }
        this.conf = ZkDefaultSessionFactory.buildConfguration(userConf);
        this.policy = policy;
        this.scope = scope;
        this.eventListeners = new HashSet<ZkEventListener>();
        this.ref = ref == null ? new ThreadRequestExecutorFactory() : ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(ZkEventListener eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException("eventListener");
        }
        Set<ZkEventListener> set = this.eventListeners;
        synchronized (set) {
            this.eventListeners.add(eventListener);
            this.noListenerWarn = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ZkEventListener eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException("eventListener");
        }
        Set<ZkEventListener> set = this.eventListeners;
        synchronized (set) {
            this.eventListeners.remove(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZkSession getSession() {
        Object object = this.guard;
        synchronized (object) {
            if (this.state != State.Initialized) {
                throw new IllegalStateException((Object)((Object)this.state) + " expected " + (Object)((Object)State.Initialized));
            }
            final AtomicReference ref = new AtomicReference();
            this.scope.withLock(new ZkSessionScope.Action(){
                ZkDefaultSessionFactory f;
                {
                    this.f = ZkDefaultSessionFactory.this;
                }

                @Override
                public void doIt(ZkSessionScope scope, Object guard) {
                    ZkSession sessn = null;
                    ZkSessionImpl sessImpl = null;
                    L.trace("Acquiring session...");
                    sessn = this.f.scope.getSession();
                    if (sessn != null) {
                        sessImpl = (ZkSessionImpl)sessn;
                        if (sessImpl.isExpired()) {
                            L.trace("Current connection: " + sessn);
                            L.info("The current connection is expired, a new one will be created.");
                            sessn = null;
                        } else {
                            int referenceCount = sessImpl.increaseReference();
                            L.trace("Reference count: " + referenceCount);
                        }
                    }
                    if (sessn == null) {
                        L.info("Creating connection...");
                        String name = Thread.currentThread().getName();
                        sessImpl = new ZkDefaultSession(name, ZkDefaultSessionFactory.this, ZkDefaultSessionFactory.this.policy, ZkDefaultSessionFactory.this.conf);
                        ZkDefaultSession ds = (ZkDefaultSession)sessImpl;
                        sessImpl.setRequestExecutor(this.f.ref.create(ds.getMDCContextValue()));
                        sessImpl.initialize();
                        sessn = MDCLoggingProxy.createProxy(sessImpl, ZkSessionImpl.class, "ezkid", ds.getMDCContextValue());
                        this.f.scope.putSession(sessn);
                        L.info("Connection created: " + sessn);
                    }
                    ref.set(sessn);
                }
            });
            return (ZkSession)ref.get();
        }
    }

    @Override
    public void release(ZkSession s) {
        if (s == null) {
            throw new IllegalArgumentException("connection");
        }
        if (this.state != State.Initialized) {
            throw new IllegalStateException((Object)((Object)this.state) + " expected " + (Object)((Object)State.Initialized));
        }
        if (!(s instanceof ZkSessionImpl)) {
            throw new IllegalArgumentException("Not an instance of " + ZkSessionImpl.class);
        }
        final ZkSessionImpl session = (ZkSessionImpl)s;
        this.scope.withLock(new ZkSessionScope.Action(){

            @Override
            public void doIt(ZkSessionScope scope, Object guard) {
                L.trace("Leaving connection...");
                ZkSession currentConnection = ZkDefaultSessionFactory.this.scope.getSession();
                if (session != currentConnection) {
                    L.debug(String.format("Session 0x%x: connection is no longer the current scope.", session.getSessionId()));
                }
                int referenceCount = session.decreaseReference();
                L.trace("Reference count: " + referenceCount);
                if (referenceCount == 0) {
                    L.debug(String.format("Session 0x%x: reference count 0, destroying session...", session.getSessionId()));
                    session.uninitialize();
                    L.debug("Session destroyed.");
                }
                if ((session.isExpired() || referenceCount == 0) && session == currentConnection) {
                    ZkDefaultSessionFactory.this.scope.removeSession(session);
                    L.debug(String.format("Session 0x%x will be removed from the scope.", session.getSessionId()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.guard;
        synchronized (object) {
            if (this.state != State.Created) {
                throw new IllegalStateException((Object)((Object)this.state) + " expected " + (Object)((Object)State.Created));
            }
            this.state = State.Initialized;
            L.info("Factory initialized.");
            this.logConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninitialize() {
        Object object = this.guard;
        synchronized (object) {
            if (this.state != State.Initialized) {
                throw new IllegalStateException((Object)((Object)this.state) + " expected " + (Object)((Object)State.Initialized));
            }
            try {
                L.debug("Uninitializing factory...");
                this.scope.clear();
            }
            finally {
                this.state = State.Uninitialized;
            }
            L.debug("Factory uninitialized.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZkEventListener[] getEventListenersCopy() {
        Set<ZkEventListener> set = this.eventListeners;
        synchronized (set) {
            if (this.eventListeners.size() == 0) {
                if (!this.noListenerWarn) {
                    L.warn("No event listener set for factory.");
                    this.noListenerWarn = true;
                }
            } else {
                this.noListenerWarn = false;
            }
            return this.eventListeners.toArray(new ZkEventListener[0]);
        }
    }

    private static Configuration buildConfguration(Configuration userConf) {
        CompositeConfiguration mixedConf = new CompositeConfiguration();
        if (userConf == null) {
            L.warn("User configuration not supplied, default values will be used.");
        } else {
            mixedConf.addConfiguration(userConf);
        }
        mixedConf.addConfiguration(ZkSessionConfiguration.getInstance());
        return mixedConf;
    }

    private void logConfiguration() {
        if (L.isInfoEnabled()) {
            HashMap<String, Object> all = new HashMap<String, Object>();
            Iterator it = this.conf.getKeys();
            while (it.hasNext()) {
                String k = (String)it.next();
                all.put(k, this.conf.getProperty(k));
            }
            L.info("Session configuration: " + all);
        }
    }

    private static enum State {
        Created,
        Initialized,
        Uninitialized;

    }
}

