/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client;

import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.ZkSessionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkApplicationScope
implements ZkSessionScope {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ZkApplicationScope.class);
    private ZkSession session = null;
    private final Object guard = new Object();

    @Override
    public ZkSession getSession() {
        return this.session;
    }

    @Override
    public void removeSession(ZkSession s) {
        if (this.session == null) {
            throw new IllegalStateException("Not set yet.");
        }
        if (s != this.session) {
            throw new IllegalArgumentException("Session not found in scope: " + s);
        }
        this.session = null;
    }

    @Override
    public void clear() {
        if (this.session != null) {
            this.session = null;
            L.debug("Scope cleared.");
        } else {
            L.debug("Already cleared.");
        }
    }

    @Override
    public void putSession(ZkSession session) {
        if (this.session != null) {
            throw new IllegalStateException("Already set.");
        }
        L.debug("Session installed.");
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withLock(ZkSessionScope.Action what) {
        Object object = this.guard;
        synchronized (object) {
            what.doIt(this, this.guard);
        }
    }
}

