/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client;

public class StateUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static void assertTrue(Object actual, Object expected) {
        StateUtils.assertState(true, actual, new Object[]{expected});
    }

    public static void assertFalse(Object actual, Object expected) {
        StateUtils.assertState(false, actual, new Object[]{expected});
    }

    public static void assertTrue(Object actual, Object[] expected) {
        StateUtils.assertState(true, actual, expected);
    }

    public static void assertFalse(Object actual, Object[] expected) {
        StateUtils.assertState(false, actual, expected);
    }

    public static void assertState(boolean expected, Object actual, Object[] expectedState) {
        boolean found = false;
        for (Object s : expectedState) {
            if (actual != s) continue;
            found = true;
            break;
        }
        if (found != expected) {
            String expectedString;
            if (expectedState.length == 1) {
                expectedString = expectedState[0].toString();
            } else {
                StringBuilder b = new StringBuilder();
                for (Object s : expectedState) {
                    if (b.length() > 0) {
                        b.append(" | ");
                    }
                    b.append(s.toString());
                }
                expectedString = b.toString();
            }
            if (expected) {
                throw new IllegalStateException(String.format("Actual state is %s but %s was expected.", actual, expectedString));
            }
            throw new IllegalStateException(String.format("State %s not expected.", actual, expectedString));
        }
    }
}

