/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.service;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.rdz.IHook;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.rdz.resources.SearchResourceAction;
import com.ez.rdz.utils.Messages;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDZHookServiceImpl
implements IHook {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(RDZHookServiceImpl.class);
    private static final String PACKAGE_TO_LIB_SP = "EZViewer_ChangeMan_Package_Library";

    public RDZHookServiceImpl() {
        L.debug("RDZHook service impl started");
    }

    public void openRDZEditor(IProgressMonitor pmonitor, String mainframeProjectName, String path) {
        this.openRDZEditor(pmonitor, mainframeProjectName, path, 1, 0, 0);
    }

    public void openRDZEditor(IProgressMonitor pmonitor, String mainframeProjectName, String path, int lineNumber, int charStart, int charEnd) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.subTask(Messages.getString(RDZHookServiceImpl.class, (String)"monitor.acquireDbInfo"));
        String[] info = this.parsePath((IProgressMonitor)monitor.newChild(90), mainframeProjectName, path);
        String systemIp = info[0];
        String systemName = info[1];
        String libraryName = info[2];
        String memberName = info[3];
        if (pmonitor.isCanceled()) {
            throw new CanceledException("Job canceled");
        }
        if (systemIp != null) {
            SearchResourceAction searchResourceAction = new SearchResourceAction();
            searchResourceAction.run((IProgressMonitor)monitor.newChild(10), systemIp, libraryName, memberName, lineNumber, charStart, charEnd);
        } else {
            final String[] param = new String[]{systemName};
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getShells()[0], (String)Messages.getString(RDZHookServiceImpl.class, (String)"systemip.title"), (String)Messages.getString(RDZHookServiceImpl.class, (String)"systemip.message", (Object[])param));
                }
            });
        }
    }

    private String getSystemIp(IProgressMonitor pmonitor, EZSourceConnection conn, final String prjName, String systemName) {
        if (pmonitor.isCanceled()) {
            throw new CanceledException("Job canceled");
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        String[] systemIp = new String[1];
        if (conn == null) {
            L.error("EZSourceConnection is null!");
            throw new RuntimeException("null connection for project=" + prjName);
        }
        if (prjName == null) {
            L.debug("mainframeProjectName is null");
        }
        if (systemName == null) {
            L.info("systemName is null");
        }
        try {
            String query = String.format(RDZHookServiceImpl.analysisQuery(), systemName.toUpperCase());
            String[][] data = conn.executeSQL(query);
            monitor.worked(80);
            if (data == null) {
                L.error("sql data is null when search after MVSConnectionName {} !", (Object)systemName);
            }
            if (data != null && data.length > 0 && data[0].length > 0) {
                systemIp[0] = data[0][0];
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Display.getDefault().getShells()[0], (String)Messages.getString(RDZHookServiceImpl.class, (String)"dialog.information.title"), (String)Messages.getString(RDZHookServiceImpl.class, (String)"dialog.information.message", (Object[])new String[]{prjName}));
                }
            });
            L.error("getsystemIP({})", (Object)systemName, (Object)e);
        }
        monitor.setWorkRemaining(0);
        return systemIp[0];
    }

    private static String analysisQuery() {
        String query = "SELECT DISTINCT IPAddress FROM MFLPARInfo WHERE UPPER(MVSConnectionName) = '%s' ";
        return query;
    }

    public boolean isValidRdzPath(String path) {
        return path != null && path.toUpperCase().contains("\\" + "Mainframe Library Members".toUpperCase() + "\\") && !path.toUpperCase().contains("\\ENDEVOR\\") && !path.toUpperCase().contains("\\NATURAL\\") && !path.toUpperCase().contains("\\NATURAL DDM\\") && !path.toUpperCase().contains("\\NATURAL INCLUDE\\") && !path.toUpperCase().contains("\\NATURAL MAP\\");
    }

    public InputStream getFileContent(IProgressMonitor pmonitor, String mainframeProjectName, String path) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.subTask(Messages.getString(RDZHookServiceImpl.class, (String)"get.content"));
        InputStream is = null;
        String[] info = this.parsePath((IProgressMonitor)monitor.newChild(20), mainframeProjectName, path);
        String systemIp = info[0];
        if (systemIp != null) {
            String libraryName = info[2];
            String memberName = info[3];
            if (pmonitor.isCanceled()) {
                throw new CanceledException("Job canceled");
            }
            SearchResourceAction searchResourceAction = new SearchResourceAction();
            is = searchResourceAction.getResourceContent((IProgressMonitor)monitor.newChild(80), systemIp, libraryName, memberName);
        }
        return is;
    }

    private String[] parsePath(IProgressMonitor pmonitor, final String mainframeProjectName, String path) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.subTask(Messages.getString(RDZHookServiceImpl.class, (String)"monitor.parse.info"));
        final String[] ret = new String[4];
        final String[] splitStrings = path.split("\\\\");
        final boolean isChangeManBaseline = path.toLowerCase().contains("\\changeman\\baseline\\");
        final boolean isChangeManPackages = path.toLowerCase().contains("\\changeman\\packages\\");
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(mainframeProjectName, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                    String systemIp;
                    String systemName;
                    String libraryName;
                    String memberName;
                    SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
                    if (!isChangeManBaseline && !isChangeManPackages) {
                        memberName = splitStrings[splitStrings.length - 1];
                        libraryName = splitStrings[splitStrings.length - 2];
                        systemName = splitStrings[splitStrings.length - 4];
                        L.debug("not ChangeMan: membername {}, libname {}, systemName {} ", new Object[]{memberName, libraryName, systemName});
                        systemIp = RDZHookServiceImpl.this.getSystemIp((IProgressMonitor)monitor, conn, mainframeProjectName, systemName);
                    } else if (isChangeManPackages) {
                        block12: {
                            memberName = splitStrings[splitStrings.length - 1];
                            systemName = splitStrings[splitStrings.length - 6];
                            String memberType = splitStrings[splitStrings.length - 2];
                            String pack = splitStrings[splitStrings.length - 3];
                            L.debug("package ChangeMan: membername {}, systemName {}, memberType {}, pack {} ", new Object[]{memberName, systemName, memberType, pack});
                            Object[] param = new Object[]{pack, memberName, memberType};
                            systemIp = RDZHookServiceImpl.this.getSystemIp((IProgressMonitor)monitor.newChild(50), conn, mainframeProjectName, systemName);
                            String[] res = new String[1];
                            if (systemIp != null) {
                                try {
                                    try {
                                        List<EZSourceDataType> ltypes = Arrays.asList(new EZSourceDataType[3]);
                                        Collections.fill(ltypes, EZSourceDataType.String);
                                        String[][] results = conn.execNonTransactionalStoredProc(RDZHookServiceImpl.PACKAGE_TO_LIB_SP, param);
                                        if (results != null && results.length > 0) {
                                            res[0] = results[0][0];
                                        }
                                    }
                                    catch (Exception e) {
                                        L.error("error when do query for package to library", (Throwable)e);
                                        libraryName = res != null && res.length > 0 ? res[0] : null;
                                        L.debug("package ChangeMan: libraryName {}", (Object)libraryName);
                                        break block12;
                                    }
                                }
                                catch (Throwable throwable) {
                                    String libraryName2 = res != null && res.length > 0 ? res[0] : null;
                                    L.debug("package ChangeMan: libraryName {}", (Object)libraryName2);
                                    throw throwable;
                                }
                                libraryName = res != null && res.length > 0 ? res[0] : null;
                                L.debug("package ChangeMan: libraryName {}", (Object)libraryName);
                            } else {
                                L.warn("package ChangeMan: system ip not found for systemname {} in project {}", (Object)systemName, (Object)mainframeProjectName);
                                libraryName = null;
                            }
                        }
                        monitor.setWorkRemaining(0);
                    } else {
                        memberName = splitStrings[splitStrings.length - 1];
                        libraryName = splitStrings[splitStrings.length - 3];
                        systemName = splitStrings[splitStrings.length - 7];
                        L.debug("baseline ChangeMan: membername {}, libname {}, systemName {} ", new Object[]{memberName, libraryName, systemName});
                        systemIp = RDZHookServiceImpl.this.getSystemIp((IProgressMonitor)monitor, conn, mainframeProjectName, systemName);
                    }
                    ret[0] = systemIp;
                    ret[1] = systemName;
                    ret[2] = libraryName;
                    ret[3] = memberName;
                }
            }, LockType.Shared, (IProgressMonitor)monitor);
        }
        catch (InterruptedException | RuntimeException | ExecutionException exception) {
            L.error("error when trying to parse path {} for project {}", (Object)path, (Object)mainframeProjectName);
        }
        return ret;
    }
}

