/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe;

import com.ez.rdz.resources.mainframe.analysis.IResourceIdentifier;
import com.ez.rdz.resources.mainframe.analysis.RDZDataSetIdentifier;
import com.ez.rdz.resources.mainframe.analysis.RDZMainframeAnalysisJob;
import com.ez.rdz.resources.mainframe.analysis.RDZPartitionedDataSetMemberIdentifier;
import com.ez.rdz.utils.Messages;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMainframeAnalysisAction
implements IObjectActionDelegate {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GetMainframeAnalysisAction.class);
    private final Set<IResourceIdentifier> rdzResourceIdentifiers = new LinkedHashSet<IResourceIdentifier>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.rdzResourceIdentifiers.size() == 0) {
            MessageDialog.openInformation((Shell)Display.getDefault().getShells()[0], (String)Messages.getString(GetMainframeAnalysisAction.class, (String)"messageDialog.resutl.title"), (String)Messages.getString(GetMainframeAnalysisAction.class, (String)"messageDialog.resutl.msg"));
        } else {
            GetMainframeAnalysisAction.getAnalysis(action, this.rdzResourceIdentifiers);
        }
    }

    private static void getAnalysis(IAction action, Set<IResourceIdentifier> rdzResourceIdentifiers) {
        new RDZMainframeAnalysisJob(Messages.getString(GetMainframeAnalysisAction.class, (String)"job.rdzAnalysis.name"), rdzResourceIdentifiers).schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        block26: {
            this.rdzResourceIdentifiers.clear();
            if (!(selection instanceof IStructuredSelection)) break block26;
            IStructuredSelection currentSelection = (IStructuredSelection)selection;
            for (Object item : currentSelection) {
                L.debug("\t------> {}", item.getClass());
                Object resRef = this.runWithReflection(item, "getReferent", new Class[0]);
                if (resRef == null) {
                    L.debug("use getPhysicalResource method");
                    resRef = this.runWithReflection(item, "getPhysicalResource", new Class[0]);
                }
                if (resRef == null) continue;
                Object osImage = this.runWithReflection(resRef, "getSystem", new Class[0]);
                String systemIp = null;
                if (osImage != null) {
                    systemIp = (String)this.runWithReflection(osImage, "getIpAddress", new Class[0]);
                }
                String libraryName = null;
                Object partitionedDs = this.runWithReflection(resRef, "getDataset", new Class[0]);
                if (partitionedDs != null) {
                    libraryName = (String)this.runWithReflection(partitionedDs, "getName", new Class[0]);
                    String memberName = (String)this.runWithReflection(resRef, "getNameWithoutExtension", new Class[0]);
                    if (memberName != null && libraryName != null && systemIp != null) {
                        this.rdzResourceIdentifiers.add((IResourceIdentifier)new RDZPartitionedDataSetMemberIdentifier(systemIp, libraryName, memberName));
                        continue;
                    }
                    L.debug("coudn't resolve systemip, libraryName or membername for {}", item);
                    continue;
                }
                libraryName = (String)this.runWithReflection(resRef, "getName", new Class[0]);
                String type = (String)this.runWithReflection(resRef, "getResourceType", new Class[0]);
                if (type == null) {
                    type = resRef.getClass().getSimpleName();
                }
                if (type == null) continue;
                String typeName = null;
                switch (type) {
                    case "PHYSICAL_SEQUENTIAL_DATASET": 
                    case "ZOSSequentialDataSetImpl": {
                        typeName = Messages.getString(GetMainframeAnalysisAction.class, (String)"rdz.ResourceIdentifier.SequentialDataSet");
                        break;
                    }
                    case "ZOSPartitionedDataSetImpl": 
                    case "PHYSICAL_PARTITIONED_DATASET": {
                        typeName = Messages.getString(GetMainframeAnalysisAction.class, (String)"rdz.ResourceIdentifier.PartitionedDataSet");
                        break;
                    }
                    case "ZOSVsamDataSetImpl": 
                    case "PHYSICAL_VSAM_DATASET": {
                        typeName = Messages.getString(GetMainframeAnalysisAction.class, (String)"rdz.ResourceIdentifier.VsamDataSet");
                    }
                }
                if (systemIp != null && libraryName != null && typeName != null) {
                    this.rdzResourceIdentifiers.add((IResourceIdentifier)new RDZDataSetIdentifier(systemIp, libraryName, typeName));
                    continue;
                }
                L.debug("coudn't resolve systemip, libraryName or membername for {}", item);
            }
        }
    }

    public Object runWithReflection(Object obj, String methodName, Class ... parameterTypes) {
        Object result = null;
        try {
            Class<?> cls = obj.getClass();
            Method method = cls.getMethod(methodName, parameterTypes);
            result = method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            L.debug("exception when search methodName {}  with class {} ", new Object[]{methodName, obj.getClass().getName(), e});
        }
        return result;
    }
}

