/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources;

import com.ez.rdz.utils.Messages;
import com.ibm.ftt.resources.core.physical.IOSImage;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.core.physical.PhysicalSystemRegistry;
import com.ibm.ftt.resources.core.physicalfactory.PhysicalSystemRegistryFactory;
import com.ibm.ftt.resources.zos.zosfactory.ZOSResourceIdentifier;
import com.ibm.ftt.resources.zos.zosfactory.ZosfactoryFactory;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSDataSetMember;
import com.ibm.ftt.ui.resources.core.editor.EditorOpener;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResourceAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SearchResourceAction.class);
    private static PhysicalSystemRegistry systemRegistry = null;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IProgressMonitor pmonitor, String systemIp, String pdsName, String memberName, int lineNumber, int charStart, int charEnd) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1);
        monitor.subTask(Messages.getString(SearchResourceAction.class, (String)"monitor.subTask.openResource"));
        if (this.systemDefined()) {
            this.open(true, systemIp, pdsName, memberName, lineNumber, charStart, charEnd);
        }
        monitor.done();
    }

    public InputStream getResourceContent(IProgressMonitor pmonitor, String systemIp, String pdsName, String memberName) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1);
        monitor.subTask(Messages.getString(SearchResourceAction.class, (String)"monitor.subTask.contentResource"));
        InputStream is = null;
        if (this.systemDefined()) {
            is = this.getContent(false, systemIp, pdsName, memberName);
        }
        monitor.done();
        return is;
    }

    private void open(final boolean readOnly, final String systemIp, final String pdsName, final String memberName, final int lineNumber, int charStart, int charEnd) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IPhysicalResource resource = SearchResourceAction.this.findResource(systemIp, pdsName, memberName);
                    EditorOpener opener = EditorOpener.getInstance();
                    if (readOnly) {
                        opener.browse((Object)resource);
                    } else {
                        opener.open((Object)resource);
                    }
                    opener.gotoLine((Object)resource, lineNumber, -1, -1);
                }
                catch (Exception e) {
                    String msg;
                    if (systemIp != null) {
                        String pdsmsg = pdsName != null ? " " + pdsName : "";
                        String membermsg = memberName != null ? " (" + memberName + ")" : "";
                        msg = Messages.getString(SearchResourceAction.class, (String)"messageDialog.resourceNotFound.fulldetails.message", (Object[])new String[]{systemIp, pdsmsg, membermsg});
                    } else {
                        msg = Messages.getString(SearchResourceAction.class, (String)"messageDialog.resourceNotFound.genericmessage");
                    }
                    MessageDialog.openInformation((Shell)Display.getDefault().getShells()[0], (String)Messages.getString(SearchResourceAction.class, (String)"messageDialog.resourceNotFound.title"), (String)msg);
                    L.error("While opening resource with systemIP={}, pdsName={}, memberName={}", new Object[]{systemIp, pdsName, memberName, e});
                }
            }
        });
    }

    private InputStream getContent(boolean readOnly, final String systemIp, final String pdsName, final String memberName) {
        final InputStream[] result = new InputStream[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IPhysicalResource resource = SearchResourceAction.this.findResource(systemIp, pdsName, memberName);
                    if (resource != null) {
                        result[0] = ((ZOSDataSetMember)resource).getContents();
                    }
                }
                catch (Exception e) {
                    String msg;
                    if (systemIp != null) {
                        String pdsmsg = pdsName != null ? " " + pdsName : "";
                        String membermsg = memberName != null ? " (" + memberName + ")" : "";
                        msg = Messages.getString(SearchResourceAction.class, (String)"messageDialog.resourceNotFound.fulldetails.message", (Object[])new String[]{systemIp, pdsmsg, membermsg});
                    } else {
                        msg = Messages.getString(SearchResourceAction.class, (String)"messageDialog.resourceNotFound.genericmessage");
                    }
                    MessageDialog.openInformation((Shell)Display.getDefault().getShells()[0], (String)Messages.getString(SearchResourceAction.class, (String)"messageDialog.resourceNotFound.title"), (String)msg);
                    L.error("While opening resource with systemIP={}, pdsName={}, memberName={}", new Object[]{systemIp, pdsName, memberName, e});
                }
            }
        });
        return result[0];
    }

    private boolean systemDefined() {
        boolean returnVal = false;
        PhysicalSystemRegistry systemRegistry = this.computeWithInvoke();
        if (systemRegistry != null) {
            Object[] systemReferences = systemRegistry.getSystems(2);
            if (systemReferences.length == 0) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)Display.getDefault().getShells()[0], (String)Messages.getString(SearchResourceAction.class, (String)"messageDialog.noSystemDefined.title"), (String)Messages.getString(SearchResourceAction.class, (String)"messageDialog.noSystemDefined.msg"));
                    }
                });
            } else {
                returnVal = true;
            }
        }
        return returnVal;
    }

    private IPhysicalResource findResource(String systemIp, String dataset, String member) {
        ZOSResourceIdentifier identifier = ZosfactoryFactory.eINSTANCE.createZOSResourceIdentifier();
        String systemName = this.getSystemName(systemIp);
        if (L.isDebugEnabled()) {
            L.debug("Finding resource for systemName: {} systemIp: {} libraryName: {} memberName: {}", new Object[]{systemName, systemIp, dataset, member});
        }
        IPhysicalResource res = null;
        if (systemName != null) {
            identifier.setDataSetName(dataset);
            identifier.setMemberName(member);
            identifier.setSystem(systemName);
            Class<?> findercls = null;
            Class<?> paramcls = null;
            try {
                findercls = Class.forName("com.ibm.ftt.resources.zos.zosfactory.impl.ZOSPhysicalResourceFinder");
                paramcls = Class.forName("com.ibm.ftt.resources.core.factory.IResourceFilter");
            }
            catch (ClassNotFoundException e) {
                L.debug("method class or method parameter class not found", (Throwable)e);
            }
            if (findercls == null || paramcls == null) {
                try {
                    findercls = Class.forName("com.ibm.ftt.resources.zos.zosfactory.ZOSPhysicalResourceFinder");
                    paramcls = Class.forName("com.ibm.ftt.resources.zos.zosfactory.ZOSResourceIdentifier");
                }
                catch (ClassNotFoundException e) {
                    L.debug("method class or method parameter class not found", (Throwable)e);
                }
            }
            try {
                Method findPhysicalResourceMethod = findercls.getMethod("findPhysicalResource", paramcls);
                if (findPhysicalResourceMethod != null) {
                    Field instanceField = findercls.getField("eINSTANCE");
                    res = (IPhysicalResource)findPhysicalResourceMethod.invoke(instanceField.get(null), identifier);
                }
            }
            catch (Exception ex) {
                L.debug("method not found", (Throwable)ex);
            }
        }
        if (res == null) {
            L.debug("Resource not found");
        } else {
            L.debug("Resource found: {}", res);
        }
        return res;
    }

    private String getSystemName(String systemIp) {
        PhysicalSystemRegistry systemRegistry = this.computeWithInvoke();
        String systemName = systemIp;
        if (systemRegistry != null) {
            Object[] systemReferences;
            Object[] objectArray = systemReferences = systemRegistry.getSystems(2);
            int n = systemReferences.length;
            int n2 = 0;
            while (n2 < n) {
                String sysIp;
                Object systemRef = objectArray[n2];
                if (systemRef instanceof IOSImage && (sysIp = ((IOSImage)systemRef).getIpAddress()).equals(systemIp)) {
                    systemName = ((IOSImage)systemRef).getName();
                    break;
                }
                ++n2;
            }
        }
        return systemName;
    }

    private PhysicalSystemRegistry computeWithInvoke() {
        if (systemRegistry == null) {
            Class<PhysicalSystemRegistryFactory> factoryCls = PhysicalSystemRegistryFactory.class;
            try {
                Method singletonMethod = factoryCls.getMethod("getSingleton", new Class[0]);
                Class<?> returnTypeCls = singletonMethod.getReturnType();
                Object systemRegistryObj = singletonMethod.invoke(null, new Object[0]);
                systemRegistry = (PhysicalSystemRegistry)systemRegistryObj;
                if (L.isDebugEnabled()) {
                    if (PhysicalSystemRegistry.class.equals(returnTypeCls)) {
                        L.debug("return type for PhysicalSystemRegistryFactory.getSingleton is PhysicalSystemRegistry");
                    } else {
                        L.debug("return type for PhysicalSystemRegistryFactory.getSingleton is itf IPhysicalSystemRegistry");
                    }
                }
            }
            catch (Exception e) {
                L.error("could not invoke method PhysicalSystemRegistryFactory.getSingleton() ", (Throwable)e);
            }
        }
        return systemRegistry;
    }
}

