/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.zookeeper;

import com.ez.eclient.environment.Environment;
import com.ez.eclient.environment.preferences.EnvironmentPreferences;
import com.ez.eclient.zookeeper.Activator;
import com.ez.eclient.zookeeper.internal.Messages;
import com.ez.keeper.client.ZkDefaultSessionFactory;
import com.ez.keeper.client.ZkEventListener;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.ZkSessionFactory;
import com.ez.keeper.client.policy.ZkPolicies;
import com.ez.ssdp.ServiceLocation;
import java.util.Set;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkSessionFactoryAdaptor
implements ZkSessionFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private final Logger L = LoggerFactory.getLogger(ZkSessionFactoryAdaptor.class);
    public static final String CONF_SERVER_WORKING_DIR = "working/cc";
    public static final boolean ENABLE_LOCAL_CONF_SERVER = System.getProperty("ENABLE_LOCAL_CONF_SERVER") != null;
    private static final Object G = new Object();
    private ZkSessionFactory sessionFactory;

    public ZkSession getSession() {
        return this.sessionFactory.getSession();
    }

    public void registerListener(ZkEventListener l) {
        this.sessionFactory.registerListener(l);
    }

    public void release(ZkSession s) {
        this.sessionFactory.release(s);
    }

    public void removeListener(ZkEventListener l) {
        this.sessionFactory.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initZooKeeperService(ComponentContext ctx) {
        Object object = G;
        synchronized (object) {
            this.initClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninitZooKeeperService(ComponentContext ctx) {
        Object object = G;
        synchronized (object) {
            this.uninitClient();
        }
    }

    private Environment getEnvironment() {
        Environment e = null;
        Plugin p = Activator.getPlugin();
        try {
            e = EnvironmentPreferences.getEnvironment();
            if (e == null) {
                String msg = "Environment not set, remote objects (projects, configuration data) will not be available.";
                this.L.error(msg);
                p.getLog().log((IStatus)new Status(4, p.getBundle().getSymbolicName(), Messages.getString(ZkSessionFactoryAdaptor.class, "log.error.environment.not.set")));
            }
        }
        catch (Exception ex) {
            String msg = "Can't read environment preference, remote objects (projects, configuration data) will not be available.";
            this.L.error(msg, (Throwable)ex);
            p.getLog().log((IStatus)new Status(4, p.getBundle().getSymbolicName(), Messages.getString(ZkSessionFactoryAdaptor.class, "log.error.environment.preference"), (Throwable)ex));
        }
        return e;
    }

    private void initClient() {
        Environment e = null;
        BaseConfiguration c = null;
        e = this.getEnvironment();
        if (e == null) {
            this.L.info("Can't take the environment settings, falling back to local connection.");
        } else {
            Set sls = e.getLocations();
            c = new BaseConfiguration();
            if (sls.size() > 1) {
                this.L.error("Multiple locations not supported (yet): " + e);
            }
            ServiceLocation sl = (ServiceLocation)sls.iterator().next();
            this.L.info("Session factory configured with " + sl);
            c.setProperty("zookeeper.host", (Object)sl.getHost());
            c.setProperty("zookeeper.port", (Object)sl.getPort());
        }
        this.sessionFactory = c != null ? new ZkDefaultSessionFactory(ZkPolicies.POLICY_EVERGREEN, (Configuration)c) : new ZkDefaultSessionFactory(ZkPolicies.POLICY_EVERGREEN);
        ((ZkDefaultSessionFactory)this.sessionFactory).initialize();
    }

    private void uninitClient() {
        try {
            ((ZkDefaultSessionFactory)this.sessionFactory).uninitialize();
        }
        catch (Exception ex) {
            this.L.error("Can't uninitialize session factory.", (Throwable)ex);
        }
    }
}

