/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.bridge.internal;

import com.ez.internal.utils.PathUtils;
import com.ez.workspace.bridge.BridgeConfiguratorPropertiesService;
import java.io.File;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String EXTENSION_POINT = "com.ez.workspace.bridge.service";
    static final String BRIDGE_FRAGMENT_PLUGIN_ID = "com.ez.workspace.bridge";
    private static Logger L;
    private static Object NTLMAUT_DLL_PATH_GUARD;
    private static String NTLMAUT_DLL_PATH;

    static {
        NTLMAUT_DLL_PATH_GUARD = new Object();
        NTLMAUT_DLL_PATH = System.getProperty("java.library.path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNtlmAuthPath() {
        Object object = NTLMAUT_DLL_PATH_GUARD;
        synchronized (object) {
            return NTLMAUT_DLL_PATH;
        }
    }

    public void start(BundleContext context) throws Exception {
        L = LoggerFactory.getLogger(this.getClass());
        L.debug("loading initializer");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT);
        if (point == null) {
            L.error("{} was not properly registered", (Object)EXTENSION_POINT);
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            if (configElements != null) {
                int j = 0;
                while (j < configElements.length) {
                    IContributor contributor = configElements[j].getContributor();
                    Bundle contributorBundle = Platform.getBundle((String)contributor.getName());
                    Class instClass = null;
                    String clazz = configElements[j].getAttribute("class");
                    try {
                        instClass = contributorBundle.loadClass(clazz);
                    }
                    catch (ClassNotFoundException ex) {
                        L.error("could not load {}", (Object)clazz, (Object)ex);
                    }
                    if (instClass != null) {
                        try {
                            context.registerService(BridgeConfiguratorPropertiesService.class.getName(), instClass.newInstance(), null);
                        }
                        catch (Exception ex) {
                            L.error("could not register service {}", (Object)instClass, (Object)ex);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.checkStaticFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStaticFiles() {
        String bridgeDllPath = this.getBridgeDllPath();
        if (bridgeDllPath != null) {
            if (this.getClass().getResource(bridgeDllPath) != null) {
                PathUtils.copyResource((String)BRIDGE_FRAGMENT_PLUGIN_ID, (String)bridgeDllPath, (File)PathUtils.METADATA_FOLDER);
            }
            Object object = NTLMAUT_DLL_PATH_GUARD;
            synchronized (object) {
                int idx = bridgeDllPath.indexOf("/ntlmauth.dll");
                if (idx > 0) {
                    String path = bridgeDllPath.substring(0, idx);
                    File output = new File(PathUtils.METADATA_FOLDER, path);
                    if (output.isDirectory()) {
                        path = output.getAbsolutePath();
                    }
                    NTLMAUT_DLL_PATH = path;
                    L.info("bridge dll path={}", (Object)NTLMAUT_DLL_PATH);
                } else {
                    L.warn("bridgeDllPath not contains dll name; it will ignore it");
                }
            }
        } else {
            L.info("no path found for ntlmauth.dll");
        }
    }

    private String getBridgeDllPath() {
        String arch = System.getProperty("sun.arch.data.model", "32");
        String os = System.getProperty("os.name");
        String los = os.toLowerCase();
        StringBuilder pbuilder = new StringBuilder();
        pbuilder.append("/static/lib/");
        if (los.indexOf("linux") != -1) {
            L.info("assuming linux, not supported!!");
            pbuilder.append("/not_supported");
        } else if (los.indexOf("win") != -1) {
            L.info("assuming windows");
            if ("32".equals(arch)) {
                L.info("assuming 32 bit vm");
                pbuilder.append("win32");
            } else if ("64".equals(arch)) {
                L.info("assuming 64 bit vm");
                pbuilder.append("win64");
            } else {
                L.info("unknown arch: {}. assuming 32 bit", (Object)arch);
                pbuilder.append("win32");
            }
            pbuilder.append("/ntlmauth.dll");
        } else {
            L.info("could not detect OS: {}", (Object)os);
        }
        return pbuilder.toString();
    }

    public void stop(BundleContext context) throws Exception {
        ServiceReference serviceReference = context.getServiceReference(BridgeConfiguratorPropertiesService.class.getName());
        if (serviceReference != null) {
            context.ungetService(serviceReference);
        }
    }
}

