/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace;

import com.ez.ezsource.connection.EZSourceConnectionFactory;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.workspace.bridge.BridgeConfiguratorPropertiesService;
import com.ez.workspace.bridge.BridgeInitException;
import com.ez.workspace.bridge.IBridgeConfigurator;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeConfigurator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(BridgeConfigurator.class);
    private static int count = 0;
    static Pair<String, String> bridge = null;
    static IBridgeConfigurator configurator = null;

    static {
        BridgeConfiguratorPropertiesService srv = (BridgeConfiguratorPropertiesService)ServiceUtils.getService(BridgeConfiguratorPropertiesService.class);
        if (srv != null) {
            IBridgeConfigurator config = srv.getConfigurator();
            if (config != null) {
                BridgeConfigurator.setConfigurator(config);
            } else {
                L.error("service loaded ({}) returned a null configurator!", (Object)srv);
            }
        } else if (ServiceUtils.isOsgi()) {
            L.error("bridge properties cannot be loaded as the service cannot be found!");
        } else {
            L.info("bridge configuration service ({}) not found; wait for a custom configuration later", (Object)BridgeConfiguratorPropertiesService.class.getName());
        }
    }

    public static void setConfigurator(IBridgeConfigurator configurator) {
        L.info("custom bridge configuration");
        BridgeConfigurator.configurator = configurator;
    }

    private static void checkDBService() {
        Object dbService = ServiceUtils.getService((String)"com.ez.eclient.service.database.DatabaseService");
        L.trace("dbservice={}", dbService);
        if (dbService == null) {
            throw new BridgeInitException("no database service available; please wait!");
        }
    }

    public static boolean init() {
        BridgeConfigurator.checkDBService();
        if (configurator != null) {
            return BridgeConfigurator.init(configurator.getConnectionProperties());
        }
        throw new RuntimeException("BridgeConfiguration is missing; cannot continue!");
    }

    public static synchronized boolean init(Properties connectionProperties) {
        boolean ok = true;
        if (count <= 0) {
            L.debug("initialize bridge");
            try {
                EZSourceConnectionManager.initialize((Properties)connectionProperties);
            }
            catch (Throwable t) {
                ok = false;
                L.error("could not init bridge", t);
            }
            BridgeConfigurator.loadBridge(connectionProperties);
        }
        L.debug("init called. New count: {}", (Object)(++count));
        return ok;
    }

    public static synchronized boolean isReleased() {
        return count < 1;
    }

    public static EZSourceConnectionFactory getManager() {
        return EZSourceConnectionManager.getFactory();
    }

    private static void loadBridge(Properties connectionProperties) {
        bridge = new Pair();
        bridge.setFirst((Object)connectionProperties.getProperty("bridgeService.serverHost"));
        bridge.setSecond((Object)connectionProperties.getProperty("bridgeService.serverPort"));
    }

    public static synchronized void release() {
        L.debug("release called. Decrement count from: {}", (Object)count);
        if (count == 1) {
            L.debug("uninitialize bridge");
            EZSourceConnectionManager.uninitialize();
            --count;
        }
        if (count > 1) {
            --count;
        }
    }

    public static Pair<String, String> getBridge() {
        if (bridge == null && configurator != null) {
            BridgeConfigurator.loadBridge(configurator.getConnectionProperties());
        }
        return bridge;
    }
}

