/*
 * Decompiled with CFR 0.152.
 */
package com.ez.json.tools.validator;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonValidator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(JsonValidator.class);

    public static boolean validate(Reader r) throws IOException {
        boolean valid;
        block3: {
            valid = true;
            try {
                JsonReader jr = Json.createReader((Reader)r);
                jr.read();
            }
            catch (Exception ex) {
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                valid = false;
                if (!L.isTraceEnabled()) break block3;
                L.trace("Invalid JSON reader: " + r, (Throwable)ex);
            }
        }
        return valid;
    }

    public static boolean validate(String json) {
        boolean valid;
        block2: {
            valid = true;
            try {
                JsonReader jr = Json.createReader((Reader)new StringReader(json));
                jr.read();
            }
            catch (Exception ex) {
                valid = false;
                if (!L.isTraceEnabled()) break block2;
                L.trace("Invalid JSON: " + json, (Throwable)ex);
            }
        }
        return valid;
    }
}

