/*
 * Decompiled with CFR 0.152.
 */
package com.ez.json.tools.converter;

import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class PropertiesConverter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static void writeToProperties(JsonStructure js, Properties p) {
        LinkedList<Context> context = new LinkedList<Context>();
        context.add(new Context((JsonValue)js, ""));
        block9: while (!context.isEmpty()) {
            Context c = (Context)context.removeLast();
            JsonValue je = c.v;
            String seg = c.seg;
            switch (je.getValueType()) {
                case ARRAY: {
                    JsonArray a = (JsonArray)je;
                    for (int i = 0; i < a.size(); ++i) {
                        context.add(new Context((JsonValue)a.get(i), PropertiesConverter.concat(seg, String.valueOf(i))));
                    }
                    continue block9;
                }
                case OBJECT: {
                    JsonObject o = (JsonObject)je;
                    for (Map.Entry e : o.entrySet()) {
                        context.add(new Context((JsonValue)e.getValue(), PropertiesConverter.concat(seg, (String)e.getKey())));
                    }
                    continue block9;
                }
                case STRING: {
                    JsonString s = (JsonString)je;
                    p.setProperty(seg, s.getString());
                    break;
                }
                case NUMBER: {
                    JsonNumber n = (JsonNumber)je;
                    p.setProperty(seg, String.valueOf(n.intValue()));
                    break;
                }
                case NULL: {
                    p.setProperty(seg, "");
                    break;
                }
                case TRUE: {
                    p.setProperty(seg, "true");
                    break;
                }
                case FALSE: {
                    p.setProperty(seg, "false");
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported value type: " + je.getValueType());
                }
            }
        }
    }

    public static JsonStructure readFromProperties(Properties p) {
        throw new RuntimeException("Not implemented.");
    }

    private static String concat(String p, String c) {
        if (p == null || p.length() == 0) {
            return c;
        }
        return p + "." + c;
    }

    static class Context {
        JsonValue v;
        String seg;

        Context(JsonValue v, String seg) {
            this.v = v;
            this.seg = seg;
        }
    }
}

