/*
 * Decompiled with CFR 0.152.
 */
package com.ez.json.tools.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Path {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Path.class);
    public static final String PROPERTY_PATH = "([0-9a-zA-Z_]+|(\\[[0-9]+\\]))(([.][0-9a-zA-Z_]+|(\\[[0-9]+\\])))*";
    public static final String PROPERTY_KEY = "[.]([0-9a-zA-Z_]+)";
    public static final String PROPERTY_KEY1 = "[0-9a-zA-Z_]+";
    public static final String PROPERTY_INDEX = "\\[([0-9]+)\\]";
    public static final int FLAG_NONE = 0;
    public static final int FLAG_GET_IGNORE_MISMATCHED_VALUE_CLASS = 1;
    private static Pattern PP = Pattern.compile("([0-9a-zA-Z_]+|(\\[[0-9]+\\]))(([.][0-9a-zA-Z_]+|(\\[[0-9]+\\])))*");
    private static Pattern KP = Pattern.compile("[.]([0-9a-zA-Z_]+)");
    private static Pattern KP1 = Pattern.compile("[0-9a-zA-Z_]+");
    private static Pattern IP = Pattern.compile("\\[([0-9]+)\\]");

    public static Object deepClone(Object root) {
        HashMap r = null;
        Stack<Node> stack = new Stack<Node>();
        if (root == null) {
            throw new IllegalArgumentException("root");
        }
        class Node {
            Object parent;
            String key;
            Integer i;
            Object node;

            Node(Object node) {
                this.node = node;
            }

            Node(Object node, Map parent, String key) {
                this.node = node;
                this.parent = parent;
                this.key = key;
            }

            Node(Object node, List parent, int i) {
                this.node = node;
                this.parent = parent;
                this.i = i;
            }
        }
        stack.push(new Node(root));
        while (!stack.empty()) {
            List l;
            Node n = (Node)stack.pop();
            Cloneable o = n.node;
            Path.checkType(o);
            if (o instanceof Map) {
                HashMap m = o;
                o = m = new HashMap(m);
                for (Map.Entry e : m.entrySet()) {
                    Map.Entry te = e;
                    Object okey = te.getKey();
                    if (!(okey instanceof String)) {
                        throw new IllegalArgumentException("Illegal map key class " + okey.getClass());
                    }
                    String key = (String)okey;
                    stack.push(new Node(te.getValue(), m, key));
                }
            } else if (o instanceof List) {
                l = (ArrayList)o;
                l = new ArrayList(l);
                o = l;
                for (int i = 0; i < l.size(); ++i) {
                    stack.push(new Node(l.get(i), l, i));
                }
            }
            if (n.parent == null) {
                if (r != null) {
                    throw new RuntimeException("Internal error.");
                }
                r = o;
                continue;
            }
            if (n.key != null) {
                Map p = (Map)n.parent;
                p.put(n.key, o);
                continue;
            }
            if (n.i == null) continue;
            l = (List)n.parent;
            l.set(n.i, o);
        }
        return r;
    }

    public static Object getObject(Object root, String path, Class<?> valueClass, int flags) {
        Object value = Path.getObjectImpl(root, path, flags);
        if (value != null && valueClass != null && !valueClass.isAssignableFrom(value.getClass())) {
            if ((flags & 1) == 0) {
                throw new ClassCastException(String.format("Class not assignable to %s for value %s", valueClass, value));
            }
            L.warn(String.format("Class not assignable to %s for value %s, reset to %s", valueClass, value, null));
            value = null;
        }
        return value;
    }

    public static Object getObject(Object root, String path, Class<?> valueClass, Object defaultValue, int flags) {
        Object value = Path.getObjectImpl(root, path, flags);
        if (value == null) {
            value = defaultValue;
        } else if (valueClass != null && !valueClass.isAssignableFrom(value.getClass())) {
            if ((flags & 1) == 0) {
                throw new ClassCastException(String.format("Class not assignable to %s for value %s", valueClass, value));
            }
            L.warn(String.format("Class not assignable to %s for value %s, reset to %s", valueClass, value, defaultValue));
            value = defaultValue;
        }
        return value;
    }

    public static Object getObject(Object root, String path, Object defaultValue, int flags) {
        Object value = Path.getObjectImpl(root, path, flags);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static Object getObject(Object root, String path) {
        return Path.getObjectImpl(root, path, 0);
    }

    public static Object getObject(Object root, String path, int flags) {
        return Path.getObjectImpl(root, path, flags);
    }

    public static void setObject(Object root, String path, Object value) {
        Path.setObjectImpl(root, path, value, false, false);
    }

    public static void setProperty(Object root, String path, Object value) {
        Path.setObjectImpl(root, path, value, false, true);
    }

    public static void clearObject(Object root, String path) {
        Path.setObjectImpl(root, path, null, true, false);
    }

    public static void putObject(Object root, String path, String key, Object value) {
        HashMap mo = Path.getObject(root, path);
        if (mo != null && !(mo instanceof Map)) {
            throw new IllegalArgumentException("Not a map: " + path);
        }
        if (mo == null) {
            mo = new HashMap();
        }
        Map m = mo;
        m.put(key, value);
    }

    public static void addObject(Object root, String path, Object value) {
        LinkedList lo = Path.getObject(root, path);
        if (lo != null && !(lo instanceof List)) {
            throw new IllegalArgumentException("Not a list: " + path);
        }
        if (lo == null) {
            lo = new LinkedList();
        }
        List l = lo;
        l.add(value);
    }

    public static Object[] parsePath(String path) {
        LinkedList<Object> getters = new LinkedList<Object>();
        if (!PP.matcher(path).matches()) {
            throw new IllegalArgumentException("Invalid property path: " + path);
        }
        int i = 0;
        while (i < path.length()) {
            Matcher m;
            boolean found = false;
            if (getters.size() > 0) {
                m = KP.matcher(path);
                if (m.find(i) && m.start() == i) {
                    getters.add(path.substring(m.start(1), m.end(1)));
                    i = m.end();
                    found = true;
                }
            } else {
                m = KP1.matcher(path);
                if (m.find(i) && m.start() == i) {
                    getters.add(path.substring(m.start(), m.end()));
                    i = m.end();
                    found = true;
                }
            }
            if (!found && (m = IP.matcher(path)).find(i) && m.start() == i) {
                getters.add(Integer.parseInt(path.substring(m.start(1), m.end(1))));
                i = m.end();
                found = true;
            }
            if (found) continue;
            throw new RuntimeException("Internal error.");
        }
        return getters.toArray(new Object[0]);
    }

    static Object getObjectImpl(Object root, String path, int flags) {
        Object[] accessors = Path.parsePath(path);
        Object o = root;
        for (int i = 0; i < accessors.length && o != null; ++i) {
            Object a = accessors[i];
            if (a instanceof String) {
                String key = (String)a;
                if (!(o instanceof Map)) {
                    throw new RuntimeException("Not a map: " + o);
                }
                Map m = (Map)o;
                Object r = null;
                for (int i2 = i + 1; i2 < accessors.length && accessors[i2] instanceof String; ++i2) {
                }
                for (int j = i2 - 1; j >= i; --j) {
                    StringBuilder pb = new StringBuilder();
                    for (int k = i; k <= j; ++k) {
                        if (k > i) {
                            pb.append(".");
                        }
                        pb.append((String)accessors[k]);
                    }
                    String nk = pb.toString();
                    if (!m.containsKey(nk)) continue;
                    r = m.get(nk);
                    i = j;
                    break;
                }
                if (r != null) {
                    o = r;
                    continue;
                }
                o = m.get(key);
                continue;
            }
            if (a instanceof Integer) {
                Integer j = (Integer)a;
                if (!(o instanceof List)) {
                    throw new RuntimeException("Not a list: " + o);
                }
                List l = (List)o;
                o = l.get(j);
                continue;
            }
            throw new RuntimeException("Internal error: not supported accesor type: " + a.getClass());
        }
        return o;
    }

    static void setObjectImpl(Object root, String path, Object value, boolean clearNull, boolean greedyPath) {
        if (value != null) {
            Path.checkType(value);
        }
        Object[] accessors = Path.parsePath(path);
        Cloneable o = root;
        for (int i = 0; i < accessors.length && o != null; ++i) {
            Object a = accessors[i];
            if (a instanceof String) {
                int i2;
                String key = (String)a;
                if (!(o instanceof Map)) {
                    throw new RuntimeException("Not a map: " + o);
                }
                Map m = o;
                for (i2 = i + 1; i2 < accessors.length && accessors[i2] instanceof String; ++i2) {
                }
                if (greedyPath) {
                    StringBuilder pb = new StringBuilder();
                    for (int j = i; j < i2; ++j) {
                        if (j > i) {
                            pb.append(".");
                        }
                        pb.append((String)accessors[j]);
                    }
                    key = pb.toString();
                    i = i2 - 1;
                } else {
                    for (int j = i2 - 1; j >= i; --j) {
                        StringBuilder pb = new StringBuilder();
                        for (int k = i; k <= j; ++k) {
                            if (k > i) {
                                pb.append(".");
                            }
                            pb.append((String)accessors[k]);
                        }
                        String nk = pb.toString();
                        if (!m.containsKey(nk)) continue;
                        key = nk;
                        i = j;
                        break;
                    }
                }
                if (i < accessors.length - 1) {
                    o = m.get(key);
                    if (o != null || clearNull && value == null) continue;
                    Object na = accessors[i + 1];
                    o = na instanceof String ? new HashMap() : new LinkedList();
                    m.put(key, o);
                    continue;
                }
                if (clearNull && value == null) {
                    m.remove(key);
                    continue;
                }
                m.put(key, value);
                continue;
            }
            if (a instanceof Integer) {
                Integer index = (Integer)a;
                if (!(o instanceof List)) {
                    throw new RuntimeException("Not a list: " + o);
                }
                List l = (List)((Object)o);
                o = index < l.size() ? l.get(index) : null;
                if (i < accessors.length - 1) {
                    if (o != null || clearNull && value == null) continue;
                    Object na = accessors[i + 1];
                    o = na instanceof String ? new HashMap() : new LinkedList();
                    Path.expand(l, index);
                    l.set(index, o);
                    continue;
                }
                if (clearNull && value == null) {
                    if (index >= l.size()) continue;
                    l.set(index, null);
                    Path.shrink(l);
                    continue;
                }
                Path.expand(l, index);
                l.set(index, value);
                continue;
            }
            throw new RuntimeException("Internal error: not supported accesor type: " + a.getClass());
        }
    }

    private static void checkType(Object value) {
        if (!(value instanceof Long || value instanceof Integer || value instanceof String || value instanceof Boolean || value instanceof List || value instanceof Map)) {
            throw new IllegalArgumentException(String.format("Invalid class %s for value %s", value.getClass(), value));
        }
    }

    private static void expand(List l, int index) {
        if (index >= l.size()) {
            int size = l.size();
            for (int j = 0; j <= size - index; ++j) {
                l.add(null);
            }
        }
    }

    private static void shrink(List l) {
        int i = 0;
        while (i < l.size()) {
            if (l.get(i) == null) {
                l.remove(i);
                continue;
            }
            ++i;
        }
    }
}

