/*
 * Decompiled with CFR 0.152.
 */
package com.ez.json.tools.binding;

import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class JsonParser {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static Object parseJson(JsonStructure rootj) {
        ListOperator lo;
        MapOperator mo;
        Object root = null;
        Stack<Object> stack = new Stack<Object>();
        LinkedList<Symbol> evalList = new LinkedList<Symbol>();
        stack.push(rootj);
        while (!stack.empty()) {
            Object j = stack.pop();
            if (j instanceof JsonStructure) {
                if (j instanceof JsonObject) {
                    JsonObject jo = (JsonObject)j;
                    mo = new MapOperator(new HashMap(jo.size()), jo.size());
                    for (Map.Entry e : jo.entrySet()) {
                        stack.push(e.getValue());
                        stack.push(new MapKeyOperator((String)e.getKey()));
                    }
                    evalList.add(mo);
                    continue;
                }
                if (j instanceof JsonArray) {
                    JsonArray ja = (JsonArray)j;
                    lo = new ListOperator(new ArrayList(ja.size()), ja.size());
                    for (int i = ja.size() - 1; i >= 0; --i) {
                        stack.push(ja.get(i));
                    }
                    evalList.add(lo);
                    continue;
                }
                throw new RuntimeException("Unsupported JSON type: " + j.getClass());
            }
            if (j instanceof MapKeyOperator) {
                evalList.add((MapKeyOperator)j);
                continue;
            }
            if (j instanceof JsonString) {
                evalList.add(new Value(((JsonString)j).getString()));
                continue;
            }
            if (j instanceof JsonNumber) {
                evalList.add(new Value(((JsonNumber)j).bigDecimalValue()));
                continue;
            }
            JsonValue jv = (JsonValue)j;
            if (jv.getValueType().equals((Object)JsonValue.ValueType.NULL)) {
                evalList.add(new Value(null));
                continue;
            }
            if (jv.getValueType().equals((Object)JsonValue.ValueType.FALSE) || jv.getValueType().equals((Object)JsonValue.ValueType.TRUE)) {
                evalList.add(new Value(Boolean.valueOf(jv.toString())));
                continue;
            }
            throw new RuntimeException("Type not supported: " + j.getClass());
        }
        block3: while (evalList.size() > 1) {
            int i = evalList.size() - 1;
            do {
                Symbol arg;
                int j;
                Object o;
                if ((o = evalList.get(i)) instanceof MapKeyOperator) {
                    Symbol value = (Symbol)evalList.get(i + 1);
                    evalList.set(i, new JsonMapValue(((MapKeyOperator)o).key, value.get()));
                    evalList.remove(i + 1);
                    continue block3;
                }
                if (o instanceof MapOperator) {
                    mo = (MapOperator)o;
                    Map m = mo.m;
                    for (j = 0; j < mo.size; ++j) {
                        arg = (JsonMapValue)evalList.get(i + 1);
                        m.put(((JsonMapValue)arg).key, ((JsonMapValue)arg).value);
                        evalList.remove(i + 1);
                    }
                    evalList.set(i, new Value(m));
                    continue block3;
                }
                if (!(o instanceof ListOperator)) continue;
                lo = (ListOperator)o;
                List l = lo.l;
                for (j = 0; j < lo.size; ++j) {
                    arg = (Symbol)evalList.get(i + 1);
                    l.add(arg.get());
                    evalList.remove(i + 1);
                }
                evalList.set(i, new Value(l));
                continue block3;
            } while (--i >= 0);
        }
        root = ((Symbol)evalList.get(0)).get();
        return root;
    }

    public static Object parseJson(String json) {
        return JsonParser.parseJson(new StringReader(json));
    }

    public static Object parseJson(byte[] data) {
        try {
            return JsonParser.parseJson(new StringReader(new String(data, "utf8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object parseJson(Reader json) {
        JsonReader jsonReader = Json.createReader((Reader)json);
        try {
            JsonStructure rootj = jsonReader.read();
            Object object = JsonParser.parseJson(rootj);
            return object;
        }
        catch (Exception ex) {
            if (ex instanceof JsonException) {
                throw (JsonException)ex;
            }
            throw new JsonException("Can't parse json:" + json, (Throwable)ex);
        }
        finally {
            jsonReader.close();
        }
    }

    private static class JsonMapValue
    implements Symbol {
        String key;
        Object value;

        JsonMapValue(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Object get() {
            return this.value;
        }
    }

    private static class MapKeyOperator
    implements Symbol {
        String key;

        MapKeyOperator(String key) {
            this.key = key;
        }

        @Override
        public Object get() {
            return this.key;
        }
    }

    private static class ListOperator
    implements Symbol {
        List l;
        int size;

        ListOperator(List l, int size) {
            this.l = l;
            this.size = size;
        }

        @Override
        public Object get() {
            return this.l;
        }
    }

    private static class MapOperator
    implements Symbol {
        Map m;
        int size;

        MapOperator(Map m, int size) {
            this.m = m;
            this.size = size;
        }

        @Override
        public Object get() {
            return this.m;
        }
    }

    private static class Value
    implements Symbol {
        Object value;

        Value(Object value) {
            this.value = value;
        }

        @Override
        public Object get() {
            return this.value;
        }
    }

    private static interface Symbol {
        public Object get();
    }
}

