/*
 * Decompiled with CFR 0.152.
 */
package com.ez.json.tools.binding;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class JsonGenerator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static JsonValue generate(Object object) {
        Element e;
        if (object == null) {
            throw new IllegalArgumentException("object");
        }
        ArrayList<Element> fifo = new ArrayList<Element>();
        ArrayList<Element> stack = new ArrayList<Element>();
        Element rootElement = JsonGenerator.create(object, null, null);
        fifo.add(rootElement);
        while (!fifo.isEmpty()) {
            e = (Element)fifo.remove(0);
            ArrayList<Element> cl = e.children();
            if (cl != null) {
                for (int i = cl.size() - 1; i >= 0; --i) {
                    fifo.add(cl.get(i));
                }
            }
            stack.add(e);
        }
        while (!stack.isEmpty()) {
            e = (Element)stack.remove(stack.size() - 1);
            e.process();
        }
        return rootElement.build();
    }

    public static String toJsonString(Object o) {
        try {
            JsonValue v = JsonGenerator.generate(o);
            return v.toString();
        }
        catch (Exception ex) {
            if (ex instanceof JsonException) {
                throw (JsonException)ex;
            }
            throw new JsonException("Can't generate json:" + o.toString(), (Throwable)ex);
        }
    }

    static Element create(Object o, String key, Element p) {
        if (o instanceof Map) {
            return new MapElement(p, (Map)o, key);
        }
        if (o instanceof List) {
            return new ArrayElement(p, (List)o, key);
        }
        if (o == null || o instanceof Long || o instanceof String || o instanceof Boolean || o instanceof Double || o instanceof Float || o instanceof BigDecimal) {
            return new SimpleElement(p, o, key);
        }
        if (o instanceof Integer) {
            return new SimpleElement(p, (Integer)o, key);
        }
        throw new RuntimeException("Class not supported: " + o.getClass());
    }

    static class MapElement
    extends Element {
        JsonObjectBuilder b = Json.createObjectBuilder();
        Map e;

        public MapElement(Element p, Map e, String key) {
            super(p);
            this.e = e;
            this.key = key;
        }

        @Override
        public void add(String key, Long v) {
            if (v == null) {
                this.b.addNull(key);
            } else {
                this.b.add(key, v.longValue());
            }
        }

        @Override
        public void add(String key, String v) {
            if (v == null) {
                this.b.addNull(key);
            } else {
                this.b.add(key, v);
            }
        }

        @Override
        public void add(String key, Boolean v) {
            if (v == null) {
                this.b.addNull(key);
            } else {
                this.b.add(key, v.booleanValue());
            }
        }

        @Override
        public void add(String key, Float v) {
            throw new NumberFormatException("Float numbers not alowed. Use Double");
        }

        @Override
        public void add(String key, Double v) {
            if (v == null) {
                this.b.addNull(key);
            } else {
                this.b.add(key, v.doubleValue());
            }
        }

        @Override
        public void add(String key, BigDecimal v) {
            if (v == null) {
                this.b.addNull(key);
            } else {
                this.b.add(key, v);
            }
        }

        @Override
        public void add(String key, JsonArrayBuilder v) {
            this.b.add(key, v);
        }

        @Override
        public void add(String key, JsonObjectBuilder v) {
            this.b.add(key, v);
        }

        @Override
        public ArrayList<Element> children() {
            ArrayList<Element> cl = new ArrayList<Element>();
            for (Map.Entry meo : this.e.entrySet()) {
                Map.Entry me = meo;
                if (!(me.getKey() instanceof String)) {
                    throw new RuntimeException("Type not supported as map key: " + me.getKey().getClass());
                }
                cl.add(JsonGenerator.create(me.getValue(), (String)me.getKey(), this));
            }
            return cl;
        }

        @Override
        public void process() {
            if (this.p != null) {
                this.p.add(this.key, this.b);
            }
        }

        @Override
        public JsonValue build() {
            return this.b.build();
        }
    }

    static class ArrayElement
    extends Element {
        JsonArrayBuilder b = Json.createArrayBuilder();
        List e;

        public ArrayElement(Element p, List e, String key) {
            super(p);
            this.e = e;
            this.key = key;
        }

        @Override
        public void add(String key, Long v) {
            if (v == null) {
                this.b.addNull();
            } else {
                this.b.add(v.longValue());
            }
        }

        @Override
        public void add(String key, String v) {
            if (v == null) {
                this.b.addNull();
            } else {
                this.b.add(v);
            }
        }

        @Override
        public void add(String key, Boolean v) {
            if (v == null) {
                this.b.addNull();
            } else {
                this.b.add(v.booleanValue());
            }
        }

        @Override
        public void add(String key, Float v) {
            throw new NumberFormatException("Float numbers not alowed. Use Double");
        }

        @Override
        public void add(String key, Double v) {
            if (v == null) {
                this.b.addNull();
            } else {
                this.b.add(v.doubleValue());
            }
        }

        @Override
        public void add(String key, BigDecimal v) {
            if (v == null) {
                this.b.addNull();
            } else {
                this.b.add(v);
            }
        }

        @Override
        public void add(String key, JsonArrayBuilder v) {
            this.b.add(v);
        }

        @Override
        public void add(String key, JsonObjectBuilder v) {
            this.b.add(v);
        }

        @Override
        public ArrayList<Element> children() {
            ArrayList<Element> cl = new ArrayList<Element>();
            for (Object c : this.e) {
                cl.add(JsonGenerator.create(c, null, this));
            }
            return cl;
        }

        @Override
        public void process() {
            if (this.p != null) {
                this.p.add(this.key, this.b);
            }
        }

        @Override
        public JsonValue build() {
            return this.b.build();
        }
    }

    static class SimpleElement
    extends Element {
        protected Object e;

        public SimpleElement(Element p, Object e, String key) {
            super(p);
            this.e = e;
            this.key = key;
        }

        @Override
        public void add(String key, String v) {
        }

        @Override
        public void add(String key, Long v) {
        }

        @Override
        public void add(String key, Double v) {
        }

        @Override
        public void add(String key, Float v) {
            throw new NumberFormatException("Float numbers not alowed. Use Double");
        }

        @Override
        public void add(String key, BigDecimal v) {
        }

        @Override
        public void add(String key, Boolean v) {
        }

        @Override
        public void add(String key, JsonArrayBuilder v) {
        }

        @Override
        public void add(String key, JsonObjectBuilder v) {
        }

        @Override
        public ArrayList<Element> children() {
            return null;
        }

        @Override
        public void process() {
            if (this.p != null) {
                if (this.e == null) {
                    this.p.add(this.key, (String)null);
                } else if (this.e instanceof String) {
                    this.p.add(this.key, (String)this.e);
                } else if (this.e instanceof Long) {
                    this.p.add(this.key, (Long)this.e);
                } else if (this.e instanceof Float) {
                    this.p.add(this.key, (Float)this.e);
                } else if (this.e instanceof Double) {
                    this.p.add(this.key, (Double)this.e);
                } else if (this.e instanceof BigDecimal) {
                    this.p.add(this.key, (BigDecimal)this.e);
                } else if (this.e instanceof Boolean) {
                    this.p.add(this.key, (Boolean)this.e);
                } else {
                    throw new RuntimeException("Type not supported: " + this.e.getClass());
                }
            }
        }

        @Override
        public JsonValue build() {
            JsonArrayBuilder b = Json.createArrayBuilder();
            if (this.e == null) {
                b.addNull();
            }
            if (this.e instanceof String) {
                b.add((String)this.e);
            } else if (this.e instanceof Long) {
                b.add(((Long)this.e).longValue());
            } else if (this.e instanceof Float) {
                b.add((double)((Float)this.e).floatValue());
            } else if (this.e instanceof Double) {
                b.add(((Double)this.e).doubleValue());
            } else if (this.e instanceof BigDecimal) {
                b.add((BigDecimal)this.e);
            } else if (this.e instanceof Boolean) {
                b.add(((Boolean)this.e).booleanValue());
            } else {
                throw new RuntimeException("Type not supported: " + this.e.getClass());
            }
            return (JsonValue)b.build().get(0);
        }
    }

    static abstract class Element {
        protected Element p;
        protected String key;

        public Element(Element p) {
            this.p = p;
        }

        public abstract void add(String var1, String var2);

        public abstract void add(String var1, Long var2);

        public abstract void add(String var1, Boolean var2);

        public abstract void add(String var1, Double var2);

        public abstract void add(String var1, Float var2);

        public abstract void add(String var1, BigDecimal var2);

        public abstract void add(String var1, JsonArrayBuilder var2);

        public abstract void add(String var1, JsonObjectBuilder var2);

        public abstract ArrayList<Element> children();

        public abstract void process();

        public abstract JsonValue build();
    }
}

