/*
 * Decompiled with CFR 0.152.
 */
package com.ez.codingrules.preferences.pages;

import com.ez.codingrules.ui.internal.Messages;
import com.ez.common.ui.preferences.pages.EZFieldEditorPreferencePage;
import com.ez.eclient.preferences.ui.PersistentPreferencesStoreAdapter;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class GlobalRuleBasedPrefPage
extends EZFieldEditorPreferencePage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static final String PAGE_ID = "com.ez.codingrules.preferences.pages.globalPage";
    private static final String[] EXTENSIONS = new String[]{"*.properties"};
    FileFieldEditor ffe = null;

    public GlobalRuleBasedPrefPage() {
        super(1);
        this.setDescription(Messages.getString(GlobalRuleBasedPrefPage.class, "page.description"));
        this.globalStore = new PersistentPreferencesStoreAdapter("analyses.rule_based", "server");
        this.setPreferenceStore(this.globalStore);
    }

    protected void createMainFieldEditors(Composite parent) {
        KeyValidator kv = new KeyValidator();
        FocusValidator fv = new FocusValidator();
        MouseValidator mv = new MouseValidator();
        this.ffe = new FileFieldEditor("custom.rules.file.path", Messages.getString(GlobalRuleBasedPrefPage.class, "coding.rule.file.path"), true, 0, parent);
        this.ffe.setEmptyStringAllowed(true);
        this.ffe.setFileExtensions(EXTENSIONS);
        this.ffe.getTextControl(parent).addFocusListener((FocusListener)fv);
        this.ffe.getTextControl(parent).addKeyListener((KeyListener)kv);
        this.ffe.getTextControl(parent).addMouseListener((MouseListener)mv);
        this.ffe.setErrorMessage(Messages.getString(GlobalRuleBasedPrefPage.class, "rulesFile.error"));
        this.addField((FieldEditor)this.ffe);
        this.addEncodingCombo(this.getPreferenceStore(), parent);
    }

    private void addEncodingCombo(IPreferenceStore preferenceStore, Composite parent) {
        Set<String> charsets = Charset.availableCharsets().keySet();
        String[][] entryNamesAndValues = new String[charsets.size()][2];
        int i = 0;
        Iterator<String> iterator = charsets.iterator();
        while (iterator.hasNext()) {
            String enc;
            entryNamesAndValues[i][0] = enc = iterator.next();
            entryNamesAndValues[i][1] = enc;
            ++i;
        }
        Composite c = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        c.setLayoutData((Object)gridData);
        c.setLayout((Layout)new GridLayout(2, false));
        ComboFieldEditor fe = new ComboFieldEditor("customRulesEncoding", Messages.getString(GlobalRuleBasedPrefPage.class, "file.encoding.label"), entryNamesAndValues, c);
        fe.setPreferenceStore(preferenceStore);
        String val = preferenceStore.getString("customRulesEncoding");
        if (val == null || val.isEmpty()) {
            fe.loadDefault();
        } else {
            fe.load();
        }
        this.addField((FieldEditor)fe);
    }

    private void validatePage() {
        String msg = null;
        String path = this.ffe.getStringValue();
        path = path != null ? path.trim() : "";
        if (path.length() == 0) {
            if (!this.ffe.isEmptyStringAllowed()) {
                msg = this.ffe.getErrorMessage();
            }
        } else {
            File file = new File(path);
            if (!file.isFile()) {
                msg = this.ffe.getErrorMessage();
            } else {
                String ext = "*".concat(path.substring(path.lastIndexOf(46)).toLowerCase());
                boolean found = false;
                int i = 0;
                while (i < EXTENSIONS.length) {
                    if (ext.equalsIgnoreCase(EXTENSIONS[i])) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    msg = this.ffe.getErrorMessage();
                }
            }
        }
        if (msg != null) {
            this.setErrorMessage(msg);
        } else {
            this.setErrorMessage(null);
        }
    }

    protected String getGlobalPageID() {
        return null;
    }

    class FocusValidator
    implements FocusListener {
        FocusValidator() {
        }

        public void focusGained(FocusEvent e) {
            GlobalRuleBasedPrefPage.this.validatePage();
        }

        public void focusLost(FocusEvent e) {
            GlobalRuleBasedPrefPage.this.validatePage();
        }
    }

    class KeyValidator
    implements KeyListener {
        KeyValidator() {
        }

        public void keyPressed(KeyEvent e) {
            GlobalRuleBasedPrefPage.this.validatePage();
        }

        public void keyReleased(KeyEvent e) {
            GlobalRuleBasedPrefPage.this.validatePage();
        }
    }

    class MouseValidator
    implements MouseListener {
        MouseValidator() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            GlobalRuleBasedPrefPage.this.validatePage();
        }

        public void mouseDown(MouseEvent e) {
            GlobalRuleBasedPrefPage.this.validatePage();
        }

        public void mouseUp(MouseEvent e) {
            GlobalRuleBasedPrefPage.this.validatePage();
        }
    }
}

