/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.audit.client;

import com.ibm.ad.audit.client.exception.AuditClientInitializeException;
import com.ibm.ad.audit.client.exception.AuditClientNotInitializedException;
import com.ibm.ad.audit.client.exception.AuditException;
import com.ibm.audit.model.pojo.EventPOJO;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public class AuditClient {
    private static String auditServiceRestURL;
    private static boolean initialized;
    private static Integer applicationId;

    public static void initialize(String protocol, String auditServerHost, int auditServerPort, String notUsedContextRoot) throws AuditClientInitializeException {
        AuditClient.initialize(protocol, auditServerHost, auditServerPort);
    }

    public static void initialize(String protocol, String auditServerHost, int auditServerPort) throws AuditClientInitializeException {
        if (protocol == null || !protocol.equals("http") && !protocol.equals("https")) {
            protocol = "http";
        }
        if (auditServerHost == null || auditServerHost != null && auditServerHost.length() < 1) {
            throw new AuditClientInitializeException("Could not initialize Audit Client - invalid audit server host!");
        }
        if (auditServerPort == 0) {
            auditServerPort = 9080;
        }
        auditServiceRestURL = protocol + "://" + auditServerHost + ":" + auditServerPort + "/" + "ad-audit" + "/" + "api/audit" + "/" + "events";
        initialized = true;
    }

    public static void audit(final EventPOJO event) throws AuditClientNotInitializedException, AuditException {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    AuditClient.auditJob(event);
                }
                catch (AuditClientNotInitializedException | AuditException exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    private static boolean auditJob(EventPOJO event) throws AuditClientNotInitializedException, AuditException {
        event.setDate(new Date());
        event.setApplicationId(applicationId);
        return AuditClient.doPostRequest((Serializable)event);
    }

    private static boolean doPostRequest(Serializable object) throws AuditClientNotInitializedException, AuditException {
        AuditClient.checkClientInitialization();
        try {
            ResteasyWebTarget target = AuditClient.getEventsTarget();
            Response r = target.request(new String[]{"application/json"}).post(Entity.json((Object)object));
            int responseStatus = r.getStatus();
            r.close();
            return responseStatus == 200;
        }
        catch (Exception e) {
            throw new AuditException("Could not connect to Audit server at " + auditServiceRestURL + "! " + e.getMessage());
        }
    }

    private static ResteasyWebTarget getEventsTarget() throws NoSuchAlgorithmException {
        SSLContext sslContext = null;
        if (auditServiceRestURL.toLowerCase().startsWith("https")) {
            sslContext = SSLContext.getDefault();
        }
        ResteasyClient client = (ResteasyClient)ClientBuilder.newBuilder().sslContext(sslContext).build();
        return client.target(UriBuilder.fromPath((String)auditServiceRestURL));
    }

    private static void checkClientInitialization() throws AuditClientNotInitializedException {
        if (!initialized) {
            throw new AuditClientNotInitializedException("Pease initialize the client with a valid AuditServiceREST URL!");
        }
    }

    public static Integer getApplicationId() {
        return applicationId;
    }

    public static void setApplicationId(Integer applicationId) {
        AuditClient.applicationId = applicationId;
    }

    static {
        initialized = false;
    }
}

