/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.binding.impl;

import com.ez.keeper.binding.ObjectDescriptor;
import com.ez.keeper.binding.ObjectEvent;
import com.ez.keeper.binding.ObjectId;
import com.ez.keeper.binding.ObjectListener;
import com.ez.keeper.binding.ObjectMapper;
import com.ez.keeper.binding.ObjectSession;
import com.ez.keeper.client.ZkPath;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.cache.CacheEvent;
import com.ez.keeper.client.cache.CacheListener;
import com.ez.keeper.client.cache.LocalCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultObjectSession
implements ObjectSession {
    private static final Logger L = LoggerFactory.getLogger(DefaultObjectSession.class);
    private final ZkSession session;
    private final HashMap<String, MapperInfo> mappers = new HashMap();
    private final CacheListener cacheListener = new CacheListenerImpl();
    private final Map<ObjectId, Object> objects = new HashMap<ObjectId, Object>();
    private final HashSet<ObjectListener> listeners = new HashSet();
    private boolean closed;

    public DefaultObjectSession(ZkSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session");
        }
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerObjectMapper(String name, String rootPath, ObjectMapper mapper) {
        MapperInfo mi;
        if (this.closed) {
            throw new IllegalStateException("Closed.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (rootPath == null) {
            throw new IllegalArgumentException("rootPath");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("mapper");
        }
        HashMap<String, MapperInfo> hashMap = this.mappers;
        synchronized (hashMap) {
            if (this.mappers.containsKey(name)) {
                throw new IllegalArgumentException("Already registered: " + name);
            }
        }
        LocalCache cache = LocalCache.create((ZkSession)this.session, (String)rootPath, (String)name);
        HashMap<String, MapperInfo> hashMap2 = this.mappers;
        synchronized (hashMap2) {
            if (this.mappers.containsKey(name)) {
                L.debug("Cache {} already registered, destroying...", (Object)name);
                try {
                    cache.destroy();
                }
                catch (Exception ex) {
                    L.error("Can't destroy cache {}.", (Object)name, (Object)ex);
                }
                throw new IllegalArgumentException("Already registered: " + name);
            }
            cache.registerListener(this.cacheListener);
            mi = new MapperInfo(rootPath, mapper, name, cache);
            this.mappers.put(name, mi);
        }
        this.initializeObjectMapper(mi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unregisterObjectMapper(String name) {
        if (this.closed) {
            throw new IllegalStateException("Closed.");
        }
        MapperInfo mi = null;
        HashMap<String, MapperInfo> hashMap = this.mappers;
        synchronized (hashMap) {
            mi = this.mappers.remove(name);
        }
        if (mi == null) {
            L.debug("Mapper not registered: " + name);
        } else {
            this.destroy(mi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerListener(ObjectListener l) {
        if (this.closed) {
            throw new IllegalStateException("Closed.");
        }
        HashSet<ObjectListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unregisterListener(ObjectListener l) {
        if (this.closed) {
            throw new IllegalStateException("Closed.");
        }
        HashSet<ObjectListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            Map ms;
            HashMap<String, MapperInfo> hashMap = this.mappers;
            synchronized (hashMap) {
                ms = (Map)this.mappers.clone();
            }
            Iterator it = ms.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                this.destroy((MapperInfo)e.getValue());
                it.remove();
            }
        }
        finally {
            this.closed = true;
        }
    }

    private void destroy(MapperInfo mi) {
        try {
            mi.cache.unregisterListener(this.cacheListener);
            mi.cache.destroy();
        }
        catch (Exception ex) {
            L.error("Can't destroy " + mi.name, (Throwable)ex);
        }
    }

    private void onCacheChanged(CacheEvent e) {
        L.trace("Cached changed: " + e);
        List<MapperInfo> targets = this.findInterestred(e);
        this.updateObjects(e, targets);
    }

    private void initializeObjectMapper(MapperInfo mi) {
        List<ObjectDescriptor> odl = null;
        try {
            odl = mi.mapper.initialize(mi.rootPath, mi.cache);
        }
        catch (Exception ex) {
            L.error("", (Throwable)ex);
        }
        if (odl != null) {
            for (ObjectDescriptor od : odl) {
                this.updateObjects(od, mi);
            }
        }
    }

    private void updateObjects(CacheEvent e, List<MapperInfo> targets) {
        for (MapperInfo mi : targets) {
            ObjectDescriptor od = null;
            try {
                od = mi.mapper.notify(e, mi.cache);
            }
            catch (Exception ex) {
                L.error("Unexpected error.", (Throwable)ex);
            }
            if (od == null) continue;
            this.updateObjects(od, mi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObjects(ObjectDescriptor od, MapperInfo mi) {
        L.trace("Notify mapper: " + mi.name);
        Map<ObjectId, Object> map = this.objects;
        synchronized (map) {
            if (od.isDeleted()) {
                Object old = this.objects.remove(od.getId());
                if (old == null) {
                    L.warn("Deleted object not registered: " + od.getId());
                } else {
                    L.debug("Object deleted: " + od.getId());
                    this.notifyListeners(new ObjectEvent(ObjectEvent.Type.Deleted, od.getId(), Collections.emptyList()));
                }
            } else {
                final Object old = this.objects.get(od.getId());
                if (old == null) {
                    L.debug("Object created: " + od.getId());
                    this.notifyListeners(new ObjectEvent(ObjectEvent.Type.Created, od.getId(), Collections.singletonList(od.getObject())));
                } else {
                    L.debug("Object updated: " + od.getId());
                    final Object no = od.getObject();
                    this.notifyListeners(new ObjectEvent(ObjectEvent.Type.Created, od.getId(), (List<Object>)new ArrayList<Object>(){
                        {
                            this.add(no);
                            this.add(old);
                        }
                    }));
                }
                this.objects.put(od.getId(), od.getObject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(ObjectEvent e) {
        Set ll;
        HashSet<ObjectListener> hashSet = this.listeners;
        synchronized (hashSet) {
            ll = (Set)this.listeners.clone();
        }
        for (ObjectListener l : ll) {
            try {
                l.notify(e);
            }
            catch (Exception ex) {
                L.error("Unexpected error.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MapperInfo> findInterestred(CacheEvent e) {
        Map ms;
        LinkedList<MapperInfo> r = new LinkedList<MapperInfo>();
        String node = e.getNode();
        HashMap<String, MapperInfo> hashMap = this.mappers;
        synchronized (hashMap) {
            ms = (Map)this.mappers.clone();
        }
        for (MapperInfo mi : ms.values()) {
            String relative = ZkPath.relative2((String)mi.rootPath, (String)node);
            if (relative == null) continue;
            try {
                if (!mi.mapper.accept(e)) continue;
                r.add(mi);
            }
            catch (Exception ex) {
                L.error("Unexpected error.", (Throwable)ex);
            }
        }
        return r;
    }

    private static class MapperInfo {
        final String rootPath;
        final ObjectMapper mapper;
        final String name;
        final LocalCache cache;

        public MapperInfo(String rootPath, ObjectMapper mapper, String name, LocalCache cache) {
            this.rootPath = rootPath;
            this.mapper = mapper;
            this.name = name;
            this.cache = cache;
        }
    }

    private class CacheListenerImpl
    implements CacheListener {
        private CacheListenerImpl() {
        }

        public void onCacheChanged(CacheEvent e) {
            DefaultObjectSession.this.onCacheChanged(e);
        }
    }
}

