/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.callgraph.am;

import com.ez.cobol.callgraph.CallgraphNodeLegendInfo;
import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.cobol.callgraph.nodes.AlgolProgramNode;
import com.ez.cobol.callgraph.nodes.CobolProgramNode;
import com.ez.cobol.callgraph.nodes.FortranProgramNode;
import com.ez.cobol.callgraph.nodes.IdmsRecordNode;
import com.ez.cobol.callgraph.nodes.IdmsSetNode;
import com.ez.cobol.callgraph.nodes.ResourceFileNode;
import com.ez.cobol.callgraph.nodes.SCLProgramNode;
import com.ez.cobol.callgraph.nodes.TPMSXMapNode;
import com.ez.cobol.callgraph.nodes.UnknownProgramNode;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.common.ui.ImageDescriptorProvider;
import com.ez.ddcl.callgraph.AMNodeLegendInfo;
import com.ez.ddcl.callgraph.ApplicationMasterGraphModel;
import com.ez.ddcl.callgraph.DDCLGraphBuilder;
import com.ez.ddcl.callgraph.nodes.AMApplication;
import com.ez.ddcl.callgraph.nodes.AMBatchProgram;
import com.ez.ddcl.callgraph.nodes.AMComponent;
import com.ez.ddcl.callgraph.nodes.AMDataSource;
import com.ez.ddcl.callgraph.nodes.AMDialogue;
import com.ez.ddcl.callgraph.nodes.AMExchange;
import com.ez.ddcl.callgraph.nodes.AMFile;
import com.ez.ddcl.callgraph.nodes.AMModule;
import com.ez.ddcl.callgraph.nodes.AMRecord;
import com.ez.ddcl.callgraph.nodes.AMReport;
import com.ez.ddcl.callgraph.nodes.AMReportProgram;
import com.ez.ddcl.callgraph.nodes.AMScreen;
import com.ez.ddcl.callgraph.nodes.AMSet;
import com.ez.ddcl.callgraph.nodes.AMTPService;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.graphs.callgraph.am.AMMouseActionsHook;
import com.ez.graphs.callgraph.am.utils.AMGraphUtils;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.Activator;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationMasterGraphJob
extends GraphAnalysisJob
implements IMFRunnable {
    private static final Logger L = LoggerFactory.getLogger(ApplicationMasterGraphJob.class);
    private static final int MAXNAMES = 5;
    private MainframeMouseActionsHook mouseActionsHook = null;
    private String tabName;
    private Direction graphDirection;
    private Integer graphLimitation = null;
    private DDCLGraphBuilder builder;

    public ApplicationMasterGraphJob(EZEntityID ezId) {
        super(ezId);
        this.mouseActionsHook = new AMMouseActionsHook(ezId);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new ApplicationMasterGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.gfi = new GraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.addFilters(this.gfi);
        this.graphDirection = (Direction)this.analysis.getContextValue("graph direction: forward or backward or both");
        L.debug("graph direction: " + this.graphDirection);
        Boolean isAppMGraphLimited = (Boolean)this.analysis.getContextValue("is graph limited");
        if (isAppMGraphLimited != null && isAppMGraphLimited.booleanValue()) {
            this.graphLimitation = (Integer)this.analysis.getContextValue("limit number for graph levels");
            L.debug("application master graph has limit: " + this.graphLimitation);
        } else {
            L.debug("application master graph isn't limited");
        }
        this.graphModel = new ApplicationMasterGraphModel(new AnalysisGraphManager(), this.graphDirection, this.graphLimitation);
        this.graphManager = this.graphModel.getGraphManager();
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        super.initGraphDetails();
        Object pathSelected = this.analysis.getContextValue("selected path");
        if (pathSelected == null || pathSelected.toString().trim().equals("")) {
            List inputs = this.analysis.getContextListValue("input_list");
            this.builder = new DDCLGraphBuilder(inputs, (ApplicationMasterGraphModel)this.graphModel, this.graphDirection, this.graphLimitation, true);
        }
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel model, IProgressMonitor monitor) {
        ProjectInfo ezsourcePrjInfo = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        ((ApplicationMasterGraphModel)this.graphModel).setEzsourcePrj(ezsourcePrjInfo);
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(ApplicationMasterGraphJob.class, (String)"collectingData.taskName"));
        IStatus status = Utils.collectDataFromBridge((IProgressMonitor)pmonitor.newChild(100), (String)ezsourcePrjInfo.getName(), (IMFRunnable)this);
        if (!status.isOK()) {
            monitor.setCanceled(true);
        } else {
            pmonitor.setWorkRemaining(0);
        }
    }

    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ApplicationMasterGraphJob.class, (String)"compute.taskName"));
        Object pathSelected = this.analysis.getContextValue("selected path");
        if (pathSelected != null && !pathSelected.toString().trim().equals("")) {
            TSEGraph mainGraph = this.graphModel.getGraph();
            List inputs = this.analysis.getContextListValue("input_list");
            for (EZEntityID singleVal : inputs) {
                ArrayList<EZEntityID> singleList = new ArrayList<EZEntityID>();
                singleList.add(singleVal);
                this.builder = new DDCLGraphBuilder(singleList, (ApplicationMasterGraphModel)this.graphModel, this.graphDirection, this.graphLimitation, true);
                ((ApplicationMasterGraphModel)this.graphModel).initGraph();
                Map nodes = this.builder.buildGraph((IProgressMonitor)monitor, conn);
                ((ApplicationMasterGraphModel)this.graphModel).setInputNodes(nodes);
                this.graphModel.loadGraph((IProgressMonitor)new NullProgressMonitor());
                TSEGraph newGraph = this.graphModel.getGraph();
                ((ApplicationMasterGraphModel)this.graphModel).writeGraphToFile(newGraph, singleVal.getSegments(), pathSelected.toString());
                this.builder = null;
                newGraph.dispose();
            }
            this.graphModel.setGraph(mainGraph);
        } else {
            ((ApplicationMasterGraphModel)this.graphModel).initGraph();
            Map nodes = this.builder.buildGraph((IProgressMonitor)monitor, conn);
            ((ApplicationMasterGraphModel)this.graphModel).setInputNodes(nodes);
        }
        monitor.done();
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor pmonitor, IStatus result) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ApplicationMasterGraphJob.class, (String)"dolayout.taskName"));
        IStatus statusResult = super.finalTSGraphOperations((IProgressMonitor)monitor, result);
        if (this.gfi != null) {
            HashSet allNodes = new HashSet();
            Collection nodesSetsList = this.graphModel.getOutForStructView().values();
            for (Set nodesSet : nodesSetsList) {
                allNodes.addAll(nodesSet);
            }
            this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
        }
        monitor.setWorkRemaining(0);
        return statusResult;
    }

    protected TSCommand doLayout(int type, TSEGraph graph) {
        TSCommand layoutCommand = null;
        switch (type) {
            case 1: {
                L.debug("do specific constraints layout");
                layoutCommand = ((ApplicationMasterGraphModel)this.graphModel).createCustomHLayoutCommand((TSDGraph)graph);
                ((ApplicationMasterGraphModel)this.graphModel).applySeparationConstraint();
                break;
            }
            default: {
                layoutCommand = super.doLayout(type, graph);
            }
        }
        return layoutCommand;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        this.contributeIconEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    private void addEntriesToLegend(LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        this.addNodesToLegend(legend, uiStyle);
        this.addEdgesToLegend(legend);
    }

    private void addNodesToLegend(LegendPanel legend, int uiStyle) {
        Set nodeTypesSetForLegend = this.graphModel.getNodeTypesForLegend();
        ArrayList nodeTypesList = new ArrayList(nodeTypesSetForLegend);
        Collections.sort(nodeTypesList, new Comparator<IGraphNodeLegendInfo>(){

            @Override
            public int compare(IGraphNodeLegendInfo nodeType1, IGraphNodeLegendInfo nodeType2) {
                return nodeType1.getLegendLabel().compareTo(nodeType2.getLegendLabel());
            }
        });
        for (IGraphNodeLegendInfo nodeLegendInfo : nodeTypesList) {
            String imagePath = null;
            if (uiStyle == 2) {
                if (nodeLegendInfo instanceof CallgraphNodeLegendInfo) {
                    Utils.setImageProvider((LegendPanel)legend);
                } else if (nodeLegendInfo instanceof AMNodeLegendInfo) {
                    AMGraphUtils.setImageProvider(legend);
                }
                imagePath = nodeLegendInfo.getLegendImagePath();
            } else if (uiStyle == 0) {
                Utils.setImageProvider((LegendPanel)legend);
                imagePath = nodeLegendInfo.getColorboxImagePath();
            }
            legend.placeLegendEntry(nodeLegendInfo.getNodeTypeClass(), imagePath, nodeLegendInfo.getLegendLabel());
        }
    }

    private void addEdgesToLegend(LegendPanel legend) {
        Set edgeTypesSetForLegend = this.graphModel.getEdgeTypesForLegend();
        ArrayList edgeTypesList = new ArrayList(edgeTypesSetForLegend);
        Collections.sort(edgeTypesList, new Comparator<IGraphEdgeLegendInfo>(){

            @Override
            public int compare(IGraphEdgeLegendInfo edgeType1, IGraphEdgeLegendInfo edgeType2) {
                return edgeType1.getLegendLabel().compareTo(edgeType2.getLegendLabel());
            }
        });
        Utils.setImageProvider((LegendPanel)legend);
        for (IGraphEdgeLegendInfo edgeLegendInfo : edgeTypesList) {
            legend.placeLegendEntry(edgeLegendInfo.getLegendImagePath(), edgeLegendInfo.getLegendLabel());
        }
    }

    private void addFilters(GraphFilterInfo gfi) {
        gfi.registerFilterType(AMApplication.class);
        gfi.registerFilterType(AMBatchProgram.class);
        gfi.registerFilterType(AMComponent.class);
        gfi.registerFilterType(AMDataSource.class);
        gfi.registerFilterType(AMDialogue.class);
        gfi.registerFilterType(AMExchange.class);
        gfi.registerFilterType(ResourceFileNode.class);
        gfi.registerFilterType(AMModule.class);
        gfi.registerFilterType(AMRecord.class);
        gfi.registerFilterType(AMSet.class);
        gfi.registerFilterType(AMFile.class);
        gfi.registerFilterType(AMReport.class);
        gfi.registerFilterType(AMReportProgram.class);
        gfi.registerFilterType(AMScreen.class);
        gfi.registerFilterType(AMTPService.class);
        gfi.registerFilterType(CobolProgramNode.class);
        gfi.registerFilterType(SCLProgramNode.class);
        gfi.registerFilterType(UnknownProgramNode.class);
        gfi.registerFilterType(AlgolProgramNode.class);
        gfi.registerFilterType(FortranProgramNode.class);
        gfi.registerFilterType(IdmsSetNode.class);
        gfi.registerFilterType(IdmsRecordNode.class);
        gfi.registerFilterType(TPMSXMapNode.class);
    }

    public class ApplicationMasterGraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        GraphFilterInfo gfi;

        public ApplicationMasterGraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor((String)"icons/appMaster.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            StringBuilder buil = new StringBuilder();
            String textInputsMoreCount = "";
            String textInputNames = "";
            List inputs = ApplicationMasterGraphJob.this.analysis.getContextListValue("input_list");
            if (inputs != null) {
                int idx = 0;
                int all = inputs.size();
                for (EZEntityID input : inputs) {
                    if (idx >= 5) {
                        textInputsMoreCount = String.valueOf(textInputsMoreCount) + (all - idx);
                        break;
                    }
                    ++idx;
                    EZSourceDDCLElementIDSg ddclElemIdSg = (EZSourceDDCLElementIDSg)input.getSegment(EZSourceDDCLElementIDSg.class);
                    if (ddclElemIdSg != null) {
                        textInputNames = String.valueOf(textInputNames) + ddclElemIdSg.getName();
                    }
                    if (inputs.indexOf(input) == inputs.size() - 1) continue;
                    textInputNames = String.valueOf(textInputNames) + ", ";
                }
            }
            String prjName = (String)ApplicationMasterGraphJob.this.analysis.getContextValue("input_project_names");
            if (!textInputsMoreCount.isEmpty()) {
                buil.append(Messages.getString(ApplicationMasterGraphJob.class, (String)"tabName.with.more", (Object[])new String[]{textInputNames, textInputsMoreCount, prjName}));
            } else {
                buil.append(Messages.getString(ApplicationMasterGraphJob.class, (String)"tabName", (Object[])new String[]{textInputNames, prjName}));
            }
            ApplicationMasterGraphJob.this.tabName = buil.toString();
            return ApplicationMasterGraphJob.this.tabName;
        }

        public String getTooltip() {
            StringBuilder buil = new StringBuilder(ApplicationMasterGraphJob.this.tabName);
            String textDirection = "";
            if (ApplicationMasterGraphJob.this.graphDirection != null) {
                textDirection = String.valueOf(textDirection) + ApplicationMasterGraphJob.this.graphDirection.toString();
            }
            if (ApplicationMasterGraphJob.this.graphLimitation != null) {
                buil.append(Messages.getString(ApplicationMasterGraphJob.class, (String)"tooltipName", (Object[])new String[]{textDirection, ApplicationMasterGraphJob.this.graphLimitation.toString()}));
            }
            return buil.toString();
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    ApplicationMasterGraphJob.this.legend = new LegendPanel((Composite)sc, 0);
                    ApplicationMasterGraphJob.this.legend.setImageDescriptorProvider(new ImageDescriptorProvider(){

                        public ImageDescriptor getImageDescriptor(String image) {
                            return Activator.getImageDescriptor((String)image);
                        }
                    });
                    int uiStyle = ApplicationMasterGraphJob.this.graphModel.getUIStyle();
                    ApplicationMasterGraphJob.this.addEntriesToLegend(ApplicationMasterGraphJob.this.legend, uiStyle, ApplicationMasterGraphInfo.this.gfi);
                    sc.setContent((Control)ApplicationMasterGraphJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    ApplicationMasterGraphJob.this.legend.pack();
                    sc.setMinSize(ApplicationMasterGraphJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((ApplicationMasterGraphJob)((ApplicationMasterGraphInfo)ApplicationMasterGraphInfo.this).ApplicationMasterGraphJob.this).legend.getSize().x;
                    int x = ((ApplicationMasterGraphJob)((ApplicationMasterGraphInfo)ApplicationMasterGraphInfo.this).ApplicationMasterGraphJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return true;
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public void dispose() {
            this.gfi = null;
            ApplicationMasterGraphJob.this.legend = null;
            super.dispose();
        }
    }
}

