/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.callgraph.am;

import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.gui.wizard.InputsWithSettingsPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.model.DDCLElementInput;
import com.ez.report.application.ui.collectors.DDCLElementCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectPathPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSRecordIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSSetIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;

public class ApplicationMasterGraphInputsFilter
extends ProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = null;
        if (wizard == null) {
            wizard = new PrepareReportWizard();
            String wizardName = Messages.getString(ApplicationMasterGraphInputsFilter.class, (String)"wizard.title");
            wizard.setWindowTitle(wizardName);
            InputsWithSettingsPage selectDDCLElementsPage = new InputsWithSettingsPage("ddcl elements for application master graph page", true, true);
            DDCLElementCollector ddclElementsCollector = new DDCLElementCollector("EZViewer_IDMSX_View");
            ddclElementsCollector.setResourcesQuery("SELECT DDCLElement.Id, DDCLElement.Name, DDCLElement.DdsTypeId FROM DDCLElement WHERE DDCLElement.isLocal = 'false' AND (\t DDCLElement.DdsTypeId IN (4,11,12,14,16,24,25,26,27,28)\t or (\t\tDDCLElement.DdsTypeId IN (3,10) \t\tand DDCLElement.Name in (\t\t\tselect distinct ElementName from cacheEZViewer_IDMSX_View)\t ) ) ORDER BY DDCLElement.DdsTypeId, DDCLElement.Name");
            selectDDCLElementsPage.setResourcesCollector((ResourcesCollector)ddclElementsCollector);
            selectDDCLElementsPage.setTitle(Messages.getString(ApplicationMasterGraphInputsFilter.class, (String)"page.title"));
            String limitGroupButtonText = Messages.getString(ApplicationMasterGraphInputsFilter.class, (String)"limit.group.txt");
            String limitGraphLblText = Messages.getString(ApplicationMasterGraphInputsFilter.class, (String)"limit.graph.btn.txt");
            selectDDCLElementsPage.setLimitGraphText(limitGroupButtonText, limitGraphLblText);
            selectDDCLElementsPage.setDescription(Messages.getString(ApplicationMasterGraphInputsFilter.class, (String)"page.description"));
            selectDDCLElementsPage.setLeftGroupLabel(Messages.getString(ApplicationMasterGraphInputsFilter.class, (String)"av.object.type"));
            selectDDCLElementsPage.setRightGroupLabel(Messages.getString(ApplicationMasterGraphInputsFilter.class, (String)"sel.object.type"));
            selectDDCLElementsPage.setErrMsgNoResource(Messages.getString(ApplicationMasterGraphInputsFilter.class, (String)"err.message"));
            wizard.addPage((IWizardPage)selectDDCLElementsPage);
            if (System.getProperty("test") != null) {
                SelectPathPage selectPathPage = new SelectPathPage("tests page");
                wizard.addPage((IWizardPage)selectPathPage);
            }
        }
        return wizard;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) {
        List selected = wizard.getList("selected resources");
        ArrayList<EZEntityID> input_list = new ArrayList<EZEntityID>();
        ProjectInfo projectInfo = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
        EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(projectInfo);
        for (DDCLElementInput ddclElemenent : selected) {
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)prjIdSg);
            if (3 == ddclElemenent.getTypeCode()) {
                EZSourceIDMSRecordIDSg idmsRecIdSg = new EZSourceIDMSRecordIDSg(ddclElemenent.getName());
                entity.addSegment((EZSegment)idmsRecIdSg);
            } else if (10 == ddclElemenent.getTypeCode()) {
                EZSourceIDMSSetIDSg idmsIdSg = new EZSourceIDMSSetIDSg(ddclElemenent.getName());
                entity.addSegment((EZSegment)idmsIdSg);
            }
            EZSourceDDCLElementIDSg ddclElemIdSg = new EZSourceDDCLElementIDSg(ddclElemenent.getName(), ddclElemenent.getTypeCode(), ddclElemenent.getResourceID());
            entity.addSegment((EZSegment)ddclElemIdSg);
            input_list.add(entity);
        }
        analysis.addContextValue("input_list", input_list);
        analysis.addContextValue("selected path", (Object)wizard.getSelectedPath());
    }
}

