/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis.manager.model;

import com.ez.rdz.resources.mainframe.analysis.manager.model.ProjectData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ResourceData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String ID = "ID";
    public static final String NAME = "NAME";
    public static final String TYPE_ID = "TYPE_ID";
    public static final String TYPE_NAME = "TYPE_NAME";
    public static final String CONNECTION = "CONNECTION";
    public static final String PROJECT_DATA = "PROJECT_DATA";
    private final Map<String, Object> values = new HashMap<String, Object>();

    public ResourceData(int id, String name, int typeID, String typeName, String connection) {
        this.values.put(ID, id);
        this.values.put(NAME, name);
        this.values.put(TYPE_ID, typeID);
        this.values.put(TYPE_NAME, typeName);
        this.values.put(CONNECTION, connection);
    }

    public int getId() {
        return (Integer)this.getValue(ID);
    }

    public String getName() {
        return (String)this.getValue(NAME);
    }

    public int getTypeID() {
        return (Integer)this.getValue(TYPE_ID);
    }

    public String getTypeName() {
        return (String)this.getValue(TYPE_NAME);
    }

    public String getConnection() {
        return (String)this.getValue(CONNECTION);
    }

    public ProjectData getProjectData() {
        return (ProjectData)this.getValue(PROJECT_DATA);
    }

    void setProjectData(ProjectData projectData) {
        this.putValue(PROJECT_DATA, projectData);
    }

    public <T> T getValue(String key) {
        Object value = this.values.get(key);
        return (T)value;
    }

    public Set<String> getValueNames() {
        Set<String> keySet = this.values.keySet();
        return Collections.unmodifiableSet(keySet);
    }

    protected void putValue(String key, Object value) {
        if (value == null) {
            this.values.remove(key);
        } else {
            this.values.put(key, value);
        }
    }
}

