/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis.manager.model;

import com.ez.mainframe.model.ProjectInfo;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ResourceData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProjectData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private final Map<Class<ResourceData>, Map<Integer, ResourceData>> map = new HashMap<Class<ResourceData>, Map<Integer, ResourceData>>();
    private String projectName;
    private ProjectInfo projectInfo;

    public ProjectData(String mainframeProjectName, ProjectInfo projectInfo) {
        this.projectName = mainframeProjectName;
        this.projectInfo = projectInfo;
    }

    public <T extends ResourceData> void addResource(T resourceData) {
        Class<?> clazz = resourceData.getClass();
        Map<Integer, ?> resourceDataMap = this.getModifiableMap(clazz);
        resourceDataMap.put(resourceData.getId(), resourceData);
        resourceData.setProjectData(this);
    }

    public <T extends ResourceData> void removeResource(T resourceData) {
        Class<?> clazz = resourceData.getClass();
        Map<Integer, ?> ResourceDataMap = this.getModifiableMap(clazz);
        ResourceDataMap.remove(resourceData.getId());
        resourceData.setProjectData(null);
    }

    public <T extends ResourceData> void clearResources(Class<T> clazz) {
        Map<Integer, T> includeDataMap = this.getModifiableMap(clazz);
        for (ResourceData resourceData : includeDataMap.values()) {
            resourceData.setProjectData(null);
        }
        includeDataMap.clear();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    public List<ResourceData> getResourceDataList() {
        ArrayList<ResourceData> resources = new ArrayList<ResourceData>();
        for (Class<ResourceData> clazz : this.map.keySet()) {
            Map<Integer, ResourceData> resourceDataMap = this.getModifiableMap(clazz);
            for (ResourceData resourceData : resourceDataMap.values()) {
                resources.add(resourceData);
            }
        }
        return resources;
    }

    private <T extends ResourceData> Map<Integer, T> getModifiableMap(Class<T> clazz) {
        Map<Integer, ResourceData> specificResourceMap = this.map.get(clazz);
        if (specificResourceMap == null) {
            specificResourceMap = new HashMap<Integer, ResourceData>();
            this.map.put(clazz, specificResourceMap);
        }
        return specificResourceMap;
    }

    public <T extends ResourceData> Map<Integer, T> getResourcesMap(Class<T> clazz) {
        return Collections.unmodifiableMap(this.getModifiableMap(clazz));
    }

    public <T extends ResourceData> Set<T> searchValue(Class<T> clazz, String resourceName, Object value) {
        HashSet<ResourceData> resourcesSet = new HashSet<ResourceData>();
        for (Map.Entry<Class<ResourceData>, Map<Integer, ResourceData>> entry : this.map.entrySet()) {
            if (!entry.getKey().equals(clazz)) continue;
            for (ResourceData resource : entry.getValue().values()) {
                if (value != null && !value.equals(resource.getValue(resourceName))) continue;
                resourcesSet.add(resource);
            }
        }
        return resourcesSet;
    }

    public <T extends ResourceData> T getResourceData(int id, Class<T> clazz) {
        return (T)((ResourceData)this.getResourcesMap(clazz).get(id));
    }

    public String toString() {
        return "ProjectData [projectName=" + this.projectName + ", projectInfo=" + this.projectInfo + "]";
    }
}

