/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis.manager.model;

import com.ez.rdz.resources.mainframe.analysis.manager.model.ResourceData;

public class ProgramData
extends ResourceData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String ANCESTOR = "ANCESTOR";
    public static final String OCCURID = "OCCURID";

    public ProgramData(String[] programData) {
        super(Integer.parseInt(programData[0]), programData[1], Integer.parseInt(programData[3]), programData[4], programData[5]);
        this.putValue(ANCESTOR, programData[2]);
        this.putValue(OCCURID, programData[6]);
    }

    @Override
    public int getId() {
        return super.getId();
    }

    public ProgramData(int id, String name, String ancestor, int typeID, String typeName, String connection) {
        super(id, name, typeID, typeName, connection);
        this.putValue(ANCESTOR, ancestor);
    }

    public String getAncestorName() {
        return (String)this.getValue(ANCESTOR);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getAncestorName() == null ? 0 : this.getAncestorName().hashCode());
        result = 31 * result + (this.getConnection() == null ? 0 : this.getConnection().hashCode());
        result = 31 * result + this.getId();
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getProjectData() == null ? 0 : this.getProjectData().hashCode());
        result = 31 * result + this.getTypeID();
        result = 31 * result + (this.getTypeName() == null ? 0 : this.getTypeName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgramData)) {
            return false;
        }
        ProgramData other = (ProgramData)obj;
        if (this.getAncestorName() == null ? other.getAncestorName() != null : !this.getAncestorName().equals(other.getAncestorName())) {
            return false;
        }
        if (this.getConnection() == null ? other.getConnection() != null : !this.getConnection().equals(other.getConnection())) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getProjectData() == null ? other.getProjectData() != null : !this.getProjectData().equals(other.getProjectData())) {
            return false;
        }
        if (this.getTypeID() != other.getTypeID()) {
            return false;
        }
        if (this.getTypeName() == null ? other.getTypeName() != null : !this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        return this.getOccurID() == other.getOccurID();
    }

    public String toString() {
        return "ProgramData [id=" + this.getId() + ", name=" + this.getName() + ", ancestor=" + this.getAncestorName() + ", typeID=" + this.getTypeID() + ", typeName=" + this.getTypeName() + ", connection=" + this.getConnection() + ", projectData=" + this.getProjectData() + "]";
    }

    public String getOccurID() {
        return (String)this.getValue(OCCURID);
    }
}

