/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis.manager.model;

import com.ez.rdz.resources.mainframe.analysis.manager.model.ResourceData;

public class IncludeData
extends ResourceData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String PROGRAM_TYPE_ID = "PROGRAM_TYPE_ID";
    public static final String PROGRAM_TYPE_NAME = "PROGRAM_TYPE_NAME";

    public IncludeData(String[] includeData) {
        super(Integer.parseInt(includeData[0]), includeData[1], Integer.parseInt(includeData[2]), includeData[3], includeData[6]);
        this.putValue(PROGRAM_TYPE_ID, Integer.parseInt(includeData[4]));
        this.putValue(PROGRAM_TYPE_NAME, includeData[5]);
    }

    public IncludeData(int id, String name, int typeID, String typeName, int programTypeID, String programTypeName, String connection) {
        super(id, name, typeID, typeName, connection);
        this.putValue(PROGRAM_TYPE_ID, programTypeID);
        this.putValue(PROGRAM_TYPE_NAME, programTypeName);
    }

    @Override
    public int getId() {
        return super.getId();
    }

    public int getProgramTypeID() {
        return (Integer)this.getValue(PROGRAM_TYPE_ID);
    }

    public String getProgramTypeName() {
        return (String)this.getValue(PROGRAM_TYPE_NAME);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getConnection() == null ? 0 : this.getConnection().hashCode());
        result = 31 * result + this.getId();
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + this.getProgramTypeID();
        result = 31 * result + (this.getProgramTypeName() == null ? 0 : this.getProgramTypeName().hashCode());
        result = 31 * result + (this.getProjectData() == null ? 0 : this.getProjectData().hashCode());
        result = 31 * result + this.getTypeID();
        result = 31 * result + (this.getTypeName() == null ? 0 : this.getTypeName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncludeData)) {
            return false;
        }
        IncludeData other = (IncludeData)obj;
        if (this.getConnection() == null ? other.getConnection() != null : !this.getConnection().equals(other.getConnection())) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getProgramTypeID() != other.getProgramTypeID()) {
            return false;
        }
        if (this.getProgramTypeName() == null ? other.getProgramTypeName() != null : !this.getProgramTypeName().equals(other.getProgramTypeName())) {
            return false;
        }
        if (this.getProjectData() == null ? other.getProjectData() != null : !this.getProjectData().equals(other.getProjectData())) {
            return false;
        }
        if (this.getTypeID() != other.getTypeID()) {
            return false;
        }
        return !(this.getTypeName() == null ? other.getTypeName() != null : !this.getTypeName().equals(other.getTypeName()));
    }

    public String toString() {
        return "IncludeData [id=" + this.getId() + ", name=" + this.getName() + ", typeID=" + this.getTypeID() + ", typeName=" + this.getTypeName() + ", programTypeID=" + this.getProgramTypeID() + ", programTypeName=" + this.getProgramTypeName() + ", connection=" + this.getConnection() + ", projectData=" + this.getProjectData() + "]";
    }
}

