/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis.manager;

import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceDataset;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.protection.Registry;
import com.ez.rdz.Activator;
import com.ez.rdz.preferences.PreferenceUtils;
import com.ez.rdz.resources.mainframe.analysis.manager.model.DataSetData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.IncludeData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.JobData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ProgramData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ResourceData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.SQLTableData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.TransactionData;
import com.ez.rdz.utils.Messages;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.EZInputFilter;
import com.ez.workspace.analysis.category.ICategory;
import com.ez.workspace.model.CategoryManager;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceIncludeIDSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProgramTypeIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceResourceIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeAnalysisManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeAnalysisManager.class);

    public static Map<ResourceData, EZObjectType> createEZObjectTypes(List<ResourceData> resourceDataList) {
        if (resourceDataList == null) {
            throw new IllegalArgumentException("the resourceDataList should not be null");
        }
        if (resourceDataList.size() == 0) {
            L.debug("no ResourceData provided");
        }
        HashMap<ResourceData, EZObjectType> ezObjectTypeMap = new HashMap<ResourceData, EZObjectType>();
        for (ResourceData resourceData : resourceDataList) {
            ezObjectTypeMap.put(resourceData, MainframeAnalysisManager.createEZObjectType(resourceData));
        }
        return ezObjectTypeMap;
    }

    public static EZObjectType createEZObjectType(ResourceData resourceData) {
        EZObjectType ezObjectType;
        if (resourceData == null) {
            throw new IllegalArgumentException("the resourceData should not be null");
        }
        if (resourceData instanceof ProgramData) {
            ezObjectType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(resourceData.getTypeID()));
        } else if (resourceData instanceof JobData) {
            ezObjectType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(resourceData.getTypeID()), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
        } else if (resourceData instanceof IncludeData) {
            ezObjectType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(resourceData.getTypeID()), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
        } else if (resourceData instanceof DataSetData) {
            ezObjectType = new EZSourceDataset();
            ezObjectType.addProperty("holds the load modules of the program to be executed in the JCL", (Object)("1".equals(((DataSetData)resourceData).getIsLib()) ? Boolean.TRUE : Boolean.FALSE));
        } else if (resourceData instanceof TransactionData) {
            ezObjectType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(14), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            ezObjectType.setName(resourceData.getName());
        } else if (resourceData instanceof SQLTableData) {
            ezObjectType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(1), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            ezObjectType.setName(resourceData.getName());
        } else {
            throw new IllegalStateException("unsupported type");
        }
        if (ezObjectType != null) {
            EZEntityID entID = new EZEntityID();
            EZSourceProjectIDSg projSG = MainframeAnalysisManager.createPrjSegment(resourceData);
            entID.addSegment((EZSegment)projSG);
            HashSet<EZSegment> segments = null;
            if (resourceData instanceof ProgramData) {
                segments = MainframeAnalysisManager.createPrgSegments((ProgramData)resourceData);
            } else if (resourceData instanceof JobData) {
                segments = MainframeAnalysisManager.createJobSegments((JobData)resourceData);
            } else if (resourceData instanceof IncludeData) {
                segments = MainframeAnalysisManager.createIncludeSegments((IncludeData)resourceData, ezObjectType);
            } else if (resourceData instanceof DataSetData) {
                segments = MainframeAnalysisManager.createDataSetSegments((DataSetData)resourceData);
            } else if (resourceData instanceof TransactionData) {
                segments = MainframeAnalysisManager.createTransactionSegments((TransactionData)resourceData);
            } else if (resourceData instanceof SQLTableData) {
                segments = MainframeAnalysisManager.createTableSegments((SQLTableData)resourceData);
            }
            for (EZSegment sg : segments) {
                entID.addSegment(sg);
            }
            ezObjectType.setEntID(entID);
        } else {
            L.debug(">>>>>>EZObject type for id: {} could not be provided.", (Object)resourceData.getId());
        }
        return ezObjectType;
    }

    public static List<EZAnalysisType> getSpecificAnalysisTypes(Map<ResourceData, EZObjectType> ezObjectTypeMap) {
        ArrayList<EZAnalysisType> analysisTypeList = new ArrayList<EZAnalysisType>();
        Set<EZAnalysisType> specificAnalysisTypes = MainframeAnalysisManager.getSpecificAnalysisTypes(ezObjectTypeMap.values());
        for (EZAnalysisType analysisType : specificAnalysisTypes) {
            if (!MainframeAnalysisManager.checkAnalysis(analysisType, ezObjectTypeMap.keySet())) continue;
            analysisTypeList.add(analysisType);
        }
        return analysisTypeList;
    }

    private static Set<EZAnalysisType> getSpecificAnalysisTypes(Collection<EZObjectType> eZObjectTypeCollection) {
        EZWorkspace wk = EZWorkspace.getInstance();
        HashSet<EZAnalysisType> ezAnalysisTypes = new HashSet<EZAnalysisType>();
        for (EZObjectType ezObjectType : eZObjectTypeCollection) {
            ezAnalysisTypes.addAll(wk.getSpecificAnalysisType(ezObjectType));
        }
        return ezAnalysisTypes;
    }

    public static void runAnalysis(EZAnalysisType ezAnalysisType, ResourceData resourceData, EZObjectType ezObjectType, Map<String, Object> aditionalContextValues) {
        MainframeAnalysisManager.runAnalysis(ezAnalysisType, (Map<ResourceData, EZObjectType>)new HashMap<ResourceData, EZObjectType>(resourceData, ezObjectType){
            private static final long serialVersionUID = 563190720581285684L;
            {
                this.put(resourceData, eZObjectType);
            }
        }, aditionalContextValues);
    }

    public static void runAnalysis(final EZAnalysisType ezAnalysisType, final Map<ResourceData, EZObjectType> ezObjectTypeMap, final Map<String, Object> aditionalContextValues) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow[] wnds = wb.getWorkbenchWindows();
        if (wnds != null && wnds.length > 0) {
            MainframeAnalysisManager.switchPerspective(wnds);
            new Job(Messages.getString(MainframeAnalysisManager.class, "configuringanalysis.jobname")){

                protected IStatus run(IProgressMonitor monitor) {
                    EZAnalysis analysis = MainframeAnalysisManager.createAnalysis(ezAnalysisType, ezObjectTypeMap, aditionalContextValues);
                    analysis.execute();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private static void switchPerspective(IWorkbenchWindow[] wnds) {
        final IWorkbenchWindow win = wnds[0];
        IWorkbenchPage page = win.getActivePage();
        IPerspectiveDescriptor perspective = page.getPerspective();
        String perspectiveId = perspective.getId();
        final String aBName = Messages.getString(MainframeAnalysisManager.class, "mainframe.projects.analysis.perspective.name");
        String switchPerspectiveProp = PreferenceUtils.getPreferenceStore().getString("switch_to_ezsource_analysis_browser");
        if (switchPerspectiveProp == "prompt" && !perspectiveId.equals("com.ez.analysisbrowser.perspectives.ViewerPerspective")) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialogWithToggle messageDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString(MainframeAnalysisManager.class, "dialog.title", new String[]{aBName}), (String)Messages.getString(MainframeAnalysisManager.class, "dialog.message", new String[]{aBName}), (String)Messages.getString(MainframeAnalysisManager.class, "dialog.remember.choose", new String[]{aBName}), (boolean)false, (IPreferenceStore)PreferenceUtils.getPreferenceStore(), (String)"switch_to_ezsource_analysis_browser");
                    if (messageDialog.getReturnCode() == 2) {
                        MainframeAnalysisManager.switchPerspective(win, aBName, "com.ez.analysisbrowser.perspectives.ViewerPerspective");
                    }
                    String switchPerspectiveProp = PreferenceUtils.getPreferenceStore().getString("switch_to_ezsource_analysis_browser");
                    L.debug("After message dialog: switchPerspective={}", (Object)switchPerspectiveProp);
                    PreferenceUtils.getPreferenceStore().setValue("switch_to_ezsource_analysis_browser", switchPerspectiveProp);
                }
            });
        }
        if (switchPerspectiveProp == "always") {
            MainframeAnalysisManager.switchPerspective(win, aBName, "com.ez.analysisbrowser.perspectives.ViewerPerspective");
        }
    }

    private static boolean checkAnalysis(EZAnalysisType ezAnalysisType, Set<ResourceData> resourceDataSet) {
        Registry reg = Registry.getInstance();
        String className = ezAnalysisType.getClazz().getName();
        boolean enabled = reg.check(className);
        PlatformUI.getPreferenceStore().firePropertyChangeEvent("action", (Object)new Boolean(false), (Object)new Boolean(enabled));
        new ArrayList();
        ArrayList<EZObjectType> ezSourceResourceInputTypeList = new ArrayList<EZObjectType>();
        EZInputFilter ezInputFilter = ezAnalysisType.getInputFilterInstance();
        for (ResourceData resourceData : resourceDataSet) {
            EZObjectType createEZObjectType = MainframeAnalysisManager.createEZObjectType(resourceData);
            ezSourceResourceInputTypeList.add(createEZObjectType);
        }
        if (ezInputFilter != null && enabled) {
            enabled = ezInputFilter.checkAnalysisAvailability(ezSourceResourceInputTypeList);
            L.trace("");
        }
        return enabled;
    }

    private static void switchPerspective(final IWorkbenchWindow win, final String aBName, final String aBid) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    L.debug("Switch perspective");
                    PlatformUI.getWorkbench().showPerspective(aBid, win);
                }
                catch (Throwable e) {
                    L.debug("Show perspective error", e);
                    Status st = LogUtil.createStatus((int)2, (Bundle)Activator.getDefault().getBundle(), (String)Messages.getString(MainframeAnalysisManager.class, "switchperspective.error.message", new String[]{aBName}), (Throwable)e);
                    LogUtil.displayErrorMessage((Status)st, (boolean)false);
                }
            }
        });
    }

    private static EZAnalysis createAnalysis(EZAnalysisType analysisType, Map<ResourceData, EZObjectType> ezObjectTypeMap, Map<String, Object> aditionalContextValues) {
        EZAnalysis analysis = analysisType.getImplementorInstance();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        for (Map.Entry<ResourceData, EZObjectType> entry : ezObjectTypeMap.entrySet()) {
            inputs.addAll(MainframeAnalysisManager.createInputs(entry.getKey(), analysisType, entry.getValue()));
        }
        analysis.addAllContextValues(aditionalContextValues);
        analysis.setInputs(inputs);
        return analysis;
    }

    private static List<EZObjectType> createInputs(ResourceData resourceData, EZAnalysisType analysisType, EZObjectType objType) {
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        inputs.add(objType);
        return inputs;
    }

    private static HashSet<EZSegment> createTableSegments(SQLTableData sQLTableData) {
        EZSourceSQLTableIDSg sTSg = new EZSourceSQLTableIDSg(sQLTableData.getName());
        return new HashSet<EZSourceSQLTableIDSg>(Arrays.asList(sTSg));
    }

    private static HashSet<EZSegment> createTransactionSegments(TransactionData transactionData) {
        EZSourceTransactionIDSg tSg = new EZSourceTransactionIDSg(transactionData.getName());
        return new HashSet<EZSourceTransactionIDSg>(Arrays.asList(tSg));
    }

    private static HashSet<EZSegment> createDataSetSegments(DataSetData dataSetData) {
        EZSourceDatasetIDSg dsSg = new EZSourceDatasetIDSg(dataSetData.getName(), Integer.valueOf(dataSetData.getId()), dataSetData.getMemberName(), dataSetData.getGenerationNumber());
        dsSg.setIncompleteSegment(true);
        return new HashSet<EZSourceDatasetIDSg>(Arrays.asList(dsSg));
    }

    private static HashSet<EZSegment> createPrgSegments(ProgramData programData) {
        boolean occ = false;
        if (programData.getOccurID() != null) {
            try {
                occ = Integer.valueOf(programData.getOccurID()) > 0;
            }
            catch (NumberFormatException ex) {
                L.debug("wrong data for programs.occurid; programData={}", (Object)programData, (Object)ex);
            }
        }
        EZSourceProgramIDSg prgSg = new EZSourceProgramIDSg(programData.getName(), Integer.valueOf(programData.getId()), Integer.valueOf(programData.getTypeID()), Boolean.valueOf(occ));
        prgSg.setAncestorName(programData.getAncestorName());
        return new HashSet<EZSourceProgramIDSg>(Arrays.asList(prgSg));
    }

    private static HashSet<EZSegment> createIncludeSegments(IncludeData includeData, EZObjectType ezObjectType) {
        EZSourceIncludeIDSg inclSg = new EZSourceIncludeIDSg(includeData.getName(), Integer.valueOf(includeData.getId()));
        EZSourceProgramTypeIDSg prgTypeIdSg = new EZSourceProgramTypeIDSg(Integer.valueOf(includeData.getProgramTypeID()));
        ezObjectType.addProperty("mainframe resource id sg", (Object)inclSg);
        return new HashSet<EZSegment>(Arrays.asList(inclSg, prgTypeIdSg));
    }

    private static HashSet<EZSegment> createJobSegments(JobData jobData) {
        EZSourceJobIDSg jobSg = new EZSourceJobIDSg(jobData.getName(), jobData.getId(), Integer.valueOf(jobData.getTypeID()), jobData.getMemberName());
        jobSg.setDeleted(jobData.isDeleted());
        EZSourceAAUTOJobIDSg aautoFakeSg = new EZSourceAAUTOJobIDSg(jobData.getName(), null);
        return new HashSet<EZSourceResourceIDSg>(Arrays.asList(jobSg, aautoFakeSg));
    }

    private static EZSourceProjectIDSg createPrjSegment(ResourceData resourceData) {
        EZSourceProjectIDSg prjSg = new EZSourceProjectIDSg(resourceData.getProjectData().getProjectInfo());
        return prjSg;
    }

    public static ICategory getCategoryName(EZAnalysisType analysisType) {
        String category = analysisType.getCategory();
        EZWorkspace wk = EZWorkspace.getInstance();
        CategoryManager cm = wk.getCategoryManager();
        ICategory categoryObj = null;
        if (cm != null && category != null) {
            categoryObj = cm.getCategory(category);
        }
        return categoryObj;
    }
}

