/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis;

import com.ez.common.ui.listselection.Listable;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.rdz.resources.mainframe.analysis.RDZMainframeAnalysisWizard;
import com.ez.rdz.utils.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.report.application.utils.ProjectInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDZSelectProjectPage
extends SelectProgramsPage<ProjectInput> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(RDZSelectProjectPage.class);

    public RDZSelectProjectPage(String pageName, RDZMainframeAnalysisWizard rdzMainframeAnalysisWizard) {
        super(pageName);
        this.setTitle(Messages.getString(RDZSelectProjectPage.class, "page.title"));
        this.setDescription(Messages.getString(RDZSelectProjectPage.class, "page.description"));
        this.setLeftGroupLabel(Messages.getString(RDZSelectProjectPage.class, "av.applications.objectType"));
        this.setRightGroupLabel(Messages.getString(RDZSelectProjectPage.class, "sel.applications.objectType"));
        this.setAvailablePropName("available applications for rdz");
        this.setSelectedPropName("selected applications for rdz");
        this.MINIM_SIZE_OF_SELECTED = 1;
        this.setWizard((IWizard)rdzMainframeAnalysisWizard);
    }

    public RDZMainframeAnalysisWizard getRDZMainframeAnalysisWizard() {
        return (RDZMainframeAnalysisWizard)this.getWizard();
    }

    public void fillUIWithProgress() {
        this.propertiesGroup.clearUILists();
        this.wizard.runLongOperation(new PrepareReportWizard.LongOperation(){

            public void runOperation(IProgressMonitor pmonitor) throws Exception {
                if (L.isDebugEnabled()) {
                    L.debug("Acquire project list");
                }
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
                List<ProjectInfo> existingProjects = RDZSelectProjectPage.this.getRDZMainframeAnalysisWizard().getExistingProjects();
                final ArrayList<1> projectList = new ArrayList<1>();
                final ArrayList<Listable> selectedProjectList = new ArrayList<Listable>();
                Collection<String> selectedProjectsFromDataStore = RDZSelectProjectPage.this.getRDZMainframeAnalysisWizard().getSelectedProjectsFromDataStore();
                for (ProjectInfo projectInfo : existingProjects) {
                    ProjectInput projectInput = new ProjectInput(projectInfo.getName()){

                        public String toString() {
                            return this.getListableName();
                        }
                    };
                    if (selectedProjectsFromDataStore.contains(projectInput.toString())) {
                        selectedProjectList.add((Listable)projectInput);
                        continue;
                    }
                    projectList.add(projectInput);
                }
                RDZSelectProjectPage.this.getRDZMainframeAnalysisWizard().setSelectedProjects(selectedProjectList);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RDZSelectProjectPage.this.propertiesGroup.setAvailable((List)projectList);
                        RDZSelectProjectPage.this.propertiesGroup.setSelected((List)selectedProjectList);
                    }
                });
                monitor.setWorkRemaining(0);
            }

            public Wizard getWizard() {
                return RDZSelectProjectPage.this.wizard;
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public boolean isPageComplete() {
        this.propertiesGroup.manageButtons();
        this.getRDZMainframeAnalysisWizard().updateFileDataStore();
        return super.isPageComplete();
    }

    public IWizardPage getNextPage() {
        return this.getRDZMainframeAnalysisWizard().getNextPage((IWizardPage)this);
    }
}

