/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis;

import com.ez.common.ui.listselection.Listable;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.rdz.resources.mainframe.analysis.IResourceIdentifier;
import com.ez.rdz.resources.mainframe.analysis.RDZMainframeAnalysisWizard;
import com.ez.rdz.resources.mainframe.analysis.manager.model.CICSProgramData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.IncludeData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.JobData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ProgramData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ProjectData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ResourceData;
import com.ez.rdz.utils.Messages;
import com.ez.report.application.ui.wizard.AbstractWizardPage;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.workspace.gui.swt.utils.TableViewerComparator;
import com.ez.workspace.gui.swt.utils.TreeObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDZSelectAnalysisPage
extends AbstractWizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(RDZSelectAnalysisPage.class);
    private TableViewer programTableViewer;
    private TreeViewer analysisTreeViewer;
    private Text filterText;
    private Table programTable;
    private String analysisTreeViewerFilterValue;
    private Map<String, ProjectData> map = new HashMap<String, ProjectData>();
    private Map<ResourceData, IResourceIdentifier> findMap = new HashMap<ResourceData, IResourceIdentifier>();
    private MyTableViewerComparator viewerComparator;
    private Composite resourceComposite;

    protected RDZSelectAnalysisPage(String pageName, RDZMainframeAnalysisWizard rdzMainframeAnalysisWizard) {
        super(pageName);
        this.setTitle(Messages.getString(RDZSelectAnalysisPage.class, "page.title"));
        this.setDescription(Messages.getString(RDZSelectAnalysisPage.class, "page.description"));
        this.setWizard((IWizard)rdzMainframeAnalysisWizard);
    }

    private RDZMainframeAnalysisWizard getRDZMainframeAnalysisWizard() {
        return (RDZMainframeAnalysisWizard)this.getWizard();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updatePage();
        } else {
            this.getRDZMainframeAnalysisWizard().setSelectedObjectForAnalisys(null);
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createDialogArea(composite);
        this.setControl((Control)composite);
    }

    protected void createContent(Composite composite) {
        this.createControl(composite);
    }

    private void updatePage() {
        this.getRDZMainframeAnalysisWizard().runLongOperation(new PrepareReportWizard.LongOperation(){

            public void runOperation(IProgressMonitor pmonitor) throws Exception {
                try {
                    SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
                    List<Listable> projectList = RDZSelectAnalysisPage.this.getRDZMainframeAnalysisWizard().getSelectedProjects();
                    List<ProjectInfo> existing = RDZSelectAnalysisPage.this.getRDZMainframeAnalysisWizard().getExistingProjects();
                    ProjectInfo[] projects = new ProjectInfo[projectList.size()];
                    int i = 0;
                    block2: for (ProjectInfo pi : existing) {
                        for (Listable project : projectList) {
                            if (!pi.getName().equals(project.toString())) continue;
                            projects[i++] = pi;
                            continue block2;
                        }
                    }
                    final List resourceDataList = RDZSelectAnalysisPage.this.getProjectsData(projects, (IProgressMonitor)monitor.newChild(100));
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            RDZSelectAnalysisPage.this.updateComponents(resourceDataList);
                            RDZSelectAnalysisPage.this.programTableViewer.setInput((Object)resourceDataList);
                            if (resourceDataList.size() == 0) {
                                RDZSelectAnalysisPage.this.setErrorMessage(Messages.getString(RDZSelectAnalysisPage.class, "page.error.dataNotFound"));
                            } else {
                                if (resourceDataList.size() == 1) {
                                    RDZSelectAnalysisPage.this.programTableViewer.getTable().select(0);
                                    RDZSelectAnalysisPage.this.updateAnalysisTreeWithSelection((StructuredSelection)RDZSelectAnalysisPage.this.programTableViewer.getSelection());
                                }
                                RDZSelectAnalysisPage.this.setErrorMessage(null);
                                RDZSelectAnalysisPage.this.setMessage(Messages.getString(RDZSelectAnalysisPage.class, "page.description"));
                            }
                        }
                    });
                }
                catch (CanceledException canceledException) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            RDZSelectAnalysisPage.this.setErrorMessage(Messages.getString(RDZSelectAnalysisPage.class, "page.error.operationCanceled"));
                        }
                    });
                }
            }

            public Wizard getWizard() {
                return (Wizard)RDZSelectAnalysisPage.this.getWizard();
            }
        });
    }

    private List<ResourceData> getProjectsData(ProjectInfo[] projects, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)projects.length);
        monitor.subTask(Messages.getString(RDZSelectAnalysisPage.class, "monitor.subTask.inspectProjects"));
        ArrayList<ResourceData> resourceDataList = new ArrayList<ResourceData>();
        ProjectInfo[] projectInfoArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectInfo pi = projectInfoArray[n2];
            if (monitor.isCanceled()) {
                throw new CanceledException("Analysis canceled by user");
            }
            monitor.subTask(Messages.getString(RDZSelectAnalysisPage.class, "monitor.subTask.inspectProjectsName", new String[]{pi.getName()}));
            resourceDataList.addAll(this.handleProject(pi, this.getRDZMainframeAnalysisWizard().getRdzResourceIdentifiers(), (IProgressMonitor)monitor.newChild(1)));
            ++n2;
        }
        monitor.done();
        return resourceDataList;
    }

    private List<ResourceData> handleProject(ProjectInfo pi, Collection<IResourceIdentifier> rdzResourceIdentifiers, IProgressMonitor pmonitor) {
        ProjectData projectData;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        ArrayList resourceDataList = null;
        if (this.map.containsKey(pi.getName())) {
            projectData = this.map.get(pi.getName());
        } else {
            projectData = this.getProjectData(pi, rdzResourceIdentifiers, (IProgressMonitor)monitor.newChild(100));
            this.map.put(pi.getName(), projectData);
        }
        if (projectData != null) {
            resourceDataList = projectData.getResourceDataList();
        }
        monitor.done();
        return resourceDataList != null ? resourceDataList : new ArrayList();
    }

    private ProjectData getProjectData(final ProjectInfo pi, final Collection<IResourceIdentifier> rdzResourceIdentifiers, IProgressMonitor pmonitor) {
        final String prjName = pi.getName();
        L.debug("will open project {}", (Object)prjName);
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(prjName, null);
        final ProjectData[] projectData = new ProjectData[1];
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                    projectData[0] = new ProjectData(prjName, pi);
                    for (IResourceIdentifier rdzResourceIdentifier : rdzResourceIdentifiers) {
                        List<ResourceData> resourceDataList = rdzResourceIdentifier.getIdentifierData(conn);
                        for (ResourceData resourceData : resourceDataList) {
                            projectData[0].addResource(resourceData);
                            RDZSelectAnalysisPage.this.findMap.put(resourceData, rdzResourceIdentifier);
                        }
                    }
                }
            }, LockType.Shared, pmonitor);
        }
        catch (InterruptedException e) {
            L.error("InterruptedException for project {}", (Object)prjName, (Object)e);
        }
        catch (ExecutionException e) {
            L.error("ExecutionException for project {}", (Object)prjName, (Object)e);
        }
        return projectData[0];
    }

    protected Control createDialogArea(Composite parent) {
        parent.setVisible(false);
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control w = controlArray[n2];
            w.dispose();
            ++n2;
        }
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(parent, 0);
        parent.setSize(800, 500);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 35;
        gridLayout.marginTop = 15;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        this.draw(composite);
        parent.pack();
        parent.setVisible(true);
        return composite;
    }

    private void draw(Composite parentComposite) {
        Composite composite = new Composite(parentComposite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        composite.setLayout((Layout)gridLayout);
        this.resourceComposite = new Composite(composite, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        this.resourceComposite.setLayout((Layout)gridLayout);
        SashForm sashForm = new SashForm(parentComposite, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        sashForm.setVisible(true);
        composite = new Composite((Composite)sashForm, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginRight = 15;
        composite.setLayout((Layout)gridLayout);
        Group group = new Group(composite, 0x1000000);
        group.setLayoutData((Object)new GridData(1808));
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        group.setLayout((Layout)gridLayout);
        String msg1 = Messages.getString(RDZSelectAnalysisPage.class, "group.text.resourcesFound");
        group.setText(msg1);
        this.programTable = new Table((Composite)group, 68354);
        GridData gridData = new GridData(4, 4, true, true);
        this.programTable.setLayoutData((Object)gridData);
        this.initProgramTable(this.programTable);
        composite = new Composite((Composite)sashForm, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 15;
        composite.setLayout((Layout)gridLayout);
        group = new Group(composite, 0x1000000);
        group.setLayoutData((Object)new GridData(1808));
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        group.setLayout((Layout)gridLayout);
        String msg2 = Messages.getString(RDZSelectAnalysisPage.class, "group.text.availableAnalysis");
        group.setText(msg2);
        Tree analysisTree = new Tree((Composite)group, 268438276);
        gridData = new GridData(4, 4, true, true);
        analysisTree.setLayoutData((Object)gridData);
        this.initAnalysisTree(analysisTree);
        Composite filterComposite = new Composite((Composite)group, 0);
        gridData = new GridData(768);
        filterComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        filterComposite.setLayout((Layout)gridLayout);
        Label label = new Label(filterComposite, 0);
        label.setText(Messages.getString(RDZSelectAnalysisPage.class, "label.text.filterName"));
        this.filterText = new Text(filterComposite, 2048);
        gridData = new GridData(768);
        this.filterText.setLayoutData((Object)gridData);
        sashForm.setWeights(new int[]{50, 50});
        this.addListeners();
    }

    private void initProgramTable(Table programTable) {
        programTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(programTable, 16384);
        column.setText(Messages.getString(RDZSelectAnalysisPage.class, "table.column.name.availableAnalysis.projectName"));
        column.setWidth(100);
        column.setResizable(true);
        column = new TableColumn(programTable, 131072);
        column.setText(Messages.getString(RDZSelectAnalysisPage.class, "table.column.name.availableAnalysis.type"));
        column.setWidth(100);
        column.setAlignment(16384);
        this.programTableViewer = new TableViewer(programTable);
        this.generateProgramTableViewerProviders(this.programTableViewer);
    }

    private void initTableColumns(List<ResourceData> list, Table programTable) {
        boolean multipleResults = list.size() == 1 || list.size() == 0 && this.getRDZMainframeAnalysisWizard().getRdzResourceIdentifiers().size() > 1;
        int[] columnOrder = this.getRDZMainframeAnalysisWizard().getRdzResourceIdentifiers().iterator().next().addTableColumns(programTable, !multipleResults);
        programTable.setColumnOrder(columnOrder);
    }

    private void updateComponents(List<ResourceData> list) {
        TableColumn[] columns = this.programTableViewer.getTable().getColumns();
        if (columns.length <= 2) {
            this.initTableColumns(list, this.programTable);
        }
        Collection<IResourceIdentifier> rdzResourceIdentifiers = this.getRDZMainframeAnalysisWizard().getRdzResourceIdentifiers();
        boolean multipleResults = list.size() > 1 || list.size() == 0 && rdzResourceIdentifiers.size() > 1;
        Control[] controlArray = this.resourceComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (!multipleResults) {
            IResourceIdentifier first = rdzResourceIdentifiers.iterator().next();
            List<Pair<String, String>> reqLables = first.getLabledFields();
            for (Pair<String, String> reqLable : reqLables) {
                Label label = new Label(this.resourceComposite, 0);
                label.setText(Messages.getString(RDZSelectAnalysisPage.class, (String)reqLable.getSecond()));
                label = new Label(this.resourceComposite, 0);
                label.setText((String)reqLable.getFirst());
            }
        }
        this.resourceComposite.getParent().getParent().layout();
        this.resourceComposite.layout();
    }

    private void generateProgramTableViewerProviders(TableViewer tableViewer) {
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.viewerComparator = new MyTableViewerComparator(tableViewer.getTable());
        tableViewer.setComparator((ViewerComparator)this.viewerComparator);
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){
            private Map<ImageDescriptor, Image> imageDescriptorToImage = new HashMap<ImageDescriptor, Image>();
            Object prevElement = null;

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((ResourceData)element).getProjectData().getProjectName();
                    }
                    case 1: {
                        return ((ResourceData)element).getTypeName();
                    }
                    case 2: {
                        if (element instanceof CICSProgramData) {
                            String name = ((CICSProgramData)element).getDisplayName(this.prevElement);
                            this.prevElement = element;
                            return name;
                        }
                        if (element instanceof ProgramData) {
                            return ((ProgramData)element).getAncestorName();
                        }
                        return ((IResourceIdentifier)RDZSelectAnalysisPage.this.findMap.get(element)).getColumnText(columnIndex);
                    }
                    case 3: {
                        if (element instanceof CICSProgramData) {
                            return ((CICSProgramData)element).getPath();
                        }
                        if (element instanceof ProgramData || element instanceof JobData || element instanceof IncludeData) {
                            return ((ResourceData)element).getName();
                        }
                    }
                    case 4: 
                    case 5: {
                        return ((IResourceIdentifier)RDZSelectAnalysisPage.this.findMap.get(element)).getColumnText(columnIndex);
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                ImageDescriptor imageDescriptor = ((ResourceData)element).getProjectData().getProjectInfo().getDescriptor();
                Image image = null;
                if (columnIndex == 0) {
                    image = this.imageDescriptorToImage(imageDescriptor);
                }
                return image;
            }

            private Image imageDescriptorToImage(ImageDescriptor imageDescriptor) {
                Image image = this.imageDescriptorToImage.get(imageDescriptor);
                if (image == null) {
                    image = new Image((Device)Display.getDefault(), imageDescriptor.getImageData());
                    this.imageDescriptorToImage.put(imageDescriptor, image);
                }
                return image;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
                for (Image image : this.imageDescriptorToImage.values()) {
                    if (image.isDisposed()) continue;
                    image.dispose();
                }
            }

            public void addListener(ILabelProviderListener listener) {
            }
        });
    }

    private void initAnalysisTree(Tree analysisTree) {
        this.analysisTreeViewer = new TreeViewer(analysisTree);
        this.generateProgramTreeViewerProviders(this.analysisTreeViewer);
    }

    private void generateProgramTreeViewerProviders(TreeViewer analysisTreeViewer) {
        analysisTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return ((TreeObject)element).getChildren().size() > 0;
            }

            public Object getParent(Object element) {
                return ((TreeObject)element).getParent();
            }

            public Object[] getElements(Object inputElement) {
                Collection<TreeObject<?>> result = null;
                TreeElementHandler handler = RDZSelectAnalysisPage.this.getRDZMainframeAnalysisWizard().getTreeElementHandler();
                result = handler.getTreeElements((List)inputElement);
                return result.toArray();
            }

            public Object[] getChildren(Object element) {
                return ((TreeObject)element).getChildren().toArray();
            }
        });
        analysisTreeViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                ImageDescriptor imageDescriptor = ((TreeObject)element).getImageDescriptor();
                return imageDescriptor != null ? imageDescriptor.createImage() : null;
            }
        });
        analysisTreeViewer.setSorter(new ViewerSorter());
        analysisTreeViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer arg0, Object arg1, Object arg2) {
                boolean retVal = false;
                if (arg2 instanceof TreeObject) {
                    retVal = ((TreeObject)arg2).testFilter(RDZSelectAnalysisPage.this.analysisTreeViewerFilterValue, true);
                } else {
                    retVal = false;
                    L.debug("arg2 must be a {}", (Object)TreeObject.class.getSimpleName());
                }
                return retVal;
            }
        }});
    }

    public boolean isPageComplete() {
        return true;
    }

    private void updateAnalysisTreeWithSelection(StructuredSelection selection) {
        List list = selection.toList();
        this.getRDZMainframeAnalysisWizard().setUsedProjects(list);
        this.analysisTreeViewer.setInput((Object)list);
        this.analysisTreeViewer.expandToLevel(2);
    }

    private void addListeners() {
        this.programTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof StructuredSelection)) {
                    throw new IllegalStateException("The selection from Table must be a StructuredSelection");
                }
                RDZSelectAnalysisPage.this.updateAnalysisTreeWithSelection((StructuredSelection)selection);
            }
        });
        TableColumn[] columns = this.programTableViewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            final int val = i;
            columns[i].addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    RDZSelectAnalysisPage.this.viewerComparator.setColumn(val);
                    RDZSelectAnalysisPage.this.programTableViewer.refresh();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++i;
        }
        this.analysisTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedObject;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection) {
                    selectedObject = ((StructuredSelection)selection).getFirstElement();
                    if (!(selectedObject instanceof TreeObject)) {
                        throw new IllegalStateException("The selection from Table must be a TreeObject");
                    }
                } else {
                    throw new IllegalStateException("The selection from Table must be a StructuredSelection");
                }
                RDZSelectAnalysisPage.this.analysisTreeViewer.expandToLevel(selectedObject, 1);
                ((TreeObject)selectedObject).doubleClickActionHandler();
            }
        });
        this.analysisTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection) {
                    Object selectedObject = ((StructuredSelection)selection).getFirstElement();
                    if (selectedObject instanceof TreeObject) {
                        RDZSelectAnalysisPage.this.getRDZMainframeAnalysisWizard().setSelectedObjectForAnalisys((TreeObject)selectedObject);
                        RDZSelectAnalysisPage.this.getRDZMainframeAnalysisWizard().getContainer().updateButtons();
                    } else {
                        L.debug("The selection from Table must be a TreeObject");
                    }
                } else {
                    L.debug("The selection from Table must be a StructuredSelection");
                }
            }
        });
        this.filterText.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                RDZSelectAnalysisPage.this.analysisTreeViewerFilterValue = RDZSelectAnalysisPage.this.filterText.getText();
                RDZSelectAnalysisPage.this.analysisTreeViewer.refresh();
                RDZSelectAnalysisPage.this.analysisTreeViewer.expandToLevel(2);
            }
        });
    }

    public class MyTableViewerComparator
    extends TableViewerComparator<ResourceData> {
        public MyTableViewerComparator(Table table) {
            super(table);
        }

        public int compare(int propertyIndex, int direction, ResourceData resourceData1, ResourceData resourceData2) {
            int retVal = 0;
            switch (propertyIndex) {
                case 0: {
                    retVal = resourceData1.getProjectData().getProjectName().compareToIgnoreCase(resourceData2.getProjectData().getProjectName());
                    break;
                }
                case 1: {
                    retVal = resourceData1.getTypeName().compareToIgnoreCase(resourceData2.getTypeName());
                    break;
                }
                case 2: {
                    String ancestor1 = "";
                    String ancestor2 = "";
                    if (resourceData1 instanceof ProgramData && ((ProgramData)resourceData1).getAncestorName() != null) {
                        ancestor1 = ((ProgramData)resourceData1).getAncestorName();
                    }
                    if (resourceData2 instanceof ProgramData && ((ProgramData)resourceData2).getAncestorName() != null) {
                        ancestor2 = ((ProgramData)resourceData2).getAncestorName();
                    }
                    retVal = ancestor1.compareToIgnoreCase(ancestor2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    return ((IResourceIdentifier)RDZSelectAnalysisPage.this.findMap.get(resourceData1)).getColumnText(propertyIndex).compareTo(((IResourceIdentifier)RDZSelectAnalysisPage.this.findMap.get(resourceData2)).getColumnText(propertyIndex));
                }
                default: {
                    retVal = 0;
                }
            }
            if (direction == 1024) {
                retVal = -retVal;
            }
            return retVal;
        }
    }

    public static interface TreeElementHandler {
        public Collection<TreeObject<?>> getTreeElements(List<ResourceData> var1);
    }
}

