/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.Pair;
import com.ez.rdz.resources.mainframe.analysis.AbstractResourceIdentifier;
import com.ez.rdz.resources.mainframe.analysis.manager.model.IncludeData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.JobData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ProgramData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ResourceData;
import com.ez.rdz.utils.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RDZPartitionedDataSetMemberIdentifier
extends AbstractResourceIdentifier {
    private final String systemIp;
    private final String libraryName;
    private final String memberName;
    private List<ResourceData> list = new ArrayList<ResourceData>();
    private static String programQuery = "SELECT DISTINCT \n\tA.ProgramID, \n\tA.ProgramName, \n\tA.Ancestor, \n\tA.ProgramTypeID, \n\tD.ProgramType, \n\tC.Connection, \n\tA.OccurID \nFROM Programs A \n\tINNER JOIN Occurrences B ON A.OccurID = B.OccurID \n\tINNER JOIN ( \n\t\tSELECT \n\t\t\tT.PathID, \n\t\t\tT.PathStr, \n\t\t\tSUBSTRING(T.PathStr, \n\t\t\t\tCHARINDEX('Mainframe Library Members', T.PathStr) + 26, \n\t\t\t\tCHARINDEX('\\', T.PathStr, CHARINDEX('Mainframe Library Members', T.PathStr) + 26) - (CHARINDEX('Mainframe Library Members', T.PathStr) + 26) \n\t\t\t) AS Connection \n\t\tFROM Paths T \n\t\tWHERE CHARINDEX('Mainframe Library Members', T.PathStr) > 0 \n\t) C ON B.PathID = C.PathID \n\tINNER JOIN ProgramTypes D ON A.ProgramTypeID = D.ProgramTypeID \n\tINNER JOIN MFLPARInfo E ON C.Connection = E.MVSConnectionName \nWHERE (C.PathStr LIKE '%%\\Mainframe Library Members\\%%\\%s\\%s') \n\tAND (E.IPAddress = '%s') ";
    private static String programQueryDB2 = "SELECT DISTINCT \n\tA.ProgramID, \n\tA.ProgramName, \n\tA.Ancestor, \n\tA.ProgramTypeID, \n\tD.ProgramType, \n\tC.Connection, \n\tA.OccurID \nFROM Programs A \n\tINNER JOIN Occurrences B ON A.OccurID = B.OccurID \n\tINNER JOIN ( \n\t\tSELECT \n\t\t\tT.PathID, \n\t\t\tT.PathStr, \n\t\t\tSUBSTR(UPPER(T.PathStr), \n\t\t\t\tLOCATE_IN_STRING(UPPER(T.PathStr), 'MAINFRAME LIBRARY MEMBERS') + 26, \n\t\t\t\tLOCATE_IN_STRING(T.PathStr, '\\', LOCATE_IN_STRING(UPPER(T.PathStr), 'MAINFRAME LIBRARY MEMBERS') + 26) - (LOCATE_IN_STRING(UPPER(T.PathStr), 'MAINFRAME LIBRARY MEMBERS') + 26) \n\t\t\t) AS Connection \n\t\tFROM Paths T \n\t\tWHERE LOCATE_IN_STRING(UPPER(T.PathStr), 'MAINFRAME LIBRARY MEMBERS') > 0 \n\t) C ON B.PathID = C.PathID \n\tINNER JOIN ProgramTypes D ON A.ProgramTypeID = D.ProgramTypeID \n\tINNER JOIN MFLPARInfo E ON C.Connection = E.MVSConnectionName \nWHERE (UPPER(C.PathStr) LIKE UPPER('%%\\MAINFRAME LIBRARY MEMBERS\\%%\\%s\\%s')) \n\tAND (UPPER(E.IPAddress) = UPPER('%s')) ";
    private static String jobQuery = "SELECT DISTINCT \n\tA.JobID, \n\tA.JobName, \n\tA.MemberName, \n\tB.Connection, \n\tA.BuildStatus \nFROM JCLJob A \n\tINNER JOIN ( \n\t\tSELECT \n\t\t\tT.PositionID, \n\t\t\tT.ResourceFilePath, \n\t\t\tSUBSTRING(T.ResourceFilePath, \n\t\t\t\tCHARINDEX('Mainframe Library Members', T.ResourceFilePath) + 26, \n\t\t\t\tCHARINDEX('\\', T.ResourceFilePath, CHARINDEX('Mainframe Library Members', T.ResourceFilePath) + 26) - (CHARINDEX('Mainframe Library Members', T.ResourceFilePath) + 26) \n\t\t\t) AS Connection \n\t\tFROM JCLPosition T \n\t\tWHERE CHARINDEX('Mainframe Library Members', T.ResourceFilePath) > 0 \n\t) B ON A.PositionID = B.PositionID \n\tINNER JOIN MFLPARInfo C ON B.Connection = C.MVSConnectionName \nWHERE (B.ResourceFilePath LIKE '%%\\Mainframe Library Members\\%%\\%s\\%s') \n\tAND (C.IPAddress = '%s') ";
    private static String jobQueryDB2 = "SELECT DISTINCT \n\tA.JobID, \n\tA.JobName, \n\tA.MemberName, \n\tB.Connection, \n\tA.BuildStatus \nFROM JCLJob A \n\tINNER JOIN ( \n\t\tSELECT \n\t\t\tT.PositionID, \n\t\t\tT.ResourceFilePath, \n\t\t\tSUBSTR(UPPER(T.ResourceFilePath), \n\t\t\t\tLOCATE_IN_STRING(UPPER(T.ResourceFilePath), 'MAINFRAME LIBRARY MEMBERS') + 26, \n\t\t\t\tLOCATE_IN_STRING(T.ResourceFilePath, '\\', LOCATE_IN_STRING(UPPER(T.ResourceFilePath), 'MAINFRAME LIBRARY MEMBERS') + 26) - (LOCATE_IN_STRING(UPPER(T.ResourceFilePath), 'MAINFRAME LIBRARY MEMBERS') + 26) \n\t\t\t) AS Connection \n\t\tFROM JCLPosition T \n\t\tWHERE LOCATE_IN_STRING(UPPER(T.ResourceFilePath), 'MAINFRAME LIBRARY MEMBERS') > 0 \n\t) B ON A.PositionID = B.PositionID \n\tINNER JOIN MFLPARInfo C ON B.Connection = C.MVSConnectionName \nWHERE (UPPER(B.ResourceFilePath) LIKE UPPER('%%\\MAINFRAME LIBRARY MEMBERS\\%%\\%s\\%s')) \n\tAND (UPPER(C.IPAddress) = UPPER('%s')) ";
    private static String includeQuery = "SELECT DISTINCT \n\tD.PathID, \n\tA.Name, \n\tA.ResourceType AS ResourceTypeID, \n\tG.Name AS ResourceType, \n\tE.ProgramTypeID, \n\tF.ProgramType, \n\tD.Connection \nFROM Resources A \n\tINNER JOIN StatementReference B ON A.ResourceID = B.ResourceID \n\tINNER JOIN Occurrences C ON A.OccurID = C.OccurID \n\tINNER JOIN ( \n\t\tSELECT \n\t\t\tT.PathID, \n\t\t\tT.PathStr, \n\t\t\tSUBSTRING(T.PathStr, \n\t\t\t\tCHARINDEX('Mainframe Library Members', T.PathStr) + 26, \n\t\t\t\tCHARINDEX('\\', T.PathStr, CHARINDEX('Mainframe Library Members', T.PathStr) + 26) - (CHARINDEX('Mainframe Library Members', T.PathStr) + 26) \n\t\t\t) AS Connection \n\t\tFROM Paths T \n\t\tWHERE CHARINDEX('Mainframe Library Members', T.PathStr) > 0 \n\t) D ON C.PathID = D.PathID \n\tINNER JOIN Programs E ON C.ProgID = E.ProgramID \n\tINNER JOIN ProgramTypes F ON E.ProgramTypeID = F.ProgramTypeID \n\tINNER JOIN ResourceTypes G ON A.ResourceType = G.ResourceID \n\tINNER JOIN MFLPARInfo H ON D.Connection = H.MVSConnectionName \nWHERE (D.PathStr LIKE '%%\\Mainframe Library Members\\%%\\%s\\%s') \n\tAND (H.IPAddress = '%s') ";
    private static String includeQueryDB2 = "SELECT DISTINCT \n\tD.PathID, \n\tA.Name, \n\tA.ResourceType AS ResourceTypeID, \n\tG.Name AS ResourceType, \n\tE.ProgramTypeID, \n\tF.ProgramType, \n\tD.Connection \nFROM Resources A \n\tINNER JOIN StatementReference B ON A.ResourceID = B.ResourceID \n\tINNER JOIN Occurrences C ON A.OccurID = C.OccurID \n\tINNER JOIN ( \n\t\tSELECT \n\t\t\tT.PathID, \n\t\t\tT.PathStr, \n\t\t\tSUBSTR(UPPER(T.PathStr), \n\t\t\t\tLOCATE_IN_STRING(UPPER(T.PathStr), 'MAINFRAME LIBRARY MEMBERS') + 26, \n\t\t\t\tLOCATE_IN_STRING(T.PathStr, '\\', LOCATE_IN_STRING(UPPER(T.PathStr), 'MAINFRAME LIBRARY MEMBERS') + 26) - (LOCATE_IN_STRING(UPPER(T.PathStr), 'MAINFRAME LIBRARY MEMBERS') + 26) \n\t\t\t) AS Connection \n\t\tFROM Paths T \n\t\tWHERE LOCATE_IN_STRING(UPPER(T.PathStr), 'MAINFRAME LIBRARY MEMBERS') > 0 \n\t) D ON C.PathID = D.PathID \n\tINNER JOIN Programs E ON C.ProgID = E.ProgramID \n\tINNER JOIN ProgramTypes F ON E.ProgramTypeID = F.ProgramTypeID \n\tINNER JOIN ResourceTypes G ON A.ResourceType = G.ResourceID \n\tINNER JOIN MFLPARInfo H ON D.Connection = H.MVSConnectionName \nWHERE (UPPER(D.PathStr) LIKE UPPER('%%\\MAINFRAME LIBRARY MEMBERS\\%%\\%s\\%s')) \n\tAND (UPPER(H.IPAddress) = UPPER('%s')) ";

    public RDZPartitionedDataSetMemberIdentifier(String systemIp, String libraryName, String memberName) {
        this.systemIp = systemIp;
        this.libraryName = libraryName;
        this.memberName = memberName;
    }

    @Override
    public int[] addTableColumns(Table programTable, boolean multiple) {
        TableColumn column = new TableColumn(programTable, 131072);
        column.setText(Messages.getString(RDZPartitionedDataSetMemberIdentifier.class, "table.column.name.availableAnalysis.ancestor"));
        column.setWidth(89);
        column.setAlignment(16384);
        if (multiple) {
            column = new TableColumn(programTable, 131072);
            column.setText(Messages.getString(RDZPartitionedDataSetMemberIdentifier.class, "table.column.name.availableAnalysis.memberName"));
            column.setWidth(110);
            column.setResizable(true);
            column.setAlignment(16384);
            column = new TableColumn(programTable, 131072);
            column.setText(Messages.getString(RDZPartitionedDataSetMemberIdentifier.class, "table.column.name.availableAnalysis.systemName"));
            column.setWidth(120);
            column.setResizable(true);
            column.setAlignment(16384);
            column = new TableColumn(programTable, 131072);
            column.setText(Messages.getString(RDZPartitionedDataSetMemberIdentifier.class, "table.column.name.availableAnalysis.libraryName"));
            column.setWidth(120);
            column.setResizable(true);
            column.setAlignment(16384);
            int[] nArray = new int[6];
            nArray[1] = 5;
            nArray[2] = 3;
            nArray[3] = 1;
            nArray[4] = 2;
            nArray[5] = 4;
            return nArray;
        }
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        return nArray;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.libraryName == null ? 0 : this.libraryName.hashCode());
        result = 31 * result + (this.memberName == null ? 0 : this.memberName.hashCode());
        result = 31 * result + (this.systemIp == null ? 0 : this.systemIp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RDZPartitionedDataSetMemberIdentifier other = (RDZPartitionedDataSetMemberIdentifier)obj;
        if (this.libraryName == null ? other.libraryName != null : !this.libraryName.equals(other.libraryName)) {
            return false;
        }
        if (this.memberName == null ? other.memberName != null : !this.memberName.equals(other.memberName)) {
            return false;
        }
        return !(this.systemIp == null ? other.systemIp != null : !this.systemIp.equals(other.systemIp));
    }

    public String toString() {
        return "RDZPartitionedDataSetMemberIdentifier [systemIp=" + this.systemIp + ", libraryName=" + this.libraryName + ", memberName=" + this.memberName + "]";
    }

    @Override
    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 4: {
                return this.systemIp;
            }
            case 5: {
                return this.libraryName;
            }
            case 3: {
                return this.memberName;
            }
        }
        return "";
    }

    @Override
    public List<ResourceData> getIdentifierData(EZSourceConnection conn) {
        String[][] queryResult;
        this.list.clear();
        String programQuery = RDZPartitionedDataSetMemberIdentifier.programAnalysisQuery(this.systemIp, this.libraryName, this.memberName, conn.getProjectInfo().getDbEngine());
        String[][] stringArray = queryResult = this.executeSQL(conn, programQuery);
        int n = queryResult.length;
        int n2 = 0;
        while (n2 < n) {
            String[] result = stringArray[n2];
            ProgramData resourceData = new ProgramData(result);
            this.list.add(resourceData);
            ++n2;
        }
        String jobQuery = RDZPartitionedDataSetMemberIdentifier.jobAnalysisQuery(this.systemIp, this.libraryName, this.memberName, conn.getProjectInfo().getDbEngine());
        String[][] stringArray2 = queryResult = this.executeSQL(conn, jobQuery);
        int n3 = queryResult.length;
        n = 0;
        while (n < n3) {
            String[] result = stringArray2[n];
            JobData resourceData = new JobData(result);
            this.list.add(resourceData);
            ++n;
        }
        String includeQuery = RDZPartitionedDataSetMemberIdentifier.includeAnalysisQuery(this.systemIp, this.libraryName, this.memberName, conn.getProjectInfo().getDbEngine());
        String[][] stringArray3 = queryResult = this.executeSQL(conn, includeQuery);
        int n4 = queryResult.length;
        n3 = 0;
        while (n3 < n4) {
            String[] result = stringArray3[n3];
            IncludeData resourceData = new IncludeData(result);
            this.list.add(resourceData);
            ++n3;
        }
        return this.list;
    }

    @Override
    public List<Pair<String, String>> getLabledFields() {
        ArrayList<Pair<String, String>> results = new ArrayList<Pair<String, String>>();
        results.add(new Pair((Object)this.systemIp, (Object)"label.text.systemName"));
        results.add(new Pair((Object)this.libraryName, (Object)"label.text.libraryName"));
        results.add(new Pair((Object)this.memberName, (Object)"label.text.memberName"));
        return results;
    }

    private static String programAnalysisQuery(String systemName, String libraryName, String memberName, ServerType dbServerType) {
        String query = "";
        switch (dbServerType) {
            case SqlServer: {
                query = String.format(programQuery, libraryName, memberName, systemName);
                break;
            }
            case Db2: 
            case Db2Z: {
                query = String.format(programQueryDB2, libraryName, memberName, systemName);
            }
        }
        return query;
    }

    private static String jobAnalysisQuery(String systemName, String libraryName, String memberName, ServerType dbServerType) {
        String query = "";
        switch (dbServerType) {
            case SqlServer: {
                query = String.format(jobQuery, libraryName, memberName, systemName);
                break;
            }
            case Db2: 
            case Db2Z: {
                query = String.format(jobQueryDB2, libraryName, memberName, systemName);
            }
        }
        return query;
    }

    private static String includeAnalysisQuery(String systemName, String libraryName, String memberName, ServerType dbServerType) {
        String query = "";
        switch (dbServerType) {
            case SqlServer: {
                query = String.format(includeQuery, libraryName, memberName, systemName);
                break;
            }
            case Db2: 
            case Db2Z: {
                query = String.format(includeQueryDB2, libraryName, memberName, systemName);
            }
        }
        return query;
    }
}

