/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis;

import com.ez.common.ui.listselection.Listable;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.rdz.resources.mainframe.analysis.IResourceIdentifier;
import com.ez.rdz.resources.mainframe.analysis.RDZMainframeAnalysisJob;
import com.ez.rdz.resources.mainframe.analysis.RDZSelectAnalysisPage;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ResourceData;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.workspace.gui.swt.utils.TreeObject;
import com.ez.workspace.utils.FileDataStore;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class RDZMainframeAnalysisWizard
extends PrepareReportWizard {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static final String FILE_DATA_STORE_PATH = "rdz" + File.separator + "rdzMainframeAnalysis.properties";
    protected static final String DATA_STORE_PROJECTS_PROPERTY = "rdzPrograms";
    protected static final String DATA_STORE_PROJECT_SELECTION_PREFIX = "rdzProjectSelection";
    public static final String SELECTED_APPLICATIONS_FOR_RDZ = "selected applications for rdz";
    public static final String AVAILABLE_APPLICATIONS_FOR_RDZ = "available applications for rdz";
    public static final String SELECTED_USED_FOR_RDZ = "selected projects for rdz";
    private RDZMainframeAnalysisJob rdzMainframeAnalysisJob;
    private Collection<IResourceIdentifier> rdzResourceIdentifiers;
    private RDZSelectAnalysisPage.TreeElementHandler treeElementHandler;
    private TreeObject<?> selectedObjectForAnalisys;
    private List<ProjectInfo> existingProjects;

    public RDZMainframeAnalysisWizard(RDZMainframeAnalysisJob rdzMainframeAnalysisJob, Collection<IResourceIdentifier> rdzResourceIdentifiers, List<ProjectInfo> existingProjects, RDZSelectAnalysisPage.TreeElementHandler treeElementHandler) {
        this.rdzMainframeAnalysisJob = rdzMainframeAnalysisJob;
        this.rdzResourceIdentifiers = rdzResourceIdentifiers;
        this.existingProjects = existingProjects;
        this.treeElementHandler = treeElementHandler;
    }

    public RDZMainframeAnalysisJob getRdzMainframeAnalysisJob() {
        return this.rdzMainframeAnalysisJob;
    }

    public boolean performCancel() {
        this.setSelectedObjectForAnalisys(null);
        return true;
    }

    public Collection<IResourceIdentifier> getRdzResourceIdentifiers() {
        return Collections.unmodifiableCollection(this.rdzResourceIdentifiers);
    }

    public List<ProjectInfo> getExistingProjects() {
        return Collections.unmodifiableList(this.existingProjects);
    }

    public List<ResourceData> getUsedProjects() {
        return this.getList(SELECTED_USED_FOR_RDZ);
    }

    public void setUsedProjects(List<ResourceData> list) {
        this.set(SELECTED_USED_FOR_RDZ, list);
    }

    public List<Listable> getSelectedProjects() {
        return this.getList(SELECTED_APPLICATIONS_FOR_RDZ);
    }

    public void setSelectedProjects(List<Listable> list) {
        this.set(SELECTED_APPLICATIONS_FOR_RDZ, list);
        this.updateFileDataStore();
    }

    public void updateFileDataStore() {
        List list = this.getList(SELECTED_APPLICATIONS_FOR_RDZ);
        HashSet<String> collection = new HashSet<String>();
        if (list != null) {
            for (Listable l : list) {
                collection.add(l.toString());
            }
            this.setSelectedProjectsFromDataStore(collection);
        }
    }

    public boolean cancelPressed() {
        this.selectedObjectForAnalisys = null;
        return super.cancelPressed();
    }

    public boolean canFinish() {
        return this.selectedObjectForAnalisys != null && !this.selectedObjectForAnalisys.isGroup();
    }

    public Collection<String> getSelectedProjectsFromDataStore() {
        ArrayList<String> projectsCollection = new ArrayList<String>();
        FileDataStore dataStore = FileDataStore.getDataStore((String)FILE_DATA_STORE_PATH);
        Properties properties = dataStore.getProperties(DATA_STORE_PROJECT_SELECTION_PREFIX);
        String projectsString = properties.getProperty(DATA_STORE_PROJECTS_PROPERTY);
        if (projectsString != null) {
            String[] projects;
            projectsString = projectsString.replaceAll("[\\[\\] ]", "");
            String[] stringArray = projects = projectsString.split(",");
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                String project = stringArray[n2];
                projectsCollection.add(project);
                ++n2;
            }
        }
        return projectsCollection;
    }

    private void setSelectedProjectsFromDataStore(Collection<?> selectedProjectCollection) {
        FileDataStore dataStore = FileDataStore.getDataStore((String)FILE_DATA_STORE_PATH);
        String selectedProjectString = selectedProjectCollection.toString();
        Properties properties = new Properties();
        properties.setProperty(DATA_STORE_PROJECTS_PROPERTY, selectedProjectString);
        dataStore.setProperties(properties, DATA_STORE_PROJECT_SELECTION_PREFIX);
    }

    public RDZSelectAnalysisPage.TreeElementHandler getTreeElementHandler() {
        return this.treeElementHandler;
    }

    public void setSelectedObjectForAnalisys(TreeObject<?> selectedObject) {
        this.selectedObjectForAnalisys = selectedObject;
    }

    public TreeObject<?> getSelectedObjectForAnalisys() {
        return this.selectedObjectForAnalisys;
    }
}

