/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.rdz.resources.mainframe.analysis.IResourceIdentifier;
import com.ez.rdz.resources.mainframe.analysis.RDZMainframeAnalysisWizard;
import com.ez.rdz.resources.mainframe.analysis.RDZPartitionedDataSetMemberIdentifier;
import com.ez.rdz.resources.mainframe.analysis.RDZSelectAnalysisPage;
import com.ez.rdz.resources.mainframe.analysis.RDZSelectProjectPage;
import com.ez.rdz.resources.mainframe.analysis.manager.MainframeAnalysisManager;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ResourceData;
import com.ez.rdz.utils.Messages;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.workspace.BridgeConfigurator;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.category.ICategory;
import com.ez.workspace.gui.swt.utils.TreeObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDZMainframeAnalysisJob
extends Job {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(RDZMainframeAnalysisJob.class);
    private final Collection<IResourceIdentifier> rdzResourceIdentifiers = new LinkedHashSet<IResourceIdentifier>();

    public RDZMainframeAnalysisJob(String name, String systemIp, String libraryName, String memberName) {
        super(name);
        this.rdzResourceIdentifiers.add(new RDZPartitionedDataSetMemberIdentifier(systemIp, libraryName, memberName));
        this.setUser(false);
    }

    public RDZMainframeAnalysisJob(String name, IResourceIdentifier ... rdzResourceIdentifiers) {
        super(name);
        if (rdzResourceIdentifiers == null) {
            throw new IllegalArgumentException("rdzResourceIdentifiers must not be null");
        }
        if (rdzResourceIdentifiers.length == 0) {
            throw new IllegalArgumentException("rdzResourceIdentifiers must have at least one element");
        }
        this.rdzResourceIdentifiers.addAll(Arrays.asList(rdzResourceIdentifiers));
        this.setUser(false);
    }

    public RDZMainframeAnalysisJob(String name, Collection<IResourceIdentifier> rdzResourceIdentifiers) {
        super(name);
        if (rdzResourceIdentifiers == null) {
            throw new IllegalArgumentException("rdzResourceIdentifiers must not be null");
        }
        if (rdzResourceIdentifiers.size() == 0) {
            throw new IllegalArgumentException("rdzResourceIdentifiers must have at least one element");
        }
        this.rdzResourceIdentifiers.addAll(rdzResourceIdentifiers);
        this.setUser(false);
    }

    public IStatus run(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (String)Messages.getString(((Object)((Object)this)).getClass(), "loadprojects.monitor.task"), (int)100);
        final List<ProjectInfo> projects = this.getProjects((IProgressMonitor)monitor.newChild(100));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                if (L.isDebugEnabled()) {
                    IResourceIdentifier rdzResourceIdentifier = (IResourceIdentifier)RDZMainframeAnalysisJob.this.rdzResourceIdentifiers.iterator().next();
                    L.debug("Start analysis for {}", (Object)rdzResourceIdentifier);
                }
                RDZMainframeAnalysisJob.this.runWizard(projects);
            }
        });
        t.start();
        return Status.OK_STATUS;
    }

    private List<ProjectInfo> getProjects(IProgressMonitor ponitor) {
        IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)ponitor, (int)100);
        List projects = service.getProjects();
        monitor.setWorkRemaining(0);
        ProjectInfo project = null;
        Iterator iterator = projects.iterator();
        while (iterator.hasNext()) {
            project = (ProjectInfo)iterator.next();
            if (!project.isEclipse()) continue;
            iterator.remove();
        }
        return Collections.unmodifiableList(projects);
    }

    private TreeObject<?> runWizard(List<ProjectInfo> projects) {
        MyTreeElementHandler treeElementHandler = this.getTreeElementHandler();
        final RDZMainframeAnalysisWizard rdzMainframeAnalysisWizard = new RDZMainframeAnalysisWizard(this, this.rdzResourceIdentifiers, projects, treeElementHandler);
        rdzMainframeAnalysisWizard.setWindowTitle(Messages.getString(RDZMainframeAnalysisJob.class, "wizard.title"));
        rdzMainframeAnalysisWizard.setNeedsProgressMonitor(true);
        RDZSelectProjectPage rdzSelectProjectPage = new RDZSelectProjectPage("RDZ mainframe project page", rdzMainframeAnalysisWizard);
        rdzMainframeAnalysisWizard.addPage((IWizardPage)rdzSelectProjectPage);
        RDZSelectAnalysisPage rdzSelectAnalysisPage = new RDZSelectAnalysisPage("RDZ mainframe analysis page", rdzMainframeAnalysisWizard);
        rdzMainframeAnalysisWizard.addPage((IWizardPage)rdzSelectAnalysisPage);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                BridgeConfigurator.init();
                try {
                    try {
                        Shell shell = Display.getDefault().getActiveShell();
                        ReportWizardDialog dialog = new ReportWizardDialog(shell, (IWizard)rdzMainframeAnalysisWizard);
                        dialog.create();
                        dialog.open();
                    }
                    catch (Exception e) {
                        L.error("while running wizard", (Throwable)e);
                        BridgeConfigurator.release();
                    }
                }
                finally {
                    BridgeConfigurator.release();
                }
            }
        });
        List<ResourceData> selection = rdzMainframeAnalysisWizard.getUsedProjects();
        TreeObject<?> treeObject = null;
        if (selection != null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("projects", projects);
            rdzMainframeAnalysisWizard.addPage((IWizardPage)rdzSelectAnalysisPage);
            ArrayList<ProjectInfo> selectedProjects = new ArrayList<ProjectInfo>();
            for (ResourceData sel : selection) {
                String name = sel.getProjectData().getProjectName();
                for (ProjectInfo project : projects) {
                    if (!project.getName().equals(name)) continue;
                    selectedProjects.add(project);
                }
            }
            properties.put("selection", selectedProjects);
            treeObject = rdzMainframeAnalysisWizard.getSelectedObjectForAnalisys();
            if (treeObject != null) {
                Map ezObjectTypeMap = treeElementHandler.ezObjectTypeMap;
                Object content = treeObject.getContent();
                if (content instanceof EZAnalysisType) {
                    MainframeAnalysisManager.runAnalysis((EZAnalysisType)content, ezObjectTypeMap, properties);
                }
            }
        }
        return treeObject;
    }

    private MyTreeElementHandler getTreeElementHandler() {
        MyTreeElementHandler treeElementHandler = new MyTreeElementHandler();
        return treeElementHandler;
    }

    private static class MyTreeElementHandler
    implements RDZSelectAnalysisPage.TreeElementHandler {
        private Map<ResourceData, EZObjectType> ezObjectTypeMap;

        private MyTreeElementHandler() {
        }

        @Override
        public Collection<TreeObject<?>> getTreeElements(List<ResourceData> resourceDataList) {
            ArrayList treeRootList = new ArrayList();
            if (resourceDataList.size() > 0) {
                ResourceData resourceData = resourceDataList.get(0);
                this.ezObjectTypeMap = MainframeAnalysisManager.createEZObjectTypes(resourceDataList);
                if (this.ezObjectTypeMap == null && this.ezObjectTypeMap.size() != 0) {
                    L.debug("No valid EZSourceProgram for resourceData={}", (Object)resourceData);
                    treeRootList.add(new TreeObject((Object)Messages.getString(this.getClass(), "noResource.tree.entry"), false));
                } else {
                    List<EZAnalysisType> analysisTypeList = MainframeAnalysisManager.getSpecificAnalysisTypes(this.ezObjectTypeMap);
                    if (analysisTypeList == null) {
                        L.debug("No validEZAnalysisType for resourceData={}", (Object)resourceData);
                    } else {
                        for (EZAnalysisType ezAnalysisType : analysisTypeList) {
                            ICategory category = MainframeAnalysisManager.getCategoryName(ezAnalysisType);
                            TreeObject treeObject = new TreeObject((Object)ezAnalysisType, ezAnalysisType.getIconDescriptor(), false);
                            if (category != null) {
                                TreeObject categoryTreeObject = new TreeObject((Object)category.getName(), category.getImageDescriptor(), true);
                                int index = treeRootList.indexOf(categoryTreeObject);
                                if (index >= 0) {
                                    categoryTreeObject = (TreeObject)treeRootList.get(index);
                                } else {
                                    treeRootList.add(categoryTreeObject);
                                }
                                categoryTreeObject.addChildren(treeObject);
                                continue;
                            }
                            treeRootList.add(treeObject);
                        }
                    }
                }
            }
            return treeRootList;
        }
    }
}

