/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.StringUtils;
import com.ez.rdz.resources.mainframe.analysis.AbstractResourceIdentifier;
import com.ez.rdz.resources.mainframe.analysis.manager.model.DataSetData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ResourceData;
import com.ez.rdz.utils.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RDZDataSetIdentifier
extends AbstractResourceIdentifier {
    private final String systemIp;
    private final String libraryName;
    private final String typeName;

    public RDZDataSetIdentifier(String systemIp, String libraryName, String typeName) {
        this.systemIp = systemIp;
        this.libraryName = libraryName;
        this.typeName = typeName;
    }

    @Override
    public int[] addTableColumns(Table programTable, boolean multiple) {
        TableColumn column = new TableColumn(programTable, 131072);
        column.setText(Messages.getString(RDZDataSetIdentifier.class, "table.column.name.availableAnalysis.ancestor"));
        column.setWidth(89);
        column.setAlignment(16384);
        if (multiple) {
            column = new TableColumn(programTable, 131072);
            column.setText(Messages.getString(RDZDataSetIdentifier.class, "table.column.name.availableAnalysis.memberName"));
            column.setWidth(110);
            column.setResizable(true);
            column.setAlignment(16384);
            column = new TableColumn(programTable, 131072);
            column.setText(Messages.getString(RDZDataSetIdentifier.class, "table.column.name.availableAnalysis.systemName"));
            column.setWidth(120);
            column.setResizable(true);
            column.setAlignment(16384);
            column = new TableColumn(programTable, 131072);
            column.setText(Messages.getString(RDZDataSetIdentifier.class, "table.column.name.availableAnalysis.libraryName"));
            column.setWidth(120);
            column.setResizable(true);
            column.setAlignment(16384);
            int[] nArray = new int[6];
            nArray[1] = 5;
            nArray[2] = 3;
            nArray[3] = 1;
            nArray[4] = 2;
            nArray[5] = 4;
            return nArray;
        }
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        return nArray;
    }

    @Override
    public List<Pair<String, String>> getLabledFields() {
        ArrayList<Pair<String, String>> results = new ArrayList<Pair<String, String>>();
        results.add(new Pair((Object)this.systemIp, (Object)"label.text.systemName"));
        results.add(new Pair((Object)this.libraryName, (Object)"label.text.libraryName"));
        return results;
    }

    @Override
    public List<ResourceData> getIdentifierData(EZSourceConnection conn) {
        String[][] queryResult;
        ArrayList<ResourceData> list = new ArrayList<ResourceData>();
        list.clear();
        String programQuery = String.format(RDZDataSetIdentifier.dataSetAnalysisQuery(), this.libraryName);
        String[][] stringArray = queryResult = this.executeSQL(conn, programQuery);
        int n = queryResult.length;
        int n2 = 0;
        while (n2 < n) {
            String[] result = stringArray[n2];
            DataSetData resourceData = new DataSetData(Integer.parseInt(result[0]), result[1], this.systemIp, StringUtils.parseInt((String)result[2]), this.typeName, result[3], result[4]);
            list.add(resourceData);
            ++n2;
        }
        return list;
    }

    private static String dataSetAnalysisQuery() {
        String programQuery = "SELECT \n\tT.DataSetID, \n\tT.DataSetName, \n\tT.GenerationNumber, \n\tT.MemberName, \n\tT.isLib \nFROM ( \n\tSELECT DISTINCT \n\t\tA.DataSetID, \n\t\tA.DataSetName, \n\t\tCASE \n\t\t\tWHEN A.IsGeneration = 1 THEN A.GenerationNumber \n\t\t\tELSE CAST(NULL AS INTEGER) \n\t\tEND AS GenerationNumber, \n\t\tB.MemberName, \n\t\tCASE \n\t\t\tWHEN C.DDName IN ('STEPLIB', 'JOBLIB', 'PROCLIB') THEN 1 \n\t\t\tELSE 0 \n\t\tEND AS isLib \n\tFROM JCLPhysicalDataSet A \n\t\tINNER JOIN JCLDDRef B ON A.DataSetID = B.DataSetID \n\t\tINNER JOIN JCLDD C ON B.DDID = C.DDID \n\tWHERE UPPER(A.DataSetName) = UPPER('%s') \n) AS T ";
        return programQuery;
    }

    @Override
    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 4: {
                return this.systemIp;
            }
            case 5: {
                return this.libraryName;
            }
        }
        return "";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.libraryName == null ? 0 : this.libraryName.hashCode());
        result = 31 * result + (this.systemIp == null ? 0 : this.systemIp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RDZDataSetIdentifier other = (RDZDataSetIdentifier)obj;
        if (this.libraryName == null ? other.libraryName != null : !this.libraryName.equals(other.libraryName)) {
            return false;
        }
        return !(this.systemIp == null ? other.systemIp != null : !this.systemIp.equals(other.systemIp));
    }

    public String toString() {
        return "RDZDataSetMemberIdentifier [systemIp=" + this.systemIp + ", libraryName=" + this.libraryName + "]";
    }
}

