/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.Pair;
import com.ez.rdz.resources.mainframe.analysis.AbstractResourceIdentifier;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ResourceData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.TransactionData;
import com.ez.rdz.utils.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CICSTransactionIdentifier
extends AbstractResourceIdentifier {
    private final String systemIp;
    private final String transactionName;
    private final String typeName;

    public CICSTransactionIdentifier(String systemIp, String transactionName, String typeName) {
        this.systemIp = systemIp;
        this.transactionName = transactionName;
        this.typeName = typeName;
    }

    @Override
    public int[] addTableColumns(Table programTable, boolean multiple) {
        if (multiple) {
            TableColumn column = new TableColumn(programTable, 131072);
            column.setText(Messages.getString(CICSTransactionIdentifier.class, "table.column.name.availableAnalysis.transactionName"));
            column.setWidth(130);
            column.setResizable(true);
            column.setAlignment(16384);
            int[] nArray = new int[3];
            nArray[1] = 2;
            nArray[2] = 1;
            return nArray;
        }
        int[] nArray = new int[2];
        nArray[1] = 1;
        return nArray;
    }

    @Override
    public List<ResourceData> getIdentifierData(EZSourceConnection conn) {
        String[][] queryResult;
        ArrayList<ResourceData> list = new ArrayList<ResourceData>();
        list.clear();
        String programQuery = String.format(CICSTransactionIdentifier.cicsTransactionQuery(), this.transactionName);
        String[][] stringArray = queryResult = this.executeSQL(conn, programQuery);
        int n = queryResult.length;
        int n2 = 0;
        while (n2 < n) {
            String[] result = stringArray[n2];
            TransactionData resourceData = new TransactionData(Integer.parseInt(result[0]), result[1], this.typeName, this.systemIp);
            list.add(resourceData);
            ++n2;
        }
        return list;
    }

    private static String cicsTransactionQuery() {
        String programQuery = "SELECT \n\tA.ResourceID, \n\tA.Name \nFROM Resources A \nWHERE A.ResourceType = 14 \n\tAND UPPER(A.Name) = UPPER('%s')";
        return programQuery;
    }

    @Override
    public List<Pair<String, String>> getLabledFields() {
        ArrayList<Pair<String, String>> results = new ArrayList<Pair<String, String>>();
        results.add(new Pair((Object)this.transactionName, (Object)"label.text.transactionName"));
        return results;
    }

    @Override
    public String getColumnText(int columnIndex) {
        if (columnIndex == 2) {
            return this.transactionName;
        }
        return "";
    }
}

