/*
 * Decompiled with CFR 0.152.
 */
package com.ez.rdz.resources.mainframe.analysis;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.Pair;
import com.ez.rdz.resources.mainframe.analysis.AbstractResourceIdentifier;
import com.ez.rdz.resources.mainframe.analysis.manager.model.CICSProgramData;
import com.ez.rdz.resources.mainframe.analysis.manager.model.ResourceData;
import com.ez.rdz.utils.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CICSProgramIdentifier
extends AbstractResourceIdentifier {
    private static final Logger L = LoggerFactory.getLogger(CICSProgramIdentifier.class);
    private final String name;

    public CICSProgramIdentifier(String prgName) {
        this.name = prgName;
    }

    @Override
    public int[] addTableColumns(Table programTable, boolean multiple) {
        if (multiple) {
            TableColumn column = new TableColumn(programTable, 16384);
            column.setText(Messages.getString(CICSProgramIdentifier.class, "table.column.name.availableAnalysis.programName"));
            column.setWidth(150);
            column.setResizable(true);
            column.setAlignment(16384);
            int[] nArray = new int[3];
            nArray[1] = 2;
            nArray[2] = 1;
            return nArray;
        }
        int[] nArray = new int[2];
        nArray[1] = 1;
        return nArray;
    }

    @Override
    public List<ResourceData> getIdentifierData(EZSourceConnection conn) {
        ArrayList<ResourceData> list = new ArrayList<ResourceData>();
        list.clear();
        String programQuery = String.format(CICSProgramIdentifier.cicsProgramQuery(), this.name, "%:".concat(this.name), this.name.concat(":%"));
        String[][] queryResult = this.executeSQL(conn, programQuery);
        int k = queryResult.length;
        if (k > 1) {
            L.warn("more than one program was identified by name {}", (Object)this.name);
        }
        String[][] stringArray = queryResult;
        int n = queryResult.length;
        int n2 = 0;
        while (n2 < n) {
            String[] result = stringArray[n2];
            CICSProgramData resourceData = new CICSProgramData(result);
            list.add(resourceData);
            ++n2;
        }
        return list;
    }

    private static String cicsProgramQuery() {
        String programQuery = "select Programs.ProgramID, ProgramAliases.AliasName, Ancestor, ProgramTypes.ProgramTypeID, ProgramTypes.ProgramType,  CAST(NULL AS VARCHAR(150)), Programs.OccurID, pth.PathStr\r\nfrom Programs \r\ninner join ProgramTypes on programs.ProgramTypeID = ProgramTypes.ProgramTypeID\r\nleft JOIN  Occurrences occ ON occ.Occurid = Programs.Occurid \r\ninner join ProgramAliases on ProgramAliases.ProgramId=Programs.ProgramID and ProgramAliases.AliasType = 0 \r\nLEFT OUTER JOIN Paths pth ON pth.PathID = occ.PathID\r\nwhere UPPER(ProgramAliases.AliasName) = UPPER('%s') or UPPER(ProgramAliases.AliasName) like UPPER('%s') or UPPER(ProgramAliases.AliasName) like UPPER('%s')";
        return programQuery;
    }

    @Override
    public List<Pair<String, String>> getLabledFields() {
        ArrayList<Pair<String, String>> results = new ArrayList<Pair<String, String>>();
        results.add(new Pair((Object)this.name, (Object)"label.text.programName"));
        return results;
    }

    @Override
    public String getColumnText(int columnIndex) {
        if (columnIndex == 2) {
            return this.name;
        }
        return "";
    }
}

