/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.search.srv;

import com.ez.analysis.mainframe.search.internal.Messages;
import com.ez.analysis.mainframe.search.project.MainframeSearchViewer;
import com.ez.analysis.mainframe.search.project.SearchItem;
import com.ez.analysis.mainframe.search.srv.IResultHandler;
import com.ez.analysis.mainframe.search.srv.ISearchService;
import com.ez.eclient.service.rsrv.search.SearchInFilesService;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import com.ibm.ad.oauth2.service.HTTPErrorHandler;
import com.ibm.ad.oauth2.service.SSOService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchService
implements ISearchService {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SearchService.class);

    @Override
    public void doQuery(String project, ISearchService.IQueryDescriptor qd, IResultHandler rHandler, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(MainframeSearchViewer.class, "search.in.project", new String[]{project}));
        L.debug("starting search in project {}", (Object)project);
        String endpoint = null;
        SearchInFilesService srv = (SearchInFilesService)ServiceUtils.getService(SearchInFilesService.class);
        monitor.worked(10);
        if (srv != null) {
            endpoint = srv.getEndpoint();
        }
        monitor.worked(10);
        if (endpoint == null) {
            L.warn("no endpoint found for SearchInFiles service");
            rHandler.onError(Messages.getString(SearchService.class, "serviceNotUsable.error"));
        } else {
            Pair<String, String> req = this.makeRequest(endpoint, project, qd, (IProgressMonitor)monitor.newChild(10));
            L.debug("request={}", req);
            if (req == null) {
                rHandler.onError(Messages.getString(SearchService.class, "searchRequest.error"));
            } else {
                try {
                    URL url = new URL((String)req.getFirst());
                    String reply = this.doRequest(url, (String)req.getSecond(), (IProgressMonitor)monitor.newChild(40));
                    if (reply != null) {
                        this.processResults(rHandler, reply, (IProgressMonitor)monitor.newChild(40));
                    } else {
                        L.info("no results for request={}", req);
                        rHandler.onResult(Messages.getString(MainframeSearchViewer.class, "no.results"));
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    rHandler.onError(Messages.getString(SearchService.class, "searchRequest.error"));
                }
            }
        }
        L.debug("done search in project {}", (Object)project);
        monitor.done();
    }

    private StringBuilder appendOptional(StringBuilder sb, String paramName, String paramValue) {
        if (paramValue != null && !paramValue.isEmpty()) {
            String val = null;
            try {
                val = URLEncoder.encode(paramValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                L.error("encoding {}", (Object)paramValue, (Object)e);
            }
            sb.append("&").append(paramName).append("=").append(val);
        }
        return sb;
    }

    private Pair<String, String> makeRequest(String endpoint, String project, ISearchService.IQueryDescriptor qd, IProgressMonitor pmonitor) {
        JsonArrayBuilder array;
        Set<String> pps;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        StringBuilder sb = new StringBuilder(endpoint);
        sb.append("?").append("pn=").append(project);
        this.appendOptional(sb, "fq", qd.getFileRegex());
        this.appendOptional(sb, "cq", qd.getContentRegex());
        this.appendOptional(sb, "ic", "" + qd.inComment());
        this.appendOptional(sb, "is", "" + qd.isCaseSensitive());
        this.appendOptional(sb, "ir", "" + qd.isRegularExpression());
        this.appendOptional(sb, "ip", "" + qd.isPrevious());
        monitor.worked(20);
        JsonObjectBuilder b = Json.createObjectBuilder();
        monitor.worked(20);
        if (qd.isPrevious() && (pps = qd.getPreviousPaths(project)) != null) {
            array = Json.createArrayBuilder();
            for (String pp : pps) {
                array.add(pp);
            }
            b.add("pp", (JsonValue)array.build());
        }
        Map<Integer, Boolean> eft = qd.getEnabledFileTypes();
        array = Json.createArrayBuilder();
        for (Integer k : eft.keySet()) {
            array.add(k + "," + eft.get(k));
        }
        b.add("ef", (JsonValue)array.build());
        monitor.worked(30);
        String url = sb.toString();
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = Json.createWriter((Writer)stringWriter);
        writer.writeObject(b.build());
        writer.close();
        String body = stringWriter.getBuffer().toString();
        monitor.done();
        return new Pair((Object)url, (Object)body);
    }

    private String doRequest(URL url, String info, IProgressMonitor pmonitor) {
        String ret;
        SubMonitor monitor;
        block6: {
            monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            ret = null;
            SSOService sso = (SSOService)ServiceUtils.getService(SSOService.class);
            if (sso != null) {
                HttpResponseConsumer consumer = new HttpResponseConsumer();
                try {
                    SearchResponseErrorHandler errHandler = new SearchResponseErrorHandler(url.toString());
                    String mth = info != null ? "POST" : "GET";
                    sso.request(url, mth, info, consumer, (HTTPErrorHandler)errHandler);
                    if (consumer.getHttpCode() != 200 || errHandler.hadException()) {
                        Exception e = errHandler.ex != null ? errHandler.ex : null;
                        String msg = Messages.getString(SearchService.class, "searchRequest.response.error", new String[]{String.valueOf(consumer.getHttpCode())});
                        LogUtil.displayErrorMessage((Status)new Status(4, "com.ez.analysis.mainframe.search", msg, (Throwable)e), (boolean)true);
                        break block6;
                    }
                    ret = consumer.getContent();
                }
                catch (Exception ex) {
                    Exception th = null;
                    if (sso.isAuthEnabled()) {
                        th = SearchService.printErrorDetails(url.toString(), consumer.getHttpCode(), null, ex.getMessage());
                    }
                    LogUtil.displayErrorMessage((Status)new Status(4, "com.ez.analysis.mainframe.search", Messages.getString(SearchService.class, "searchRequest.exception"), (Throwable)(th != null ? th : ex)), (boolean)true);
                    L.error("error getting results from search service", (Throwable)ex);
                }
            } else {
                L.error("cannot find SSOService!");
            }
        }
        monitor.done();
        return ret;
    }

    private void processResults(IResultHandler rHandler, String result, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        JsonReader reader = null;
        try {
            reader = Json.createReader((Reader)new StringReader(result));
            JsonObject root = reader.readObject();
            monitor.worked(50);
            root.getString("qid");
            root.getInt("page");
            root.getInt("next");
            JsonArray items = root.getJsonArray("items");
            if (items != null) {
                int i = 0;
                while (i < items.size()) {
                    SearchItem si = SearchItem.fromJSON(items.getJsonObject(i));
                    if (si != null) {
                        rHandler.onResult(si);
                    }
                    ++i;
                }
            }
            JsonObject sm = root.getJsonObject("summary");
            int files = sm.getInt("files");
            int occ = sm.getInt("occ");
            rHandler.onSummary(files, occ);
            monitor.worked(30);
        }
        catch (Exception e) {
            L.error("while parsing result", (Throwable)e);
            rHandler.onError(Messages.getString(SearchService.class, "searchResult.notReadable.error"));
        }
        monitor.done();
    }

    static Exception printErrorDetails(String url, int responseCode, InputStream content, String cont) {
        Exception ex = null;
        String contentString = null;
        if (content != null) {
            contentString = SearchService.readStreamAsString(content);
        } else if (cont != null) {
            contentString = cont;
        }
        if (contentString != null) {
            try {
                JsonReader reader = Json.createReader((Reader)new StringReader(contentString));
                JsonObject root = reader.readObject();
                Object err = null;
                JsonArray items = root.getJsonArray("items");
                if (items != null) {
                    err = ((JsonObject)items.get(0)).get((Object)"error");
                }
                L.error("request ({}) error={}", (Object)url, err);
                ex = new Exception(err.toString());
            }
            catch (Throwable th) {
                L.info("error printing details", th);
                String s = contentString != null ? contentString : cont;
                L.error("{} is the error content of request: {}", (Object)s, (Object)url);
                String msg = Messages.getString(SearchService.class, "searchRequest.errorParsing.exception", new String[]{url});
                ex = new Exception(msg, th);
            }
        } else {
            L.error("printing response details; error content is empty for request ({})", (Object)url);
        }
        return ex;
    }

    private static String readStreamAsString(InputStream input) {
        byte[] bucket = new byte[32768];
        ByteArrayOutputStream result = new ByteArrayOutputStream(bucket.length);
        try {
            try {
                int bytesRead = 0;
                while (bytesRead != -1) {
                    bytesRead = input.read(bucket);
                    if (bytesRead <= 0) continue;
                    result.write(bucket, 0, bytesRead);
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            L.warn("error reading stream", (Throwable)ex);
        }
        return result.toString();
    }

    class IndexData {
        String path;
        String error;

        IndexData() {
        }
    }

    class SearchResponseErrorHandler
    implements HTTPErrorHandler {
        Exception ex = null;
        String url = null;
        boolean treatExcept = false;

        public SearchResponseErrorHandler(String url) {
            this.url = url;
        }

        public boolean hadException() {
            return this.treatExcept;
        }

        public void execute(int responseCode, InputStream responseError) {
            L.debug("request error; response={}", (Object)responseCode);
            this.ex = SearchService.printErrorDetails(this.url, responseCode, responseError, null);
        }

        public void treatException(Exception e) {
            this.ex = e;
            this.treatExcept = true;
        }
    }
}

