/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.search.project;

import com.ez.internal.utils.Pair;
import com.ez.mainframe.editors.aauto.AAutoEditor;
import com.ez.mainframe.editors.adsd.ADSDEditor;
import com.ez.mainframe.editors.adsmap.ADSMapEditor;
import com.ez.mainframe.editors.adsp.ADSProcessEditor;
import com.ez.mainframe.editors.assembler.AssemblerEditor;
import com.ez.mainframe.editors.bms.BMSEditor;
import com.ez.mainframe.editors.cobol.CobolEditor;
import com.ez.mainframe.editors.ddcl.DDCLEditor;
import com.ez.mainframe.editors.jcl.JCLEditor;
import com.ez.mainframe.editors.natural.NaturalEditor;
import com.ez.mainframe.editors.naturalmap.NaturalMapEditor;
import com.ez.mainframe.editors.pl1.PL1Editor;
import com.ez.mainframe.editors.scl.SCLEditor;
import java.util.HashMap;

public class TypeConvertor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static String convertToEditorType(Pair<String, Boolean> dbTypeInfo) {
        String editorId = null;
        HashMap<Integer, String> fileMappings = new HashMap<Integer, String>(){
            {
                this.put(1, CobolEditor.COBOL_EDITOR_ID);
                this.put(3, BMSEditor.BMS_EDITOR_ID);
                this.put(5, JCLEditor.JCL_EDITOR_ID);
                this.put(17, PL1Editor.PL1_EDITOR_ID);
                this.put(19, NaturalEditor.NATURAL_EDITOR_ID);
                this.put(20, NaturalEditor.NATURAL_EDITOR_ID);
                this.put(21, NaturalMapEditor.NATURALMAP_EDITOR_ID);
                this.put(22, NaturalEditor.NATURAL_EDITOR_ID);
                this.put(28, JCLEditor.JCL_EDITOR_ID);
                this.put(46, JCLEditor.JCL_EDITOR_ID);
                this.put(47, JCLEditor.JCL_EDITOR_ID);
                this.put(48, JCLEditor.JCL_EDITOR_ID);
                this.put(49, AssemblerEditor.ASSEMBLER_EDITOR_ID);
                this.put(52, CobolEditor.COBOL_EDITOR_ID);
                this.put(53, CobolEditor.COBOL_EDITOR_ID);
                this.put(54, CobolEditor.COBOL_EDITOR_ID);
                this.put(55, CobolEditor.COBOL_EDITOR_ID);
                this.put(56, ADSProcessEditor.ADSP_EDITOR_ID);
                this.put(57, ADSDEditor.ADSD_EDITOR_ID);
                this.put(58, ADSMapEditor.ADSMAP_EDITOR_ID);
                this.put(66, AAutoEditor.AAUTO_EDITOR_ID);
                this.put(67, CobolEditor.COBOL_EDITOR_ID);
                this.put(68, SCLEditor.SCL_EDITOR_ID);
                this.put(69, DDCLEditor.DDCL_EDITOR_ID);
                this.put(70, CobolEditor.COBOL_EDITOR_ID);
                this.put(71, CobolEditor.COBOL_EDITOR_ID);
                this.put(72, CobolEditor.COBOL_EDITOR_ID);
            }
        };
        HashMap<Integer, String> folderMappings = new HashMap<Integer, String>(){
            {
                this.put(23, CobolEditor.COBOL_EDITOR_ID);
                this.put(24, PL1Editor.PL1_EDITOR_ID);
                this.put(28, NaturalEditor.NATURAL_EDITOR_ID);
                this.put(29, JCLEditor.JCL_EDITOR_ID);
                this.put(30, JCLEditor.JCL_EDITOR_ID);
                this.put(31, JCLEditor.JCL_EDITOR_ID);
                this.put(32, ADSProcessEditor.ADSP_EDITOR_ID);
                this.put(35, AssemblerEditor.ASSEMBLER_EDITOR_ID);
                this.put(36, AssemblerEditor.ASSEMBLER_EDITOR_ID);
                this.put(37, AssemblerEditor.ASSEMBLER_EDITOR_ID);
                this.put(58, CobolEditor.COBOL_EDITOR_ID);
            }
        };
        HashMap mapping = (Boolean)dbTypeInfo.getSecond() != false ? fileMappings : folderMappings;
        try {
            editorId = (String)mapping.get(Integer.parseInt((String)dbTypeInfo.getFirst()));
        }
        catch (NumberFormatException numberFormatException) {}
        return editorId;
    }

    public static Integer convertToProgramType(Pair<String, Boolean> typeInfo) {
        Integer programType = null;
        HashMap<Integer, Integer> programMappings = new HashMap<Integer, Integer>(){
            {
                this.put(1, 1);
                this.put(17, 2);
                this.put(19, 3);
                this.put(33, 7);
                this.put(49, 8);
                this.put(51, 9);
                this.put(52, 1);
                this.put(53, 1);
                this.put(54, 1);
                this.put(55, 1);
                this.put(56, 10);
                this.put(57, 11);
                this.put(67, 1);
                this.put(68, 13);
                this.put(69, 14);
                this.put(70, 1);
                this.put(71, 1);
                this.put(72, 1);
            }
        };
        if (((Boolean)typeInfo.getSecond()).booleanValue()) {
            try {
                programType = (Integer)programMappings.get(Integer.parseInt((String)typeInfo.getFirst()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return programType;
    }
}

