/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.search.project;

import com.ez.analysis.mainframe.search.internal.Messages;
import com.ez.analysis.mainframe.search.project.MainframeSearchViewer;
import com.ez.internal.utils.Pair;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchItem {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SearchItem.class);
    private int id;
    private String path;
    private List<List<OffsetInfo>> offsets;
    private String errMsg;
    private Pair<String, Boolean> dbType;
    private String term;

    public void setId(int id) {
        this.id = id;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void addOffsets(List<OffsetInfo[]> offsets) {
        if (this.offsets == null) {
            this.offsets = new ArrayList<List<OffsetInfo>>();
        }
        for (OffsetInfo[] arrayOff : offsets) {
            ArrayList<OffsetInfo> offsetsList = new ArrayList<OffsetInfo>();
            OffsetInfo[] offsetInfoArray = arrayOff;
            int n = arrayOff.length;
            int n2 = 0;
            while (n2 < n) {
                OffsetInfo off = offsetInfoArray[n2];
                offsetsList.add(off);
                ++n2;
            }
            this.offsets.add(offsetsList);
        }
    }

    public String getPath() {
        return this.path;
    }

    public List<List<OffsetInfo>> getOffsets() {
        return this.offsets;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String toDisplay() {
        return this.path != null ? String.valueOf(this.path) + " (" + this.offsets.size() + ")" : this.errMsg;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.path != null && !this.path.isEmpty()) {
            sb.append(this.id).append(this.path).append(": {");
        }
        if (this.offsets != null) {
            for (List<OffsetInfo> arrayOff : this.offsets) {
                for (OffsetInfo offset : arrayOff) {
                    sb.append("[").append(offset.start).append(",");
                    sb.append(offset.end).append("]");
                }
            }
        }
        if (sb.length() != 0) {
            sb.append("}");
        }
        return sb.toString();
    }

    public void setTypeInfo(String dbTypeId, String dbTypeIdForFile) {
        this.dbType = new Pair((Object)dbTypeId, (Object)Boolean.valueOf(dbTypeIdForFile));
    }

    public Pair<String, Boolean> getTypeInfo() {
        return this.dbType;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public String getTerm() {
        return this.term;
    }

    private static String getString(JsonObject data, String key) {
        JsonValue val = (JsonValue)data.get((Object)key);
        if (val.getValueType() != JsonValue.ValueType.NULL) {
            return ((JsonString)val).getString();
        }
        return null;
    }

    private static JsonString getJsonString(JsonObject data, String key) {
        JsonValue val = (JsonValue)data.get((Object)key);
        if (val.getValueType() != JsonValue.ValueType.NULL) {
            return (JsonString)val;
        }
        return null;
    }

    public static SearchItem fromJSON(JsonObject data) {
        SearchItem si = new SearchItem();
        try {
            si.id = data.getInt("id");
            si.errMsg = SearchItem.getString(data, "error");
            si.term = SearchItem.getString(data, "term");
            JsonString encodedPath = SearchItem.getJsonString(data, "path");
            if (encodedPath != null) {
                byte[] bytes = Base64.getDecoder().decode(encodedPath.getString());
                si.path = new String(bytes, Charset.defaultCharset());
            } else {
                si.path = null;
            }
            JsonArray outer = data.getJsonArray("offsets");
            if (outer != null) {
                int i = 0;
                while (i < outer.size()) {
                    JsonArray inner = outer.getJsonArray(i);
                    if (inner != null) {
                        ArrayList<OffsetInfo> ofsList = new ArrayList<OffsetInfo>();
                        int j = 0;
                        while (j < inner.size()) {
                            JsonObject ofs = inner.getJsonObject(j);
                            int start = ofs.getInt("start");
                            int end = ofs.getInt("end");
                            OffsetInfo oi = new OffsetInfo(start, end);
                            ofsList.add(oi);
                            ++j;
                        }
                        if (ofsList.size() > 0) {
                            if (si.offsets == null) {
                                si.offsets = new ArrayList<List<OffsetInfo>>();
                            }
                            si.offsets.add(ofsList);
                        }
                    }
                    ++i;
                }
            }
            if (si.errMsg == null) {
                JsonObject dbto = data.getJsonObject("dbType");
                if (dbto != null) {
                    String id = "" + dbto.getInt("id");
                    boolean fld = dbto.getBoolean("fld");
                    si.dbType = new Pair((Object)id, (Object)fld);
                }
            } else if ("no.results".equals(si.errMsg)) {
                si.errMsg = Messages.getString(MainframeSearchViewer.class, "no.results");
            }
        }
        catch (Exception e) {
            L.error("could not parse search item from json object", (Throwable)e);
            si = null;
        }
        return si;
    }

    public static class OffsetInfo {
        private int start;
        private int end;

        public OffsetInfo(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

