/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.search.project;

import com.ez.analysis.mainframe.search.project.SearchItem;
import com.ez.mainframe.model.ProjectInfo;
import java.util.ArrayList;
import java.util.List;

public class ResultProjectData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String projectName;
    private List<SearchItem> resultSearchItems;
    private int numberOfFiles = 0;
    private int occurrences = 0;
    private ProjectInfo projectInfo;

    public ResultProjectData(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
        this.projectName = projectInfo.getName();
    }

    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<SearchItem> getResultSearchItems() {
        return this.resultSearchItems;
    }

    public void addSearchItem(SearchItem searchItem) {
        if (this.resultSearchItems == null) {
            this.resultSearchItems = new ArrayList<SearchItem>();
        }
        this.resultSearchItems.add(searchItem);
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public void setNumberOfFiles(int numberOfFiles) {
        this.numberOfFiles = numberOfFiles;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public void setOccrrences(int occurrences) {
        this.occurrences = occurrences;
    }

    public String getDisplayText() {
        String displayText = this.projectName;
        if (this.numberOfFiles > 0) {
            displayText = String.valueOf(displayText) + " (" + this.numberOfFiles + ", " + this.occurrences + ")";
        }
        return displayText;
    }
}

