/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.search.project;

import com.ez.analysis.mainframe.search.Activator;
import com.ez.analysis.mainframe.search.internal.Messages;
import com.ez.analysis.mainframe.search.project.MainframeSearchDescriptor;
import com.ez.analysis.mainframe.search.project.ResultProjectData;
import com.ez.analysis.mainframe.search.project.SearchItem;
import com.ez.analysis.mainframe.search.project.TypeConvertor;
import com.ez.analysis.mainframe.search.srv.IResultHandler;
import com.ez.analysis.mainframe.search.srv.ISearchService;
import com.ez.analysis.mainframe.search.srv.SearchService;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.actions.IResultViewer;
import com.ez.analysisbrowser.views.BrowserManager;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.eclient.service.rsrv.fileservice.FileServerService;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.analysis.config.context.AnalysisBrowserContext;
import com.ez.internal.analysis.config.inputs.EZCobolSrcSelectionType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceInclude;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.ProjectsListWrapper;
import com.ez.mainframe.gui.rdz.HookUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.audit.IAudit;
import com.ez.workspace.analysis.graph.ExecExportStatus;
import com.ez.workspace.gotosource.IGoToSourceService;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZCobolSrcSelectionSg;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import com.ez.workspace.model.segments.EZSourceIncludeIDSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProgramTypeIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ibm.ad.oauth2.Utils;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import com.ibm.ad.oauth2.service.SSOService;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeSearchViewer
implements IResultViewer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeSearchViewer.class);
    private static final String SHOW_FILTERS_AREA_KEY = "show filters area";
    private static final String HIDE_FILTERS_AREA_TOOLTIP = Messages.getString(MainframeSearchViewer.class, "hide.filters.area.tooltip");
    private static final String SHOW_FILTERS_AREA_TOOLTIP = Messages.getString(MainframeSearchViewer.class, "show.filters.area.tooltip");
    private static final int MAXIM_PARALLEL_REQUEST = 5;
    private static final int space5px = 5;
    private MainframeSearchDescriptor descriptor;
    private IActionManager manager;
    private ImageRegistry imgRegistry;
    private Label filtersSummary = null;
    private ProjectsListWrapper availableProjectsList;
    private Map<String, ResultProjectData> resultsMap = new HashMap<String, ResultProjectData>();
    private static final Map<ResType, List<Pair<Integer, Boolean>>> fileTypesPerResType = MainframeSearchViewer.createFileTypesPerResTypeMap();
    private Set<ResType> selectedResTypes = new TreeSet<ResType>(new ResTypeComparator());
    private Text resultsLabel;
    private Button exportToCSVButton;
    private Label filesLabel;
    private Text occurrencesLabel;
    private TableColumnLayout tableColumnLayout = new TableColumnLayout();
    private org.eclipse.swt.widgets.List resultProjectsList;
    private String selectedResultProject = "";
    private boolean actionContextLoadedForProject = false;
    private org.eclipse.swt.widgets.List resultFileList;
    private int selectedResultFileIndex = -1;
    private boolean actionContextLoadedForFile = false;
    private TableViewer resultsTableViewer;
    private int selectedResultLineIndex = -1;
    private boolean actionContextLoadedForLine = false;
    private Text fileRegexText = null;
    private Text regexText = null;
    private Text fileTypeText;
    private Button checkPreviousButton;
    private Button checkCaseButton;
    private Button checkCommentsButton;
    private Button checkRegexButton;
    private final Map<String, Set<String>> previousResultsMap;
    private static final String RESULTS_MAP_KEY = "results map";
    private static final String PATTERN_KEY = "PATTERN_KEY";
    private static final String REGEX_KEY = "REGEX_KEY";
    private static final String ISREGEX_KEY = "ISREGEX_KEY";
    private static final String ISPREVIOUS_KEY = "ISPREVIOUS_KEY";
    private static final String ISSENSITIVE_KEY = "ISSENSITIVE_KEY";
    private static final String ISCOMMENT_KEY = "ISCOMMENT_KEY";
    private static final String SELECTED_FILE_TYPES_KEY = "SELECTED_FILE_TYPES_KEY";
    private static final String key = "descriptor_key";
    private static final String IMAGE_FILTER_COLLAPSED_KEY = "filtersCollapsed";
    private static final String IMAGE_FILTER_EXPANDED_KEY = "filtersExpanded";
    private static final String IMAGE_EXPORT_KEY = "exportImg";
    private static final String IMAGE_DISABLE_EXPORT_KEY = "disableExportImg";
    private static final String CONTEXT_STATE = "selectedContext";
    private static final String FILE_IS_SHARED_KEY = "ISFILESHARED";
    private SashForm resultsSashForm = null;
    private Integer totalOccurrences = 0;
    private Integer totalFiles = 0;
    private int noOfFinishedJobs = 0;
    private Map<Integer, JobGroup> jobGroups = new HashMap<Integer, JobGroup>();
    private boolean isSearchFinished = false;
    private long analysisStartTime = 0L;
    private Button searchButton;
    boolean needAuth = false;

    public MainframeSearchViewer(MainframeSearchDescriptor mainframeProjectStructureDescriptor) {
        this.descriptor = mainframeProjectStructureDescriptor;
        this.previousResultsMap = new HashMap<String, Set<String>>();
        this.needAuth = Utils.checkIdentity();
    }

    public Composite create(Composite parent, IAction action, IActionManager manager) {
        this.manager = manager;
        manager.setCurrentContext(null);
        this.initImageRegistry(manager);
        final Composite mainPanel = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        mainPanel.setLayout((Layout)formLayout);
        final Button toggleFiltersButton = new Button(mainPanel, 2);
        this.filtersSummary = new Label(mainPanel, 0);
        this.filtersSummary.setText(Messages.getString(MainframeSearchViewer.class, "filters.label"));
        final SashForm hSashMain = new SashForm(mainPanel, 512);
        Composite filtersMainArea = new Composite((Composite)hSashMain, 0);
        formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        filtersMainArea.setLayout((Layout)formLayout);
        filtersMainArea.computeSize(800, 400);
        final Composite resultsArea = new Composite((Composite)hSashMain, 2048);
        hSashMain.setWeights(new int[]{30, 60});
        toggleFiltersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainframeSearchViewer.this.showOrHideFiltersArea(toggleFiltersButton, hSashMain, resultsArea);
                mainPanel.layout();
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        toggleFiltersButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)toggleFiltersButton, 0, 0x1000000);
        formData.left = new FormAttachment((Control)toggleFiltersButton, 5);
        this.filtersSummary.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)toggleFiltersButton);
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        hSashMain.setLayoutData((Object)formData);
        Boolean showFiltersArea = (Boolean)this.descriptor.getState().getData().get(SHOW_FILTERS_AREA_KEY);
        toggleFiltersButton.setSelection(showFiltersArea != null ? showFiltersArea : true);
        this.showOrHideFiltersArea(toggleFiltersButton, hSashMain, resultsArea);
        this.completeFiltersMainArea(filtersMainArea);
        this.completeResultsArea(resultsArea);
        return mainPanel;
    }

    private void initImageRegistry(IActionManager manager) {
        if (this.imgRegistry == null) {
            this.imgRegistry = ((BrowserManager)manager).getImageRegistry();
        }
        if (this.imgRegistry.get(IMAGE_FILTER_COLLAPSED_KEY) == null) {
            this.imgRegistry.put(IMAGE_FILTER_COLLAPSED_KEY, Activator.getImageDescriptor("icons/collapsed_16.png"));
        }
        if (this.imgRegistry.get(IMAGE_FILTER_EXPANDED_KEY) == null) {
            this.imgRegistry.put(IMAGE_FILTER_EXPANDED_KEY, Activator.getImageDescriptor("icons/expanded_16.png"));
        }
        if (this.imgRegistry.get(IMAGE_EXPORT_KEY) == null) {
            this.imgRegistry.put(IMAGE_EXPORT_KEY, Activator.getImageDescriptor("icons/Export_16x16.gif"));
        }
        if (this.imgRegistry.get(IMAGE_DISABLE_EXPORT_KEY) == null) {
            this.imgRegistry.put(IMAGE_DISABLE_EXPORT_KEY, Activator.getImageDescriptor("icons/disableExport_16x16.gif"));
        }
    }

    private void showOrHideFiltersArea(Button toggleFiltersButton, SashForm hSashMain, Composite resultsArea) {
        if (toggleFiltersButton.getSelection()) {
            hSashMain.setMaximizedControl(null);
            toggleFiltersButton.setImage(this.imgRegistry.get(IMAGE_FILTER_EXPANDED_KEY));
            toggleFiltersButton.setToolTipText(HIDE_FILTERS_AREA_TOOLTIP);
            this.descriptor.getState().getData().put(SHOW_FILTERS_AREA_KEY, true);
        } else {
            hSashMain.setMaximizedControl((Control)resultsArea);
            toggleFiltersButton.setImage(this.imgRegistry.get(IMAGE_FILTER_COLLAPSED_KEY));
            toggleFiltersButton.setToolTipText(SHOW_FILTERS_AREA_TOOLTIP);
            this.descriptor.getState().getData().put(SHOW_FILTERS_AREA_KEY, false);
        }
    }

    private void completeFiltersMainArea(Composite filtersMainArea) {
        SashForm vSashFiltersArea = new SashForm(filtersMainArea, 256);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.height = 400;
        vSashFiltersArea.setLayoutData((Object)formData);
        Composite leftFiltersArea = new Composite((Composite)vSashFiltersArea, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        leftFiltersArea.setLayout((Layout)formLayout);
        Composite rightFiltersArea = new Composite((Composite)vSashFiltersArea, 0);
        formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        rightFiltersArea.setLayout((Layout)formLayout);
        vSashFiltersArea.setWeights(new int[]{70, 30});
        this.createLeftFilterArea(leftFiltersArea);
        this.createProjectsArea(rightFiltersArea);
    }

    private void createLeftFilterArea(Composite leftFiltersArea) {
        Group filtersGroup = new Group(leftFiltersArea, 0);
        filtersGroup.setText(Messages.getString(MainframeSearchViewer.class, "searchOptions.lbl"));
        this.searchButton = new Button(leftFiltersArea, 0);
        this.searchButton.setText(Messages.getString(MainframeSearchViewer.class, "search.lbl"));
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        filtersGroup.setLayout((Layout)formLayout);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment((Control)this.searchButton, -5);
        formData.right = new FormAttachment(100, -5);
        filtersGroup.setLayoutData((Object)formData);
        Label regexLabel = new Label((Composite)filtersGroup, 0);
        regexLabel.setText(Messages.getString(MainframeSearchViewer.class, "pattern.lbl"));
        this.regexText = new Text((Composite)filtersGroup, 2048);
        this.regexText.setToolTipText(Messages.getString(MainframeSearchViewer.class, "use.reg.expr.pattern.lbl"));
        this.regexText.setData(key, (Object)REGEX_KEY);
        ModifyListener modifylistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                MainframeSearchViewer.this.descriptor.getState().getData().put((String)text.getData(MainframeSearchViewer.key), text.getText());
                if (MainframeSearchViewer.REGEX_KEY.equals((String)text.getData(MainframeSearchViewer.key))) {
                    MainframeSearchViewer.this.searchButton.setEnabled(!text.getText().trim().isEmpty());
                }
            }
        };
        this.regexText.addModifyListener(modifylistener);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.regexText, 0, 0x1000000);
        formData.left = new FormAttachment(0, 5);
        regexLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)regexLabel, 5);
        formData.right = new FormAttachment(77, 5);
        this.regexText.setLayoutData((Object)formData);
        Label fileLabel = new Label((Composite)filtersGroup, 0);
        fileLabel.setText(Messages.getString(MainframeSearchViewer.class, "restrict.res"));
        this.fileRegexText = new Text((Composite)filtersGroup, 2048);
        this.fileRegexText.setToolTipText(Messages.getString(MainframeSearchViewer.class, "use.reg.expr.lbl"));
        this.fileRegexText.setData(key, (Object)PATTERN_KEY);
        this.fileRegexText.addModifyListener(modifylistener);
        this.fileTypeText = new Text((Composite)filtersGroup, 2048);
        this.fileTypeText.setToolTipText(Messages.getString(MainframeSearchViewer.class, "use.type.file.lbl"));
        this.fileTypeText.setEditable(false);
        Label fileTypeLabel = new Label((Composite)filtersGroup, 0);
        fileTypeLabel.setText(Messages.getString(MainframeSearchViewer.class, "fileTypeLabel.lbl"));
        Button fileTypesButton = new Button((Composite)filtersGroup, 0);
        fileTypesButton.setText(Messages.getString(MainframeSearchViewer.class, "fileType.lbl"));
        fileTypesButton.setToolTipText(Messages.getString(MainframeSearchViewer.class, "select.type.file.lbl"));
        fileTypesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileTypeDialog dialogType = new FileTypeDialog(Display.getDefault().getActiveShell());
                dialogType.open();
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.fileTypeText, 0, 0x1000000);
        formData.left = new FormAttachment(0, 5);
        fileTypeLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.fileRegexText, 5);
        formData.left = new FormAttachment((Control)fileTypeLabel);
        formData.right = new FormAttachment((Control)fileTypesButton, -5);
        this.fileTypeText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.fileRegexText, 5);
        formData.right = new FormAttachment(77, 5);
        fileTypesButton.setLayoutData((Object)formData);
        if (this.descriptor.getState().getData().get(SELECTED_FILE_TYPES_KEY) == null) {
            StringBuilder sBuilder = new StringBuilder();
            this.selectedResTypes.addAll(fileTypesPerResType.keySet());
            this.descriptor.getState().getData().put(SELECTED_FILE_TYPES_KEY, this.selectedResTypes);
            for (ResType resType : this.selectedResTypes) {
                if (sBuilder.length() > 0) {
                    sBuilder.append(", ");
                }
                sBuilder.append(resType.getLabel());
            }
            this.fileTypeText.setText(sBuilder.toString());
        }
        Label checkCaseLabel = new Label((Composite)filtersGroup, 0);
        checkCaseLabel.setText(Messages.getString(MainframeSearchViewer.class, "checkCaseLabel.lbl"));
        this.checkCaseButton = new Button((Composite)filtersGroup, 32);
        this.checkCaseButton.setToolTipText(Messages.getString(MainframeSearchViewer.class, "checkCaseLabel.lbl"));
        SelectionAdapter checkListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.getSource();
                MainframeSearchViewer.this.descriptor.getState().getData().put((String)button.getData(MainframeSearchViewer.key), button.getSelection());
            }
        };
        this.checkCaseButton.setData(key, (Object)ISSENSITIVE_KEY);
        this.checkCaseButton.addSelectionListener((SelectionListener)checkListener);
        Label checkRegexLabel = new Label((Composite)filtersGroup, 0);
        checkRegexLabel.setText(Messages.getString(MainframeSearchViewer.class, "checkRegexLabel.lbl"));
        this.checkRegexButton = new Button((Composite)filtersGroup, 32);
        this.checkRegexButton.setToolTipText(Messages.getString(MainframeSearchViewer.class, "checkRegexLabel.lbl"));
        this.checkRegexButton.setData(key, (Object)ISREGEX_KEY);
        this.checkRegexButton.addSelectionListener((SelectionListener)checkListener);
        Label checkCommentsLabel = new Label((Composite)filtersGroup, 0);
        checkCommentsLabel.setText(Messages.getString(MainframeSearchViewer.class, "checkCommentsLabel.lbl"));
        this.checkCommentsButton = new Button((Composite)filtersGroup, 32);
        this.checkCommentsButton.setToolTipText(Messages.getString(MainframeSearchViewer.class, "checkCommentsLabel.lbl"));
        this.checkCommentsButton.setData(key, (Object)ISCOMMENT_KEY);
        this.checkCommentsButton.addSelectionListener((SelectionListener)checkListener);
        Label checkPreviousLabel = new Label((Composite)filtersGroup, 0);
        checkPreviousLabel.setText(Messages.getString(MainframeSearchViewer.class, "checkPreviousLabel.lbl"));
        this.checkPreviousButton = new Button((Composite)filtersGroup, 32);
        this.checkPreviousButton.setToolTipText(Messages.getString(MainframeSearchViewer.class, "checkPreviousLabel.lbl"));
        this.checkPreviousButton.setData(key, (Object)ISPREVIOUS_KEY);
        this.checkPreviousButton.addSelectionListener((SelectionListener)checkListener);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)this.checkCaseButton, 5);
        checkCaseLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)this.regexText, 5);
        this.checkCaseButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)checkCaseLabel, 5);
        formData.left = new FormAttachment((Control)this.fileRegexText, 5);
        this.checkRegexButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)checkCaseLabel, 5);
        formData.left = new FormAttachment((Control)this.checkRegexButton, 5);
        formData.right = new FormAttachment(100, -5);
        checkRegexLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.checkRegexButton, 5);
        formData.left = new FormAttachment((Control)this.fileRegexText, 5);
        this.checkCommentsButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.checkRegexButton, 5);
        formData.left = new FormAttachment((Control)this.checkCommentsButton, 5);
        formData.right = new FormAttachment(100, -5);
        checkCommentsLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)checkCommentsLabel, 5);
        formData.left = new FormAttachment((Control)this.fileRegexText, 5);
        this.checkPreviousButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)checkCommentsLabel, 5);
        formData.left = new FormAttachment((Control)this.checkPreviousButton, 5);
        formData.right = new FormAttachment(100, -5);
        checkPreviousLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.fileRegexText, 0, 0x1000000);
        formData.left = new FormAttachment(0, 5);
        fileLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.regexText, 5);
        formData.left = new FormAttachment((Control)fileLabel, 5);
        formData.right = new FormAttachment(77, 5);
        this.fileRegexText.setLayoutData((Object)formData);
        this.regexText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 13) {
                    MainframeSearchViewer.this.enableInput(false);
                    MainframeSearchViewer.this.doQuery(MainframeSearchViewer.this.manager);
                }
            }
        });
        this.fileRegexText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 13) {
                    MainframeSearchViewer.this.enableInput(false);
                    MainframeSearchViewer.this.doQuery(MainframeSearchViewer.this.manager);
                }
            }
        });
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainframeSearchViewer.this.enableInput(false);
                if (!MainframeSearchViewer.this.checkPreviousButton.getSelection()) {
                    MainframeSearchViewer.this.previousResultsMap.clear();
                }
                MainframeSearchViewer.this.doQuery(MainframeSearchViewer.this.manager);
            }
        });
        formData = new FormData();
        formData.bottom = new FormAttachment(100, -5);
        formData.right = new FormAttachment(100, -5);
        this.searchButton.setLayoutData((Object)formData);
        this.searchButton.setEnabled(!this.regexText.getText().trim().isEmpty());
        this.loadFiltersDataFromContext();
    }

    private void enableInput(boolean enabled) {
        this.searchButton.setEnabled(enabled);
        this.fileRegexText.setEnabled(enabled);
        this.regexText.setEnabled(enabled);
    }

    private void createProjectsArea(Composite rightFiltersArea) {
        Group projectsGroup = new Group(rightFiltersArea, 0);
        projectsGroup.setText(Messages.getString(MainframeSearchViewer.class, "projects.label.text"));
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        projectsGroup.setLayout((Layout)formLayout);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        projectsGroup.setLayoutData((Object)formData);
        this.availableProjectsList = new ProjectsListWrapper(projectsGroup, 2562);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        this.availableProjectsList.getList().setLayoutData((Object)formData);
        this.availableProjectsList.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainframeSearchViewer.this.updateSelectedProjectsList();
            }
        });
        this.loadProjectsListFromContext();
    }

    private void completeResultsArea(final Composite resultsArea) {
        FormLayout formLayout = new FormLayout();
        resultsArea.setLayout((Layout)formLayout);
        this.resultsLabel = new Text(resultsArea, 8);
        this.resultsLabel.setText(Messages.getString(MainframeSearchViewer.class, "results.label.text"));
        this.exportToCSVButton = new Button(resultsArea, 8);
        this.exportToCSVButton.setEnabled(false);
        this.exportToCSVButton.setImage(this.imgRegistry.get(IMAGE_DISABLE_EXPORT_KEY));
        this.exportToCSVButton.setToolTipText(Messages.getString(MainframeSearchViewer.class, "export.csv.tooltip"));
        this.exportToCSVButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(MainframeSearchViewer.class, "export.csv.tooltip");
            }
        });
        this.exportToCSVButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog exportFileDialog = new FileDialog(resultsArea.getShell(), 8192);
                exportFileDialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                exportFileDialog.setFilterNames(new String[]{Messages.getString(MainframeSearchViewer.class, "file.csv.label", new String[]{"(*.csv)"}), Messages.getString(MainframeSearchViewer.class, "file.all.label", new String[]{"(*.*)"})});
                exportFileDialog.setOverwrite(true);
                final String fileNamePath = exportFileDialog.open();
                if (fileNamePath != null) {
                    Job exportJob = new Job(Messages.getString(MainframeSearchViewer.class, "export.csv.job.name")){

                        protected IStatus run(IProgressMonitor monitor) {
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            subMonitor.setTaskName(Messages.getString(MainframeSearchViewer.class, "export.csv.exportTask.name"));
                            MainframeSearchViewer.this.exportResultsToCSV((IProgressMonitor)subMonitor.newChild(100), fileNamePath);
                            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                        }
                    };
                    exportJob.setUser(true);
                    exportJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            IStatus status;
                            if (fileNamePath != null && (status = event.getResult()) == Status.OK_STATUS) {
                                ExecExportStatus ees = new ExecExportStatus();
                                ees.exportStatus = true;
                                ees.exportFile = fileNamePath;
                                Display.getDefault().syncExec((Runnable)ees);
                            }
                        }
                    });
                    exportJob.schedule();
                }
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.exportToCSVButton, 0, 0x1000000);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment((Control)this.exportToCSVButton, -5);
        this.resultsLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        this.exportToCSVButton.setLayoutData((Object)formData);
        this.resultsSashForm = new SashForm(resultsArea, 256);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.exportToCSVButton, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        this.resultsSashForm.setLayoutData((Object)formData);
        Composite projectsComposite = new Composite((Composite)this.resultsSashForm, 0);
        formLayout = new FormLayout();
        projectsComposite.setLayout((Layout)formLayout);
        Composite filesComposite = new Composite((Composite)this.resultsSashForm, 0);
        formLayout = new FormLayout();
        filesComposite.setLayout((Layout)formLayout);
        Composite occurrencesComposite = new Composite((Composite)this.resultsSashForm, 0);
        formLayout = new FormLayout();
        occurrencesComposite.setLayout((Layout)formLayout);
        this.resultsSashForm.setWeights(new int[]{25, 25, 50});
        Label projectsLabel = new Label(projectsComposite, 0);
        projectsLabel.setText(Messages.getString(MainframeSearchViewer.class, "projects.label.text"));
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        projectsLabel.setLayoutData((Object)formData);
        this.filesLabel = new Label(filesComposite, 0);
        this.filesLabel.setText(Messages.getString(MainframeSearchViewer.class, "files.label.text"));
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        this.filesLabel.setLayoutData((Object)formData);
        this.occurrencesLabel = new Text(occurrencesComposite, 8);
        this.occurrencesLabel.setText(Messages.getString(MainframeSearchViewer.class, "occurrences.label.text"));
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        this.occurrencesLabel.setLayoutData((Object)formData);
        this.resultProjectsList = new org.eclipse.swt.widgets.List(projectsComposite, 2816);
        this.resultProjectsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = MainframeSearchViewer.this.resultProjectsList.getSelectionIndex();
                if (selIndex > -1) {
                    String prjDisplayText = MainframeSearchViewer.this.resultProjectsList.getItem(selIndex);
                    String projectName = (String)MainframeSearchViewer.this.resultProjectsList.getData(prjDisplayText);
                    MainframeSearchViewer.this.handleResultProjectSelection(projectName);
                }
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment((Control)projectsLabel, 5);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        this.resultProjectsList.setLayoutData((Object)formData);
        this.resultFileList = new org.eclipse.swt.widgets.List(filesComposite, 2816);
        this.resultFileList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = MainframeSearchViewer.this.resultFileList.getSelectionIndex();
                if (selIndex > -1) {
                    String prjDisplayText = MainframeSearchViewer.this.resultProjectsList.getSelection()[0];
                    String projectName = (String)MainframeSearchViewer.this.resultProjectsList.getData(prjDisplayText);
                    MainframeSearchViewer.this.handleResultFileSelection(selIndex, projectName, true);
                }
            }
        });
        this.resultFileList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MainframeSearchViewer.this.handleGoToSourceDoubleClick();
            }
        });
        this.resultFileList.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    MainframeSearchViewer.this.handleGoToSourceDoubleClick();
                }
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.filesLabel, 5);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        this.resultFileList.setLayoutData((Object)formData);
        this.createResultLinesTable(occurrencesComposite);
        this.loadResultsFromContext();
    }

    private void createResultLinesTable(Composite occurrencesComposite) {
        final Font font = JFaceResources.getTextFont();
        final Font boldFont = FontDescriptor.createFrom((Font)font).setStyle(1).createFont((Device)Display.getCurrent());
        occurrencesComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                boldFont.dispose();
            }
        });
        Composite tableComposite = new Composite(occurrencesComposite, 0);
        tableComposite.setLayout((Layout)this.tableColumnLayout);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.occurrencesLabel, 5);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        tableComposite.setLayoutData((Object)formData);
        this.resultsTableViewer = new TableViewer(tableComposite, 0x10010B00);
        this.resultsTableViewer.getTable().setLinesVisible(true);
        this.resultsTableViewer.getTable().setHeaderVisible(true);
        this.resultsTableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MainframeSearchViewer.this.handleGoToSourceDoubleClick();
            }
        });
        this.resultsTableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainframeSearchViewer.this.handleResultLineSelection();
            }
        });
        this.resultsTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn firstViewerColumn = new TableViewerColumn(this.resultsTableViewer, 131072);
        firstViewerColumn.getColumn().setText(Messages.getString(MainframeSearchViewer.class, "column.header.line"));
        firstViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String lineNumber = "";
                if (element instanceof LineInfo) {
                    lineNumber = "" + ((LineInfo)element).lineNo;
                }
                return lineNumber;
            }
        });
        this.tableColumnLayout.setColumnData((Widget)firstViewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(10));
        TableViewerColumn secondColumn = new TableViewerColumn(this.resultsTableViewer, 16384);
        secondColumn.getColumn().setText(Messages.getString(MainframeSearchViewer.class, "column.header.text"));
        secondColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Object rowData = cell.getElement();
                if (rowData instanceof LineInfo) {
                    LineInfo li = (LineInfo)rowData;
                    cell.setText(li.lineText);
                    cell.setFont(font);
                    if (li.offsetInfo != null) {
                        StyleRange[] boldStyledRange = new StyleRange[li.offsetInfo.size()];
                        int i = 0;
                        for (OffAndLen ol : li.offsetInfo) {
                            boldStyledRange[i] = new StyleRange(ol.offset, ol.len, null, null);
                            boldStyledRange[i].font = boldFont;
                            ++i;
                        }
                        cell.setStyleRanges(boldStyledRange);
                    }
                    cell.getBounds().width = 200;
                    super.update(cell);
                } else if (((List)rowData).size() > 0) {
                    cell.setText((String)((List)rowData).get(0));
                }
            }
        });
        this.tableColumnLayout.setColumnData((Widget)secondColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(90));
    }

    private void loadFiltersDataFromContext() {
        Map data = this.descriptor.getState().getData();
        if (this.regexText != null && data.get(REGEX_KEY) != null) {
            this.regexText.setText((String)data.get(REGEX_KEY));
        }
        if (this.fileRegexText != null && data.get(PATTERN_KEY) != null) {
            this.fileRegexText.setText((String)data.get(PATTERN_KEY));
        }
        if (this.fileTypeText != null && data.get(SELECTED_FILE_TYPES_KEY) != null) {
            this.selectedResTypes = (Set)data.get(SELECTED_FILE_TYPES_KEY);
            StringBuilder sBuilder = new StringBuilder();
            for (ResType resType : this.selectedResTypes) {
                if (sBuilder.length() > 0) {
                    sBuilder.append(", ");
                }
                sBuilder.append(resType.getLabel());
            }
            this.fileTypeText.setText(sBuilder.toString());
        }
        if (this.checkRegexButton != null && data.get(ISREGEX_KEY) != null) {
            this.checkRegexButton.setSelection(((Boolean)data.get(ISREGEX_KEY)).booleanValue());
        }
        if (this.checkCommentsButton != null && data.get(ISCOMMENT_KEY) != null) {
            this.checkCommentsButton.setSelection(((Boolean)data.get(ISCOMMENT_KEY)).booleanValue());
        }
        if (this.checkPreviousButton != null && data.get(ISPREVIOUS_KEY) != null) {
            this.checkPreviousButton.setSelection(((Boolean)data.get(ISPREVIOUS_KEY)).booleanValue());
        }
        if (this.checkCaseButton != null && data.get(ISSENSITIVE_KEY) != null) {
            this.checkCaseButton.setSelection(((Boolean)data.get(ISSENSITIVE_KEY)).booleanValue());
        }
    }

    private void loadProjectsListFromContext() {
        Map data = this.descriptor.getState().getData();
        List selInputProjects = (List)data.get("PROJECT_LIST");
        List allProjects = (List)data.get("projects");
        List filteredProjects = com.ez.mainframe.gui.utils.Utils.filterProjects((List)allProjects, (EZAnalysisType)this.descriptor.getAnalysisType());
        this.availableProjectsList.fill(filteredProjects, selInputProjects);
        this.updateSelectedProjectsList();
    }

    private void updateSelectedProjectsList() {
        Map data = this.descriptor.getState().getData();
        ArrayList<ProjectInfo> selectedProjectsList = (ArrayList<ProjectInfo>)data.get("PROJECT_LIST");
        if (selectedProjectsList == null) {
            selectedProjectsList = new ArrayList<ProjectInfo>();
            data.put("PROJECT_LIST", selectedProjectsList);
        }
        selectedProjectsList.clear();
        int[] nArray = this.availableProjectsList.getList().getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            selectedProjectsList.add((ProjectInfo)this.availableProjectsList.getList().getData(String.valueOf(index)));
            ++n2;
        }
    }

    private void loadResultsFromContext() {
        Map data = this.descriptor.getState().getData();
        if (data.get(RESULTS_MAP_KEY) != null) {
            this.resultsMap = (Map)data.get(RESULTS_MAP_KEY);
            for (String projectName : this.resultsMap.keySet()) {
                this.displayResultProjectWithSummary(projectName);
            }
        }
    }

    private void doQuery(IActionManager actionManager) {
        L.debug("starting search");
        this.clearResults();
        ArrayList<ProjectInfo> currentSelectedProjects = new ArrayList<ProjectInfo>();
        int[] nArray = this.availableProjectsList.getList().getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            currentSelectedProjects.add((ProjectInfo)this.availableProjectsList.getList().getData(String.valueOf(index)));
            ++n2;
        }
        final int selectedProjectsCount = currentSelectedProjects.size();
        this.analysisStartTime = System.currentTimeMillis();
        L.info("{} - start time: {}", (Object)this.descriptor.getAnalysisType().toString(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        this.noOfFinishedJobs = 0;
        this.isSearchFinished = false;
        final SearchService ss = new SearchService();
        final QueryDescriptor qd = new QueryDescriptor(this.descriptor);
        if (this.descriptor.getAction().isAuditable()) {
            ((IAudit)this.descriptor.getAction()).auditAnalysis();
        }
        int idx = 0;
        for (final ProjectInfo projectInfo : currentSelectedProjects) {
            Job j = new Job(Messages.getString(MainframeSearchViewer.class, "search.in.project", new String[]{projectInfo.getName()})){

                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor childMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ResultAdder ra = new ResultAdder(projectInfo);
                    childMonitor.worked(20);
                    String projectName = projectInfo.getName();
                    ss.doQuery(projectName, qd, ra, (IProgressMonitor)childMonitor.newChild(60));
                    ResultProjectData resultPrjData = (ResultProjectData)MainframeSearchViewer.this.resultsMap.get(projectName);
                    List<SearchItem> resultsList = resultPrjData.getResultSearchItems();
                    MainframeSearchViewer.this.previousResultsMap.remove(projectName);
                    HashSet<String> currentResultsMap = new HashSet<String>();
                    int i = 0;
                    while (i < resultsList.size()) {
                        if (resultsList.get(i).getPath() != null) {
                            currentResultsMap.add(resultsList.get(i).getPath());
                        }
                        ++i;
                    }
                    MainframeSearchViewer.this.previousResultsMap.put(projectName, currentResultsMap);
                    MainframeSearchViewer.this.displayResultProjectWithSummary(projectName);
                    childMonitor.worked(10);
                    MainframeSearchViewer.this.incFinishedJobs();
                    if (MainframeSearchViewer.this.noOfFinishedJobs == selectedProjectsCount) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MainframeSearchViewer.this.forceFirstPrjSelection();
                            }
                        });
                        long analysisDuration = System.currentTimeMillis() - MainframeSearchViewer.this.analysisStartTime;
                        L.info("{} - search duration: {} ms.", (Object)MainframeSearchViewer.this.descriptor.getAnalysisType().toString(), (Object)analysisDuration);
                        MainframeSearchViewer.this.isSearchFinished = true;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MainframeSearchViewer.this.enableInput(true);
                            }
                        });
                    }
                    childMonitor.done();
                    return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }
            };
            if (currentSelectedProjects.size() >= 5) {
                JobGroup jg = this.getJobGroup(idx++, currentSelectedProjects.size());
                j.setJobGroup(jg);
            }
            j.setUser(true);
            j.schedule();
        }
    }

    private JobGroup getJobGroup(int idx, int total) {
        int gNo = idx % 5;
        JobGroup jg = this.jobGroups.get(gNo);
        if (jg == null) {
            jg = new JobGroup(String.valueOf(gNo), 1, total / 5);
            this.jobGroups.put(gNo, jg);
        }
        return jg;
    }

    private synchronized void incFinishedJobs() {
        ++this.noOfFinishedJobs;
    }

    private void forceFirstPrjSelection() {
        this.resultProjectsList.setSelection(0);
        String prjDisplayText = this.resultProjectsList.getItem(0);
        String projectName = (String)this.resultProjectsList.getData(prjDisplayText);
        this.handleResultProjectSelection(projectName);
        if (!this.exportToCSVButton.getEnabled()) {
            this.exportToCSVButton.setEnabled(true);
            this.exportToCSVButton.setImage(this.imgRegistry.get(IMAGE_EXPORT_KEY));
        }
    }

    private void clearResults() {
        if (this.resultsMap != null) {
            this.resultsMap.clear();
        }
        this.totalFiles = 0;
        this.totalOccurrences = 0;
        this.selectedResultProject = "";
        this.selectedResultFileIndex = -1;
        this.selectedResultLineIndex = -1;
        this.jobGroups.clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MainframeSearchViewer.this.resultsLabel.setText(Messages.getString(MainframeSearchViewer.class, "results.label.text"));
                MainframeSearchViewer.this.exportToCSVButton.setEnabled(false);
                MainframeSearchViewer.this.exportToCSVButton.setImage(MainframeSearchViewer.this.imgRegistry.get(MainframeSearchViewer.IMAGE_DISABLE_EXPORT_KEY));
                MainframeSearchViewer.this.filesLabel.setText(Messages.getString(MainframeSearchViewer.class, "files.label.text"));
                MainframeSearchViewer.this.occurrencesLabel.setText(Messages.getString(MainframeSearchViewer.class, "occurrences.label.text"));
                if (MainframeSearchViewer.this.resultProjectsList != null) {
                    MainframeSearchViewer.this.resultProjectsList.removeAll();
                }
                if (MainframeSearchViewer.this.resultFileList != null) {
                    MainframeSearchViewer.this.resultFileList.removeAll();
                }
                if (MainframeSearchViewer.this.resultsTableViewer.getTable() != null) {
                    MainframeSearchViewer.this.resultsTableViewer.getTable().removeAll();
                }
            }
        };
        Display.getDefault().asyncExec(runnable);
    }

    private synchronized void updateTotals(Integer filesCount, Integer occurrsCount) {
        this.totalFiles = this.totalFiles + filesCount;
        this.totalOccurrences = this.totalOccurrences + occurrsCount;
        String resultsLabelText = Messages.getString(MainframeSearchViewer.class, "results.label.text");
        String totalsSummaryText = Messages.getString(MainframeSearchViewer.class, "totals.summary.text", new String[]{String.valueOf(this.totalFiles), String.valueOf(this.totalOccurrences)});
        this.resultsLabel.setText(String.valueOf(resultsLabelText) + " " + totalsSummaryText);
    }

    private void setFilesSummaryLabel(String projectName) {
        ResultProjectData resultPrjData = this.resultsMap.get(projectName);
        int noOfFiles = -1;
        if (resultPrjData != null) {
            noOfFiles = resultPrjData.getNumberOfFiles();
        }
        String filesLabelText = Messages.getString(MainframeSearchViewer.class, "files.label.text");
        this.filesLabel.setText(noOfFiles > 0 ? String.valueOf(filesLabelText) + " " + noOfFiles : filesLabelText);
    }

    private void fillFilesForProject(String projectName) {
        this.resultFileList.removeAll();
        this.selectedResultFileIndex = -1;
        ResultProjectData resultPrjData = this.resultsMap.get(projectName);
        List<SearchItem> resultsList = resultPrjData.getResultSearchItems();
        this.setFilesSummaryLabel(projectName);
        if (resultsList != null && !resultsList.isEmpty()) {
            ArrayList<Pair> fileNamesList = new ArrayList<Pair>();
            for (SearchItem resultItem : resultsList) {
                String filePath = resultItem.getPath();
                String displayText = null;
                if (filePath != null && !filePath.isEmpty()) {
                    displayText = filePath;
                    int sepIndex = filePath.lastIndexOf("\\");
                    if (sepIndex > 0) {
                        displayText = filePath.substring(sepIndex + 1);
                    }
                } else {
                    displayText = resultItem.getErrMsg();
                }
                fileNamesList.add(new Pair((Object)displayText, (Object)resultItem));
            }
            Collections.sort(fileNamesList, new Comparator<Pair<String, SearchItem>>(){

                @Override
                public int compare(Pair<String, SearchItem> o1, Pair<String, SearchItem> o2) {
                    return ((String)o1.getFirst()).compareToIgnoreCase((String)o2.getFirst());
                }
            });
            for (Pair pair : fileNamesList) {
                this.resultFileList.add((String)pair.getFirst());
                this.resultFileList.setData(String.valueOf(this.resultFileList.getItemCount() - 1), pair.getSecond());
            }
            this.resultFileList.setSelection(0);
            this.handleResultFileSelection(0, projectName, false);
        }
    }

    private void displayResultProjectWithSummary(final String projectName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ResultProjectData resultPrjData = (ResultProjectData)MainframeSearchViewer.this.resultsMap.get(projectName);
                if (resultPrjData == null) {
                    L.warn("project {} is not into the results map", (Object)projectName);
                }
                String[] displayedProjects = MainframeSearchViewer.this.resultProjectsList.getItems();
                ArrayList<String> workList = new ArrayList<String>();
                workList.addAll(Arrays.asList(displayedProjects));
                workList.add(resultPrjData.getDisplayText());
                Collections.sort(workList, String.CASE_INSENSITIVE_ORDER);
                int insertIndex = workList.indexOf(resultPrjData.getDisplayText());
                MainframeSearchViewer.this.resultProjectsList.add(resultPrjData.getDisplayText(), insertIndex);
                MainframeSearchViewer.this.resultProjectsList.setData(resultPrjData.getDisplayText(), (Object)projectName);
                MainframeSearchViewer.this.updateTotals(resultPrjData.getNumberOfFiles(), resultPrjData.getOccurrences());
            }
        });
    }

    private IActionContext buildContext(ProjectInfo pi, List<EZObjectType> objectTypeList) {
        ArrayList<EZObjectType> inputTypes = new ArrayList<EZObjectType>(objectTypeList);
        Map currentData = this.descriptor.getState().getData();
        final HashMap<String, ArrayList<Object>> data = new HashMap<String, ArrayList<Object>>();
        data.put("ANALYSIS_TYPE_INPUTS", inputTypes);
        data.put("projects", (ArrayList<Object>)currentData.get("projects"));
        data.put("sourceView", (ArrayList<Object>)new Pair((Object)"com.ez.analysisbrowser.views.AnalysisBrowserView", (Object)((BrowserManager)this.manager).getViewSecondaryId()));
        IActionContext ac = new IActionContext(){

            public String getId() {
                return "com.ez.analysis.mainframe.search.project";
            }

            public Map<String, Object> getData() {
                return data;
            }

            public IActionContext getClone() {
                return null;
            }
        };
        return ac;
    }

    private void handleResultProjectSelection(String projectName) {
        if (!this.selectedResultProject.equalsIgnoreCase(projectName)) {
            this.selectedResultProject = projectName;
            this.fillFilesForProject(projectName);
            this.handleContextForResultPrjSelection(projectName);
            this.actionContextLoadedForProject = true;
            this.resultProjectsList.setFocus();
        } else if (!this.actionContextLoadedForProject) {
            this.handleContextForResultPrjSelection(projectName);
            this.actionContextLoadedForProject = true;
        }
    }

    private void handleContextForResultPrjSelection(String projectName) {
        ResultProjectData resultPrjData = this.resultsMap.get(projectName);
        final ProjectInfo projectInfo = resultPrjData.getProjectInfo();
        final ArrayList<ProjectInfo> selectedProjectsList = new ArrayList<ProjectInfo>();
        selectedProjectsList.add(projectInfo);
        final Object availablePrjs = this.descriptor.getState().getData().get("projects");
        final ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        inputs.add(this.createProjectInputType(projectInfo));
        AbstractActionContext context = new AbstractActionContext(){

            public Map<String, Object> getData() {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("PROJECT_LIST", selectedProjectsList);
                data.put("projects", availablePrjs);
                data.put("ANALYSIS_TYPE_INPUTS", inputs);
                StructuredSelection sel = new StructuredSelection((Object)projectInfo);
                if (sel != null) {
                    data.put("selection", sel);
                    data.put("unique identifier of the property sheet page contributor", "ezresource.contributor");
                }
                return data;
            }

            public String getId() {
                return MainframeSearchViewer.this.descriptor.getId();
            }
        };
        this.descriptor.getState().getData().put(CONTEXT_STATE, context);
        this.manager.setCurrentContext((IActionContext)context);
        this.actionContextLoadedForFile = false;
        this.actionContextLoadedForLine = false;
    }

    private EZObjectType createProjectInputType(ProjectInfo projectInfo) {
        EZSourceProjectInputType inputType = new EZSourceProjectInputType();
        EZEntityID entity = new EZEntityID();
        inputType.setEntID(entity);
        entity.addSegment((EZSegment)new EZSourceProjectIDSg(projectInfo));
        inputType.setName(projectInfo.getName());
        inputType.addProperty("PROJECT_INFO", (Object)projectInfo);
        inputType.setContext(AnalysisBrowserContext.class);
        return inputType;
    }

    private void handleGoToSourceDoubleClick() {
        int[] nArray;
        int selIndex = this.resultFileList.getSelectionIndex();
        if (selIndex == -1) {
            return;
        }
        final SearchItem selSearchItem = (SearchItem)this.resultFileList.getData(String.valueOf(selIndex));
        final String resourcePath = selSearchItem.getPath();
        if (resourcePath == null) {
            return;
        }
        TableItem[] tis = this.resultsTableViewer.getTable().getSelection();
        LineInfo lineInfo = tis != null && tis.length > 0 ? (LineInfo)tis[0].getData() : null;
        int lineNo = lineInfo != null ? lineInfo.lineNo : 0;
        List<OffAndLen> offsetsList = lineInfo != null ? lineInfo.offsetInfo : null;
        OffAndLen firstTermOffset = offsetsList != null ? offsetsList.get(0) : null;
        int lenght = firstTermOffset != null ? firstTermOffset.len : 0;
        final int[] bounds = new int[]{lineNo, lenght};
        int idx = firstTermOffset != null ? firstTermOffset.idx : -1;
        List<List<SearchItem.OffsetInfo>> fileOffsetsList = selSearchItem.getOffsets();
        SearchItem.OffsetInfo firstTermOffsetInfo = null;
        if (idx > -1) {
            int searchTocken = fileOffsetsList.get(0).size();
            int occurrence_idx = new Integer(idx == 0 ? 0 : idx / searchTocken);
            List<SearchItem.OffsetInfo> termsOffsetsList = fileOffsetsList.get(occurrence_idx);
            firstTermOffsetInfo = termsOffsetsList.get(0);
        }
        if (firstTermOffsetInfo != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = firstTermOffsetInfo.getStart();
            nArray = nArray2;
            nArray2[1] = firstTermOffsetInfo.getEnd();
        } else {
            nArray = null;
        }
        final int[] offsets = nArray;
        String prjDisplayText = this.resultProjectsList.getSelection()[0];
        final String projectName = (String)this.resultProjectsList.getData(prjDisplayText);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String editorId = TypeConvertor.convertToEditorType(selSearchItem.getTypeInfo());
                com.ez.mainframe.gui.utils.Utils.openEditor((String)resourcePath, (int[])bounds, (int[])offsets, (String)editorId, (String)projectName);
            }
        });
    }

    private void handleResultFileSelection(int selIndex, String projectName, boolean updateContext) {
        if (this.selectedResultFileIndex != selIndex) {
            this.selectedResultFileIndex = selIndex;
            ResultProjectData resultPrjData = this.resultsMap.get(projectName);
            SearchItem searchItem = (SearchItem)this.resultFileList.getData(String.valueOf(selIndex));
            if (searchItem.getPath() != null && !searchItem.getPath().isEmpty()) {
                this.fillOccurrencesForFile(searchItem);
                if (updateContext) {
                    this.handleContextForResultFileSelection(searchItem, resultPrjData.getProjectInfo());
                    this.actionContextLoadedForFile = true;
                }
            } else {
                this.resultsTableViewer.getTable().removeAll();
                this.occurrencesLabel.setText(Messages.getString(MainframeSearchViewer.class, "occurrences.label.text"));
                this.descriptor.getState().getData().put(CONTEXT_STATE, null);
                this.manager.setCurrentContext(null);
            }
        } else if (!this.actionContextLoadedForFile) {
            ResultProjectData resultPrjData = this.resultsMap.get(projectName);
            SearchItem searchItem = (SearchItem)this.resultFileList.getData(String.valueOf(selIndex));
            this.handleContextForResultFileSelection(searchItem, resultPrjData.getProjectInfo());
            this.actionContextLoadedForFile = true;
        }
    }

    private void fillLineDetails(String file, List<List<SearchItem.OffsetInfo>> offsetsList, Function<LineInfo, Boolean> lif, IProgressMonitor monitor) throws MalformedURLException, IOException {
        SubMonitor subMonitor;
        block18: {
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            HashMap<Integer, SearchItem.OffsetInfo> offsets = new HashMap<Integer, SearchItem.OffsetInfo>();
            String fileService = null;
            FileServerService srv = (FileServerService)ServiceUtils.getService(FileServerService.class);
            if (srv != null) {
                fileService = srv.getLAOEndpoint();
            }
            subMonitor.worked(10);
            if (fileService == null) {
                throw new IOException("cannot obtain fileservice endpoint");
            }
            StringBuilder offsetQuery = new StringBuilder(fileService);
            offsetQuery.append("?");
            offsetQuery.append("f=").append(URLEncoder.encode(file, "UTF-8"));
            int idx = 0;
            for (List<SearchItem.OffsetInfo> termsOffsetsList : offsetsList) {
                for (SearchItem.OffsetInfo oi : termsOffsetsList) {
                    offsets.put(idx++, oi);
                    offsetQuery.append("&o=").append(oi.getStart());
                }
            }
            subMonitor.worked(10);
            String content = this.runRequest(offsetQuery.toString());
            subMonitor.worked(50);
            if (content != null) {
                JsonReader reader;
                block17: {
                    reader = null;
                    try {
                        try {
                            JsonArray data;
                            reader = Json.createReader((Reader)new StringReader(content));
                            JsonObject root = reader.readObject();
                            subMonitor.worked(20);
                            boolean ok = root.getBoolean("ok");
                            if (!ok || (data = root.getJsonArray("data")) == null) break block17;
                            int i = 0;
                            while (i < data.size()) {
                                JsonObject lineInfo = data.getJsonObject(i);
                                int lineNo = lineInfo.getInt("line");
                                String lineText = lineInfo.getString("text");
                                JsonString jsonLineText = lineInfo.getJsonString("text");
                                if (jsonLineText != null) {
                                    byte[] bytes = Base64.getDecoder().decode(jsonLineText.getString());
                                    lineText = new String(bytes, root.getString("encoding"));
                                }
                                ArrayList<OffAndLen> oInfo = new ArrayList<OffAndLen>();
                                JsonArray offsetsInLine = lineInfo.getJsonArray("oil");
                                if (offsetsInLine != null) {
                                    int ii = 0;
                                    while (ii < offsetsInLine.size()) {
                                        JsonObject ofs = offsetsInLine.getJsonObject(ii);
                                        int o = ofs.getInt("offset");
                                        int ix = ofs.getInt("idx");
                                        SearchItem.OffsetInfo oi = (SearchItem.OffsetInfo)offsets.get(ix);
                                        int len = oi.getEnd() - oi.getStart();
                                        OffAndLen offLen = new OffAndLen();
                                        offLen.len = len;
                                        offLen.offset = o;
                                        offLen.idx = ix;
                                        oInfo.add(offLen);
                                        ++ii;
                                    }
                                }
                                LineInfo li = new LineInfo();
                                li.lineNo = lineNo + 1;
                                li.lineText = lineText;
                                li.offsetInfo = oInfo;
                                boolean more = lif.apply(li);
                                if (more) {
                                    ++i;
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception e) {
                            L.error("while parsing reply", (Throwable)e);
                            if (reader != null) {
                                reader.close();
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable;
                    }
                }
                if (reader != null) {
                    reader.close();
                }
            }
        }
        subMonitor.done();
    }

    private String runRequest(String endpoint) throws IOException {
        String ret = null;
        URL url = new URL(endpoint);
        SSOService sso = (SSOService)ServiceUtils.getService(SSOService.class);
        if (sso != null) {
            HttpResponseConsumer consumer = new HttpResponseConsumer();
            try {
                sso.request(url, consumer);
                ret = consumer.getContent();
                if (consumer.getHttpCode() != 200) {
                    String msg = Messages.getString(MainframeSearchViewer.class, "requestFileAtOffset.response.error", new String[]{String.valueOf(consumer.getHttpCode())});
                    LogUtil.displayErrorMessage((Status)new Status(4, "com.ez.analysis.mainframe.search", msg, null), (boolean)false);
                }
            }
            catch (Exception ex) {
                LogUtil.displayErrorMessage((Status)new Status(4, "com.ez.analysis.mainframe.search", Messages.getString(MainframeSearchViewer.class, "requestFileAtOffset.error.message"), (Throwable)ex), (boolean)false);
                L.error("error getting content at offset", (Throwable)ex);
            }
        } else {
            L.error("cannot find SSOService!");
        }
        return ret;
    }

    private void fillOccurrencesForFile(final SearchItem searchItem) {
        this.resultsTableViewer.getTable().removeAll();
        this.selectedResultLineIndex = -1;
        Job readOccurrenceLinesJob = new Job(Messages.getString(MainframeSearchViewer.class, "load.occurrencesLines.job.name")){

            protected IStatus run(final IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                subMonitor.subTask(Messages.getString(MainframeSearchViewer.class, "load.occurrencesLines.task.name"));
                String filePath = searchItem.getPath();
                List<List<SearchItem.OffsetInfo>> offsetsList = searchItem.getOffsets();
                subMonitor.worked(10);
                if (offsetsList != null && !offsetsList.isEmpty()) {
                    final int occurrences = offsetsList.size();
                    final String occurrencesLabelText = Messages.getString(MainframeSearchViewer.class, "occurrences.label.text");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MainframeSearchViewer.this.occurrencesLabel.setText(occurrences >= 0 ? String.valueOf(occurrencesLabelText) + " " + occurrences : occurrencesLabelText);
                        }
                    });
                    final ArrayList tableData = new ArrayList();
                    try {
                        Collection viewSrcContributors = EZWorkspace.getInstance().getViewSourceContributors();
                        boolean isShared = true;
                        if (viewSrcContributors != null) {
                            for (IGoToSourceService goToService : viewSrcContributors) {
                                HashMap<String, Properties> map = new HashMap<String, Properties>();
                                map.put(searchItem.getPath(), new Properties());
                                if (!goToService.isEnableGoToSource(map)) continue;
                                isShared = false;
                                break;
                            }
                        }
                        if (isShared && HookUtils.isRdzAdditionsAvailable() && HookUtils.isValitRemotePath((String)filePath)) {
                            isShared = false;
                        }
                        MainframeSearchViewer.this.resultsTableViewer.setData(MainframeSearchViewer.FILE_IS_SHARED_KEY, (Object)isShared);
                        if (isShared) {
                            MainframeSearchViewer.this.fillLineDetails(filePath, offsetsList, new Function<LineInfo, Boolean>(){

                                @Override
                                public Boolean apply(LineInfo li) {
                                    tableData.add(li);
                                    if (monitor.isCanceled()) {
                                        return false;
                                    }
                                    return true;
                                }
                            }, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)subMonitor, (int)80));
                        }
                    }
                    catch (IOException e) {
                        L.error("Error while getting file details: {} ", (Object)filePath, (Object)e);
                        LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(MainframeSearchViewer.class, "file.access.error.text", new String[]{filePath}), (String)Messages.getString(MainframeSearchViewer.class, "dialog.error.title"), (Plugin)Activator.getDefault(), (boolean)false);
                        ArrayList<String> row = new ArrayList<String>(1);
                        row.add(Messages.getString(MainframeSearchViewer.class, "file.access.error.result.text", new String[]{filePath}));
                        row.add(searchItem.getTerm());
                        tableData.add(row);
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Boolean shared = (Boolean)MainframeSearchViewer.this.resultsTableViewer.getData(MainframeSearchViewer.FILE_IS_SHARED_KEY);
                            if (shared != null && !shared.booleanValue()) {
                                MainframeSearchViewer.this.resultsTableViewer.getTable().setSize(0, 0);
                                MainframeSearchViewer.this.resultsTableViewer.getControl().setVisible(false);
                                int[] nArray = new int[3];
                                nArray[0] = 50;
                                nArray[1] = 50;
                                MainframeSearchViewer.this.resultsSashForm.setWeights(nArray);
                            } else {
                                if (MainframeSearchViewer.this.resultsSashForm.getWeights()[2] == 0) {
                                    MainframeSearchViewer.this.resultsSashForm.setWeights(new int[]{25, 25, 50});
                                }
                                if (tableData.size() > 0) {
                                    MainframeSearchViewer.this.resultsTableViewer.setInput((Object)tableData);
                                    MainframeSearchViewer.this.resultsTableViewer.getTable().update();
                                    MainframeSearchViewer.this.resultsTableViewer.getTable().getColumn(0).pack();
                                    MainframeSearchViewer.this.resultsTableViewer.getTable().getColumn(1).pack();
                                }
                                if (MainframeSearchViewer.this.resultsTableViewer.getTable().getItemCount() > 0) {
                                    MainframeSearchViewer.this.resultsTableViewer.getTable().setSelection(0);
                                }
                            }
                        }
                    });
                }
                if (MainframeSearchViewer.this.isSearchFinished) {
                    long analysisDuration = System.currentTimeMillis() - MainframeSearchViewer.this.analysisStartTime;
                    L.info("{} - search duration after displaying results: {} ms.", (Object)MainframeSearchViewer.this.descriptor.getAnalysisType().toString(), (Object)analysisDuration);
                }
                subMonitor.done();
                return subMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        readOccurrenceLinesJob.setUser(true);
        readOccurrenceLinesJob.schedule();
    }

    private void handleContextForResultFileSelection(final SearchItem searchItem, final ProjectInfo projectInfo) {
        if (searchItem.getTypeInfo() != null) {
            new Job(Messages.getString(MainframeSearchViewer.class, "load.data.for.context.actions.job")){

                protected IStatus run(IProgressMonitor monitor) {
                    MainframeSearchViewer mainframeSearchViewer = MainframeSearchViewer.this;
                    mainframeSearchViewer.getClass();
                    ContextRunnable what = mainframeSearchViewer.new ContextRunnable(projectInfo, searchItem, MainframeSearchViewer.this.manager);
                    try {
                        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                        IMFProjectHandler ph = service.getProjectHandler(projectInfo.getName(), null);
                        if (ph != null) {
                            try {
                                ph.submitWithLock(ph, (IMFRunnable)what, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (Exception ex) {
                                L.error("Unexpected exception.", (Throwable)ex);
                            }
                        } else {
                            L.trace("no connection available for {}", (Object)projectInfo.getName());
                        }
                    }
                    catch (Exception ex) {
                        L.error("Unexpected exception.", (Throwable)ex);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            L.debug("do not load data for an empty searchInfo");
        }
        this.actionContextLoadedForProject = false;
        this.actionContextLoadedForLine = false;
    }

    private void handleResultLineSelection() {
        int selIndex = this.resultsTableViewer.getTable().getSelectionIndex();
        if (selIndex > -1) {
            if (selIndex != this.selectedResultLineIndex) {
                this.selectedResultLineIndex = selIndex;
                this.handleContextForResultLineSelection();
                this.actionContextLoadedForLine = true;
            } else if (!this.actionContextLoadedForLine) {
                this.handleContextForResultLineSelection();
                this.actionContextLoadedForLine = true;
            }
        } else {
            this.descriptor.getState().getData().put(CONTEXT_STATE, null);
            this.manager.setCurrentContext(null);
        }
    }

    private void handleContextForResultLineSelection() {
        final Object availablePrjs = this.descriptor.getState().getData().get("projects");
        SearchItem searchItem = (SearchItem)this.resultFileList.getData(String.valueOf(this.resultFileList.getSelectionIndex()));
        String sourceFilePath = searchItem.getPath();
        boolean isCobol = false;
        List<Pair<Integer, Boolean>> cobolFileTypes = fileTypesPerResType.get((Object)ResType.COBOL);
        for (Pair<Integer, Boolean> fileTypePair : cobolFileTypes) {
            String fileType = ((Integer)fileTypePair.getFirst()).toString();
            if (!fileType.equals(searchItem.getTypeInfo().getFirst()) || !((Boolean)fileTypePair.getSecond()).equals(searchItem.getTypeInfo().getSecond())) continue;
            isCobol = true;
        }
        List<Pair<Integer, Boolean>> cobolIncludeTypes = fileTypesPerResType.get((Object)ResType.COBOL_INCLUDE);
        for (Pair pair : cobolIncludeTypes) {
            String fileType = ((Integer)pair.getFirst()).toString();
            if (!fileType.equals(searchItem.getTypeInfo().getFirst()) || !((Boolean)pair.getSecond()).equals(searchItem.getTypeInfo().getSecond())) continue;
            isCobol = true;
        }
        if (!isCobol) {
            this.descriptor.getState().getData().put(CONTEXT_STATE, null);
            this.manager.setCurrentContext(null);
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.resultsTableViewer.getSelection();
        LineInfo selRowData = (LineInfo)iStructuredSelection.getFirstElement();
        if (selRowData.lineText == null || selRowData.lineText.isEmpty()) {
            this.descriptor.getState().getData().put(CONTEXT_STATE, null);
            this.manager.setCurrentContext(null);
            return;
        }
        final ArrayList<EZCobolSrcSelectionType> inputs = new ArrayList<EZCobolSrcSelectionType>();
        EZCobolSrcSelectionType objectType = new EZCobolSrcSelectionType();
        inputs.add(objectType);
        EZEntityID entityId = new EZEntityID();
        objectType.setEntID(entityId);
        Integer lineNumber = selRowData.lineNo;
        EZCobolSrcSelectionSg cobolSrcSelectionSg = new EZCobolSrcSelectionSg(sourceFilePath, lineNumber, lineNumber, selRowData.lineText);
        entityId.addSegment((EZSegment)cobolSrcSelectionSg);
        String prjDisplayText = this.resultProjectsList.getSelection()[0];
        String projectName = (String)this.resultProjectsList.getData(prjDisplayText);
        ResultProjectData resultPrjData = this.resultsMap.get(projectName);
        ProjectInfo projectInfo = resultPrjData.getProjectInfo();
        EZSourceProjectIDSg ezsourcePrjSg = new EZSourceProjectIDSg(projectInfo);
        entityId.addSegment((EZSegment)ezsourcePrjSg);
        AbstractActionContext context = new AbstractActionContext(){

            public Map<String, Object> getData() {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("projects", availablePrjs);
                data.put("ANALYSIS_TYPE_INPUTS", inputs);
                return data;
            }

            public String getId() {
                return MainframeSearchViewer.this.descriptor.getId();
            }
        };
        this.descriptor.getState().getData().put(CONTEXT_STATE, context);
        this.manager.setCurrentContext((IActionContext)context);
        this.actionContextLoadedForProject = false;
        this.actionContextLoadedForFile = false;
    }

    private List<EZObjectType> buildProgramInputs(EZSourceConnection conn, ProjectInfo pInfo, String resourcePath) {
        String query = "SELECT \n\tC.ProgramID, \n\tC.ProgramName, \n\tC.ProgramTypeID, \n\tD.ProgramID AS AncestorID, \n\tC.Ancestor AS AncestorName \nFROM Paths A \n\tINNER JOIN Occurrences B ON A.PathID = B.PathID \n\tINNER JOIN ( \n\t\tSELECT P.ProgramID, PA.AliasName AS ProgramName, P.ProgramTypeID, P.OccurID, P.Ancestor \n\t\tFROM Programs P \n\t\t\tINNER JOIN ProgramAliases PA ON P.ProgramID = PA.ProgramId AND PA.AliasType = 0 \n\t) C ON B.OccurID = C.OccurID AND C.ProgramTypeID IN (1,2,3,7,8,9,10,11,19) \n\tLEFT JOIN ( \n\t\tSELECT P.ProgramID, PA.AliasName AS ProgramName, P.ProgramTypeID \n\t\tFROM Programs P \n\t\t\tINNER JOIN ProgramAliases PA ON P.ProgramID = PA.ProgramId AND PA.AliasType = 0 \n\t) D ON C.Ancestor = D.ProgramName AND 13 = D.ProgramTypeID \nWHERE (UPPER(A.PathStr) = UPPER(?)) ";
        ArrayList<EZObjectType> objectTypeList = new ArrayList<EZObjectType>();
        L.trace("query for programs: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{resourcePath});
        if (results != null) {
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] row = stringArray[n2];
                Integer programId = Integer.parseInt(row[0]);
                String programName = row[1];
                Integer programType = Integer.valueOf(row[2]);
                EZObjectType objectType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(programType);
                objectType.addProperty("program occur", (Object)true);
                EZSourceProgramIDSg prgSg = new EZSourceProgramIDSg(programName, programId, programType, Boolean.valueOf(true));
                if (programType.equals(19)) {
                    Integer ancestorId = Integer.parseInt(row[3]);
                    prgSg.setAncestorId(ancestorId);
                }
                String ancestorName = row[4];
                prgSg.setAncestorName(ancestorName);
                prgSg.setIncompleteSegment(true);
                EZEntityID entityId = new EZEntityID();
                entityId.addSegment((EZSegment)new EZSourceProjectIDSg(pInfo));
                entityId.addSegment((EZSegment)prgSg);
                objectType.setEntID(entityId);
                objectTypeList.add(objectType);
                ++n2;
            }
        } else {
            L.trace("could not find info for path {}", (Object)resourcePath);
        }
        return objectTypeList;
    }

    private List<EZObjectType> buildObjectTypeList(EZObjectType inputObjectType, String resourcePath) {
        ArrayList<EZObjectType> inputObjectTypes = new ArrayList<EZObjectType>();
        if (inputObjectType != null) {
            inputObjectTypes.add(inputObjectType);
        } else {
            L.trace("could not find info for path {}", (Object)resourcePath);
        }
        return inputObjectTypes;
    }

    private String buildPathForNaturalDataArea(String resourcePath) {
        String pathForQuery = resourcePath;
        String pathSeparator = "/";
        int sepIdx = resourcePath.lastIndexOf(47);
        if (sepIdx == -1) {
            sepIdx = resourcePath.lastIndexOf(92);
            pathSeparator = "\\";
        }
        if (sepIdx != -1) {
            String name = resourcePath.substring(sepIdx + 1);
            String parentFolder = resourcePath.substring(0, sepIdx);
            if ((sepIdx = parentFolder.lastIndexOf(pathSeparator)) != -1) {
                StringBuilder sBuilder = new StringBuilder(parentFolder.substring(0, sepIdx));
                sBuilder.append(pathSeparator);
                sBuilder.append("DA");
                sBuilder.append(pathSeparator);
                sBuilder.append(name);
                sBuilder.append(".DA");
                pathForQuery = sBuilder.toString();
            }
        }
        return pathForQuery;
    }

    private EZObjectType buildIncludeInput(EZSourceConnection conn, ProjectInfo pInfo, String resourcePath) {
        String query = "SELECT \n\tC.Name AS ResourceName, \n\tC.ResourceType, \n\tB.PathID \nFROM Paths A \n\tINNER JOIN Occurrences B ON A.PathID = B.PathID AND B.ResourceType IN (13, 57, 60, 67, 99) \n\tINNER JOIN Resources C ON B.ResourceID = C.ResourceID \nWHERE (UPPER(A.PathStr) = UPPER(?)) ";
        EZSourceInclude objectType = null;
        L.trace("query for includes: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{resourcePath});
        if (results != null) {
            String includeName = results[0][0];
            Integer includeType = Integer.valueOf(results[0][1]);
            Integer pathID = Integer.valueOf(results[0][2]);
            objectType = new EZSourceInclude();
            EZSourceIncludeIDSg includeSg = new EZSourceIncludeIDSg(includeName, pathID);
            objectType.addProperty("mainframe resource id sg", (Object)includeSg);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(pInfo));
            entityId.addSegment((EZSegment)includeSg);
            objectType.addProperty("include is not on disk", (Object)(resourcePath.equals(includeName) ? Boolean.TRUE : Boolean.FALSE));
            Integer ctxPrgType = this.getPrgTypeForInclude(includeType);
            EZSourceProgramTypeIDSg prgSg = new EZSourceProgramTypeIDSg(ctxPrgType);
            entityId.addSegment((EZSegment)prgSg);
            objectType.setEntID(entityId);
        }
        return objectType;
    }

    private Integer getPrgTypeForInclude(Integer includeType) {
        Integer programType = null;
        switch (includeType) {
            case 13: {
                programType = 1;
                break;
            }
            case 57: 
            case 60: {
                programType = 3;
                break;
            }
            case 67: {
                programType = 2;
                break;
            }
            case 99: {
                programType = 8;
            }
        }
        return programType;
    }

    private List<EZObjectType> buildBMSInputs(EZSourceConnection conn, ProjectInfo pInfo, String resourcePath) {
        String query = "SELECT \n\tC.BmsID, \n\tC.BmsName, \n\tC.OccurID, \n\tD.BmsName AS MapsetName \nFROM Paths A \n\tINNER JOIN Occurrences B ON A.PathID = B.PathID AND B.ResourceType = 6 \n\tINNER JOIN Bms C ON B.ResourceID = C.BmsID AND C.IsMapSet=0 \n\tLEFT JOIN Bms D ON C.AncestorID = D.BmsID \nWHERE (UPPER(A.PathStr) = UPPER(?)) ";
        ArrayList<EZObjectType> objectTypeList = new ArrayList<EZObjectType>();
        L.trace("query for bms maps: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{resourcePath});
        if (results != null) {
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] row = stringArray[n2];
                Integer screenID = Integer.valueOf(row[0]);
                String screenName = row[1];
                Integer occurId = Integer.valueOf(row[2]);
                String mapSet = row[3];
                EZEntityID entity = new EZEntityID();
                entity.addSegment((EZSegment)new EZSourceProjectIDSg(pInfo));
                EZSourceScreenIDSg scrIdSg = new EZSourceScreenIDSg(screenID, screenName, 119, occurId);
                scrIdSg.setMapSet(mapSet);
                entity.addSegment((EZSegment)scrIdSg);
                EZObjectType objectType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(6), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                objectType.setName(screenName);
                objectType.setEntID(entity);
                objectTypeList.add(objectType);
                ++n2;
            }
        } else {
            L.trace("could not find info for path {}", (Object)resourcePath);
        }
        return objectTypeList;
    }

    private EZObjectType buildJCLJobInput(EZSourceConnection conn, ProjectInfo pInfo, String resourcePath) {
        String query = "SELECT \n\tB.JobID, \n\tB.JobName, \n\tB.MemberName, \n\tC.JobID as CA7JobID, \n\tC.JOB_NAME as CA7JobName, \n\tB.BuildStatus \nFROM JCLPosition A \n\tINNER JOIN JCLJob B ON A.PositionID = B.PositionID AND A.ResourceType = 22 \n\tLEFT JOIN CA7_Jobs C ON B.MemberName = C.JCL_MEMBER \nWHERE (UPPER(A.ResourceFilePath) = UPPER(?)) ";
        EZObjectType objectType = null;
        L.trace("query for jcl jobs: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{resourcePath});
        if (results != null) {
            Integer jobId = Integer.parseInt(results[0][0]);
            String jobName = results[0][1];
            String memberName = results[0][2];
            Integer ca7JobId = results[0][3] != null ? Integer.valueOf(Integer.parseInt(results[0][3])) : null;
            String ca7JobName = results[0][4];
            objectType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(22));
            EZSourceJobIDSg jobSg = new EZSourceJobIDSg(jobName, jobId.intValue(), Integer.valueOf(22), memberName, ca7JobName, ca7JobId);
            jobSg.setDeleted(!"1".equals(results[0][5]));
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(pInfo));
            entityId.addSegment((EZSegment)jobSg);
            entityId.addSegment((EZSegment)new EZSourceAAUTOJobIDSg(jobName, null));
            objectType.setEntID(entityId);
        }
        return objectType;
    }

    private EZObjectType buildNaturalMapInput(EZSourceConnection conn, ProjectInfo pInfo, String resourcePath) {
        String query = "SELECT \n\tC.MapID, \n\tC.MapName, \n\tC.OccurID, \n\tD.MapName AS MapSet \nFROM Paths A \n\tINNER JOIN Occurrences B ON A.PathID = B.PathID \n\t\tAND B.ResourceType = 61 \n\tINNER JOIN NaturalMaps C ON B.ResourceID = C.MapID \n\tLEFT JOIN NaturalMaps D ON C.AncestorID = D.MapID \nWHERE (UPPER(A.PathStr) = UPPER(?)) ";
        EZObjectType objectType = null;
        L.trace("query for natural maps: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{resourcePath});
        if (results != null) {
            Integer mapId = Integer.parseInt(results[0][0]);
            String mapName = results[0][1];
            Integer occurId = Integer.valueOf(results[0][2]);
            String mapSet = results[0][3];
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)new EZSourceProjectIDSg(pInfo));
            EZSourceScreenIDSg scrIdSg = new EZSourceScreenIDSg(mapId, mapName, 120, Integer.valueOf(occurId));
            scrIdSg.setMapSet(mapSet);
            entity.addSegment((EZSegment)scrIdSg);
            objectType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(61), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            objectType.setName(mapName);
            objectType.setEntID(entity);
        }
        return objectType;
    }

    private EZObjectType buildAdsMapInput(EZSourceConnection conn, ProjectInfo pInfo, String resourcePath) {
        String query = "SELECT \n\tC.MapID, \n\tC.MapName, \n\tC.OccurId \nFROM Paths A \n\tINNER JOIN Occurrences B ON A.PathID = B.PathID \n\t\tAND B.ResourceType = 95 \n\tINNER JOIN AdsMaps C ON B.ResourceID = C.MapID \nWHERE (UPPER(A.PathStr) = UPPER(?)) ";
        EZObjectType objectType = null;
        L.trace("query for ads maps: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{resourcePath});
        if (results != null) {
            Integer mapId = Integer.parseInt(results[0][0]);
            String mapName = results[0][1];
            Integer occurId = Integer.valueOf(results[0][2]);
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)new EZSourceProjectIDSg(pInfo));
            EZSourceScreenIDSg scrIdSg = new EZSourceScreenIDSg(mapId, mapName, 118, Integer.valueOf(occurId));
            entity.addSegment((EZSegment)scrIdSg);
            objectType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(95), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            objectType.setName(mapName);
            objectType.setEntID(entity);
        }
        return objectType;
    }

    private static Map<ResType, List<Pair<Integer, Boolean>>> createFileTypesPerResTypeMap() {
        EnumMap<ResType, List<Pair<Integer, Boolean>>> fileTypesPerResType = new EnumMap<ResType, List<Pair<Integer, Boolean>>>(ResType.class);
        ArrayList<Pair> fileTypes = new ArrayList<Pair>();
        fileTypes.add(new Pair((Object)57, (Object)true));
        fileTypesPerResType.put(ResType.ADS_DIALOG, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)58, (Object)true));
        fileTypesPerResType.put(ResType.ADS_MAP, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)56, (Object)true));
        fileTypes.add(new Pair((Object)32, (Object)false));
        fileTypesPerResType.put(ResType.ADS_PROCESS, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)49, (Object)true));
        fileTypesPerResType.put(ResType.ASSEMBLER, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)37, (Object)false));
        fileTypesPerResType.put(ResType.ASSEMBLER_INCLUDE, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)3, (Object)true));
        fileTypesPerResType.put(ResType.BMS, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)1, (Object)true));
        fileTypes.add(new Pair((Object)52, (Object)true));
        fileTypes.add(new Pair((Object)53, (Object)true));
        fileTypes.add(new Pair((Object)54, (Object)true));
        fileTypes.add(new Pair((Object)55, (Object)true));
        fileTypes.add(new Pair((Object)67, (Object)true));
        fileTypes.add(new Pair((Object)70, (Object)true));
        fileTypes.add(new Pair((Object)71, (Object)true));
        fileTypes.add(new Pair((Object)72, (Object)true));
        fileTypesPerResType.put(ResType.COBOL, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)2, (Object)true));
        fileTypes.add(new Pair((Object)23, (Object)false));
        fileTypesPerResType.put(ResType.COBOL_INCLUDE, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)31, (Object)true));
        fileTypesPerResType.put(ResType.MFS, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)5, (Object)true));
        fileTypesPerResType.put(ResType.JCL, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)48, (Object)true));
        fileTypes.add(new Pair((Object)29, (Object)false));
        fileTypesPerResType.put(ResType.JCL_CTRL, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)47, (Object)true));
        fileTypes.add(new Pair((Object)30, (Object)false));
        fileTypesPerResType.put(ResType.JCL_INCLUDE, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)46, (Object)true));
        fileTypes.add(new Pair((Object)31, (Object)false));
        fileTypesPerResType.put(ResType.JCL_PROC, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)19, (Object)true));
        fileTypesPerResType.put(ResType.NATURAL, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)22, (Object)true));
        fileTypesPerResType.put(ResType.NATURAL_DATA_AREA, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)73, (Object)true));
        fileTypesPerResType.put(ResType.NATURAL_DDM, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)20, (Object)true));
        fileTypes.add(new Pair((Object)28, (Object)false));
        fileTypesPerResType.put(ResType.NATURAL_INCLUDE, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)21, (Object)true));
        fileTypesPerResType.put(ResType.NATURAL_MAP, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)17, (Object)true));
        fileTypesPerResType.put(ResType.PL1, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)18, (Object)true));
        fileTypes.add(new Pair((Object)24, (Object)false));
        fileTypesPerResType.put(ResType.PL1_INCLUDE, fileTypes);
        fileTypes = new ArrayList();
        fileTypes.add(new Pair((Object)0, (Object)false));
        fileTypesPerResType.put(ResType.EXTERNAL, fileTypes);
        return fileTypesPerResType;
    }

    private void exportResultsToCSV(IProgressMonitor pmonitor, String fileNamePath) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        if (!this.resultsMap.isEmpty()) {
            monitor.setWorkRemaining(this.resultsMap.keySet().size());
            CSVWriter csvWriter = CSVWriter.open((File)new File(fileNamePath));
            if (csvWriter != null) {
                csvWriter.setSeparator(";");
                this.writeFiltersToCSV(csvWriter);
                for (String projectName : this.resultsMap.keySet()) {
                    if (monitor.isCanceled()) break;
                    monitor.setTaskName(Messages.getString(MainframeSearchViewer.class, "exportingResults.taskName", new String[]{projectName}));
                    this.writeResultsForProjectToCSV((IProgressMonitor)monitor.newChild(100), projectName, csvWriter);
                }
                csvWriter.close();
                if (!csvWriter.isExportOK()) {
                    monitor.setCanceled(true);
                }
            } else {
                monitor.setCanceled(true);
            }
        }
    }

    private void writeFiltersToCSV(final CSVWriter csvWriter) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                csvWriter.write(new String[]{Messages.getString(MainframeSearchViewer.class, "pattern.lbl"), MainframeSearchViewer.this.regexText.getText()});
                csvWriter.write(new String[]{Messages.getString(MainframeSearchViewer.class, "restrict.res"), MainframeSearchViewer.this.fileRegexText.getText()});
                csvWriter.write(new String[]{Messages.getString(MainframeSearchViewer.class, "fileTypeLabel.lbl"), MainframeSearchViewer.this.fileTypeText.getText()});
                csvWriter.write(new String[]{Messages.getString(MainframeSearchViewer.class, "checkCaseLabel.lbl"), String.valueOf(MainframeSearchViewer.this.checkCaseButton.getSelection())});
                csvWriter.write(new String[]{Messages.getString(MainframeSearchViewer.class, "checkRegexLabel.lbl"), String.valueOf(MainframeSearchViewer.this.checkRegexButton.getSelection())});
                csvWriter.write(new String[]{Messages.getString(MainframeSearchViewer.class, "checkCommentsLabel.lbl"), String.valueOf(MainframeSearchViewer.this.checkCommentsButton.getSelection())});
                csvWriter.write(new String[]{Messages.getString(MainframeSearchViewer.class, "checkPreviousLabel.lbl"), String.valueOf(MainframeSearchViewer.this.checkPreviousButton.getSelection())});
                csvWriter.write(new String[]{""});
            }
        });
    }

    private void writeResultsForProjectToCSV(IProgressMonitor pmonitor, final String projectName, final CSVWriter csvWriter) {
        final SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        ResultProjectData resultProjectData = this.resultsMap.get(projectName);
        List<SearchItem> resultSearchItems = resultProjectData.getResultSearchItems();
        if (resultSearchItems != null && !resultSearchItems.isEmpty()) {
            monitor.setWorkRemaining(3 * resultSearchItems.size());
            Collections.sort(resultSearchItems, new Comparator<SearchItem>(){

                @Override
                public int compare(SearchItem o1, SearchItem o2) {
                    if (o1.getPath() == null) {
                        return -1;
                    }
                    if (o2.getPath() == null) {
                        return 1;
                    }
                    return o1.getPath().compareToIgnoreCase(o2.getPath());
                }
            });
            for (SearchItem searchItem : resultSearchItems) {
                if (monitor.isCanceled()) break;
                final String filePath = searchItem.getPath();
                if (filePath != null && searchItem.getOffsets() != null) {
                    String fileName = filePath;
                    int sepIndex = filePath.lastIndexOf("\\");
                    if (sepIndex > 0) {
                        fileName = fileName.substring(sepIndex + 1);
                    }
                    final String fName = fileName;
                    try {
                        this.fillLineDetails(filePath, searchItem.getOffsets(), new Function<LineInfo, Boolean>(){

                            @Override
                            public Boolean apply(LineInfo li) {
                                Long lineNumber = 0L + (long)li.lineNo;
                                for (OffAndLen ol : li.offsetInfo) {
                                    ArrayList<String> csvLineArray = new ArrayList<String>();
                                    csvLineArray.add(projectName);
                                    csvLineArray.add(fName);
                                    csvLineArray.add(filePath);
                                    Long offsetInLine = 1L + (long)ol.offset;
                                    String lineColText = "(" + lineNumber + ", " + offsetInLine + ")";
                                    csvLineArray.add(lineColText);
                                    String lineText = li.lineText;
                                    if (lineText != null && !lineText.isEmpty()) {
                                        lineText = lineText.replaceAll("\"", "\"\"");
                                    }
                                    csvLineArray.add("\"" + lineText + "\"");
                                    csvWriter.write(csvLineArray.toArray(new String[0]));
                                }
                                if (monitor.isCanceled()) {
                                    return false;
                                }
                                return true;
                            }
                        }, (IProgressMonitor)monitor.newChild(1));
                        if (!monitor.isCanceled()) {
                            monitor.worked(1);
                        }
                    }
                    catch (IOException e) {
                        L.error("Export to CSV - error while opening/reading file {}", (Object)filePath, (Object)e);
                        LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(MainframeSearchViewer.class, "exportCSV.file.access.error.text", new String[]{filePath}), (String)Messages.getString(MainframeSearchViewer.class, "dialog.error.title"), (Plugin)Activator.getDefault(), (boolean)false);
                        csvWriter.write(new String[]{projectName, filePath, fileName});
                    }
                } else {
                    csvWriter.write(new String[]{projectName, searchItem.getErrMsg()});
                }
                if (monitor.isCanceled()) continue;
                monitor.worked(1);
            }
        }
        monitor.done();
    }

    private class ContextRunnable
    implements IMFRunnable {
        private ProjectInfo pi;
        private String resourcePath;
        private SearchItem searchItem;
        private IActionManager manager;

        public ContextRunnable(ProjectInfo pi, SearchItem searchItem, IActionManager manager) {
            this.pi = pi;
            this.resourcePath = searchItem.getPath();
            this.searchItem = searchItem;
            this.manager = manager;
        }

        public void run(EZSourceConnection conn, IProgressMonitor monitor) {
            IActionContext ac = null;
            try {
                EZObjectType objectType;
                List objectTypeList = null;
                MainframeSourceNode mfSourceNode = null;
                String fileLabel = Messages.getString(MainframeSearchViewer.class, "propertiesView.label.file");
                if ("1".equals(this.searchItem.getTypeInfo().getFirst()) || "17".equals(this.searchItem.getTypeInfo().getFirst()) || "19".equals(this.searchItem.getTypeInfo().getFirst()) || "33".equals(this.searchItem.getTypeInfo().getFirst()) || "49".equals(this.searchItem.getTypeInfo().getFirst()) || "51".equals(this.searchItem.getTypeInfo().getFirst()) || "52".equals(this.searchItem.getTypeInfo().getFirst()) || "53".equals(this.searchItem.getTypeInfo().getFirst()) || "54".equals(this.searchItem.getTypeInfo().getFirst()) || "55".equals(this.searchItem.getTypeInfo().getFirst()) || "56".equals(this.searchItem.getTypeInfo().getFirst()) || "32".equals(this.searchItem.getTypeInfo().getFirst()) && !((Boolean)this.searchItem.getTypeInfo().getSecond()).booleanValue() || "57".equals(this.searchItem.getTypeInfo().getFirst()) || "67".equals(this.searchItem.getTypeInfo().getFirst()) || "68".equals(this.searchItem.getTypeInfo().getFirst()) || "69".equals(this.searchItem.getTypeInfo().getFirst()) || "70".equals(this.searchItem.getTypeInfo().getFirst()) || "71".equals(this.searchItem.getTypeInfo().getFirst()) || "72".equals(this.searchItem.getTypeInfo().getFirst())) {
                    objectTypeList = MainframeSearchViewer.this.buildProgramInputs(conn, this.pi, this.resourcePath);
                    if (!objectTypeList.isEmpty()) {
                        EZObjectType objType = (EZObjectType)objectTypeList.get(0);
                        EZSourceProgramIDSg prgIDSg = (EZSourceProgramIDSg)objType.getEntID().getSegment(EZSourceProgramIDSg.class);
                        String programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)prgIDSg.getTypeId().toString());
                        mfSourceNode = new MainframeSourceNode(String.valueOf(programType) + " " + fileLabel, this.resourcePath);
                    } else {
                        L.debug("cannot find program for path: {}", (Object)this.resourcePath);
                    }
                }
                if ("2".equals(this.searchItem.getTypeInfo().getFirst()) || "23".equals(this.searchItem.getTypeInfo().getFirst()) && (Boolean)this.searchItem.getTypeInfo().getSecond() == false || "18".equals(this.searchItem.getTypeInfo().getFirst()) || "24".equals(this.searchItem.getTypeInfo().getFirst()) && (Boolean)this.searchItem.getTypeInfo().getSecond() == false || "20".equals(this.searchItem.getTypeInfo().getFirst()) || "28".equals(this.searchItem.getTypeInfo().getFirst()) && (Boolean)this.searchItem.getTypeInfo().getSecond() == false || "22".equals(this.searchItem.getTypeInfo().getFirst()) || "37".equals(this.searchItem.getTypeInfo().getFirst()) && !((Boolean)this.searchItem.getTypeInfo().getSecond()).booleanValue()) {
                    String path = this.resourcePath;
                    if ("22".equals(this.searchItem.getTypeInfo().getFirst())) {
                        path = MainframeSearchViewer.this.buildPathForNaturalDataArea(this.resourcePath);
                    }
                    EZObjectType objectType2 = MainframeSearchViewer.this.buildIncludeInput(conn, this.pi, path);
                    objectTypeList = MainframeSearchViewer.this.buildObjectTypeList(objectType2, this.resourcePath);
                    mfSourceNode = new MainframeSourceNode(String.valueOf(ResultElementType.INCLUDE.getDisplayName()) + " " + fileLabel, this.resourcePath);
                }
                if ("3".equals(this.searchItem.getTypeInfo().getFirst())) {
                    objectTypeList = MainframeSearchViewer.this.buildBMSInputs(conn, this.pi, this.resourcePath);
                    mfSourceNode = new MainframeSourceNode(String.valueOf(ResType.BMS.getLabel()) + " " + fileLabel, this.resourcePath);
                }
                if ("5".equals(this.searchItem.getTypeInfo().getFirst())) {
                    objectType = MainframeSearchViewer.this.buildJCLJobInput(conn, this.pi, this.resourcePath);
                    objectTypeList = MainframeSearchViewer.this.buildObjectTypeList(objectType, this.resourcePath);
                    mfSourceNode = new MainframeSourceNode(String.valueOf(ResultElementType.JCL_JOB.getDisplayName()) + " " + fileLabel, this.resourcePath);
                }
                if ("21".equals(this.searchItem.getTypeInfo().getFirst())) {
                    objectType = MainframeSearchViewer.this.buildNaturalMapInput(conn, this.pi, this.resourcePath);
                    objectTypeList = MainframeSearchViewer.this.buildObjectTypeList(objectType, this.resourcePath);
                    mfSourceNode = new MainframeSourceNode((Object)((Object)ResType.NATURAL_MAP) + " " + fileLabel, this.resourcePath);
                }
                if ("58".equals(this.searchItem.getTypeInfo().getFirst())) {
                    objectType = MainframeSearchViewer.this.buildAdsMapInput(conn, this.pi, this.resourcePath);
                    objectTypeList = MainframeSearchViewer.this.buildObjectTypeList(objectType, this.resourcePath);
                    mfSourceNode = new MainframeSourceNode((Object)((Object)ResType.ADS_MAP) + " " + fileLabel, this.resourcePath);
                }
                if (objectTypeList == null) {
                    L.warn("unhandled pj file type: {}", this.searchItem.getTypeInfo() != null ? this.searchItem.getTypeInfo().getFirst() : null);
                }
                if (objectTypeList != null && !objectTypeList.isEmpty()) {
                    ac = MainframeSearchViewer.this.buildContext(this.pi, objectTypeList);
                    StructuredSelection sel = new StructuredSelection();
                    if (mfSourceNode != null) {
                        EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)mfSourceNode);
                        EZEntityID entID = new EZEntityID();
                        entID.addSegment((EZSegment)sg);
                        sel = new StructuredSelection((Object)entID);
                    }
                    ac.getData().put("selection", sel);
                    ac.getData().put("unique identifier of the property sheet page contributor", "ezselection.contributor");
                }
            }
            catch (Exception e) {
                L.error("Unexpected exception.", (Throwable)e);
            }
            final IActionContext c = ac;
            MainframeSearchViewer.this.descriptor.getState().getData().put(MainframeSearchViewer.CONTEXT_STATE, c);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ContextRunnable.this.manager.setCurrentContext(c);
                }
            });
        }
    }

    private class FileTypeDialog
    extends TrayDialog {
        private Set<ResType> allResTypeNames;
        private Set<ResType> tempSelResTypes;
        private List<Button> checkButtonsList;

        public FileTypeDialog(Shell parentShell) {
            super(parentShell);
            this.allResTypeNames = new TreeSet<ResType>(new ResTypeComparator());
            this.tempSelResTypes = new TreeSet<ResType>(new ResTypeComparator());
            this.checkButtonsList = new ArrayList<Button>(this.allResTypeNames.size());
            this.setHelpAvailable(false);
            this.allResTypeNames.addAll(fileTypesPerResType.keySet());
            this.tempSelResTypes.addAll(MainframeSearchViewer.this.selectedResTypes);
        }

        protected Control createDialogArea(Composite parent) {
            Button checkButton;
            Composite container = (Composite)super.createDialogArea(parent);
            Composite choiceArea = new Composite(container, 2048);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            choiceArea.setLayout((Layout)gridLayout);
            GridData gridChoice = new GridData();
            gridChoice.grabExcessHorizontalSpace = true;
            gridChoice.horizontalAlignment = 4;
            gridChoice.minimumWidth = 400;
            gridChoice.minimumHeight = 250;
            choiceArea.setLayoutData((Object)gridChoice);
            for (ResType resType : this.allResTypeNames) {
                if (resType.equals((Object)ResType.EXTERNAL)) continue;
                checkButton = new Button(choiceArea, 32);
                this.checkButtonsList.add(checkButton);
                checkButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                checkButton.setText(resType.getLabel());
                checkButton.setData((Object)resType);
                checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FileTypeDialog.this.handleCheckButtonSelection(e);
                    }
                });
                GridData grids = new GridData();
                grids.grabExcessHorizontalSpace = true;
                grids.horizontalAlignment = 4;
                checkButton.setLayoutData((Object)grids);
            }
            Composite externalArea = new Composite(container, 2048);
            GridLayout gridLayoutExternal = new GridLayout();
            gridLayoutExternal.numColumns = 3;
            gridLayoutExternal.marginHeight = 0;
            gridLayoutExternal.marginLeft = 0;
            externalArea.setLayout((Layout)gridLayoutExternal);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.minimumWidth = 400;
            gridData.minimumHeight = 50;
            externalArea.setLayoutData((Object)gridData);
            checkButton = new Button(externalArea, 32);
            this.checkButtonsList.add(checkButton);
            checkButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            checkButton.setText(ResType.EXTERNAL.getLabel());
            checkButton.setData((Object)ResType.EXTERNAL);
            checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileTypeDialog.this.handleCheckButtonSelection(e);
                }
            });
            GridData gridExt = new GridData();
            gridExt.grabExcessHorizontalSpace = true;
            gridExt.horizontalAlignment = 4;
            gridExt.horizontalSpan = 3;
            gridExt.verticalAlignment = 128;
            checkButton.setLayoutData((Object)gridExt);
            for (Button cButton : this.checkButtonsList) {
                ResType key = (ResType)((Object)cButton.getData());
                if (!this.tempSelResTypes.contains((Object)key)) continue;
                cButton.setSelection(true);
            }
            container.getShell().pack();
            return container;
        }

        private void handleCheckButtonSelection(SelectionEvent e) {
            Button checkButton = (Button)e.getSource();
            if (checkButton.getSelection()) {
                this.tempSelResTypes.add((ResType)((Object)checkButton.getData()));
                this.getButton(0).setEnabled(true);
            } else {
                this.tempSelResTypes.remove((Object)((ResType)((Object)checkButton.getData())));
            }
            if (this.tempSelResTypes.size() == 0) {
                this.getButton(0).setEnabled(false);
            }
        }

        protected void createButtonsForButtonBar(final Composite parent) {
            parent.setLayoutData((Object)new GridData(4, 131072, true, false));
            Button selectAll = this.createButton(parent, 4, Messages.getString(MainframeSearchViewer.class, "filter.dialog.all.button.lbl"), false);
            Button selectNone = this.createButton(parent, 3, Messages.getString(MainframeSearchViewer.class, "filter.dialog.none.button.lbl"), false);
            selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (Button cButton : FileTypeDialog.this.checkButtonsList) {
                        cButton.setSelection(true);
                    }
                    FileTypeDialog.this.tempSelResTypes.addAll(FileTypeDialog.this.allResTypeNames);
                    FileTypeDialog.this.getButton(0).setEnabled(true);
                }
            });
            selectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (Button cButton : FileTypeDialog.this.checkButtonsList) {
                        cButton.setSelection(false);
                    }
                    FileTypeDialog.this.tempSelResTypes.clear();
                    FileTypeDialog.this.getButton(0).setEnabled(false);
                }
            });
            Label spacer = new Label(parent, 0);
            spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button cancelButton = this.createButton(parent, 1, Messages.getString(MainframeSearchViewer.class, "filter.dialog.cancel.button.lbl"), false);
            cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileTypeDialog.this.tempSelResTypes.clear();
                    parent.getParent().getParent().getParent().dispose();
                }
            });
            Button okButton = this.createButton(parent, 0, Messages.getString(MainframeSearchViewer.class, "filter.dialog.ok.button.lbl"), true);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StringBuilder sBuilder = new StringBuilder();
                    for (ResType resType : FileTypeDialog.this.tempSelResTypes) {
                        if (sBuilder.length() > 0) {
                            sBuilder.append(", ");
                        }
                        sBuilder.append(resType.getLabel());
                    }
                    MainframeSearchViewer.this.selectedResTypes.clear();
                    MainframeSearchViewer.this.selectedResTypes.addAll(FileTypeDialog.this.tempSelResTypes);
                    MainframeSearchViewer.this.fileTypeText.setText(sBuilder.toString());
                    parent.getParent().getParent().getParent().dispose();
                }
            });
            GridLayout layout = (GridLayout)parent.getLayout();
            ++layout.numColumns;
            layout.makeColumnsEqualWidth = false;
            parent.getShell().pack();
        }

        public boolean close() {
            return true;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.getString(MainframeSearchViewer.class, "shell.title"));
            newShell.addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    event.doit = true;
                }
            });
        }

        protected Point getInitialSize() {
            return new Point(460, 325);
        }

        protected boolean isResizable() {
            return true;
        }
    }

    private class LineInfo {
        int lineNo;
        String lineText;
        List<OffAndLen> offsetInfo;

        private LineInfo() {
        }
    }

    private class OffAndLen {
        int offset;
        int len;
        public int idx;

        private OffAndLen() {
        }
    }

    class QueryDescriptor
    implements ISearchService.IQueryDescriptor {
        String fileRegex;
        String contentRegex;
        boolean comments;
        boolean sensitive;
        boolean isRegex;
        boolean previous;

        QueryDescriptor(MainframeSearchDescriptor descriptor) {
            this.fileRegex = descriptor.getState().getData().get(MainframeSearchViewer.PATTERN_KEY) != null ? (String)descriptor.getState().getData().get(MainframeSearchViewer.PATTERN_KEY) : "";
            this.contentRegex = descriptor.getState().getData().get(MainframeSearchViewer.REGEX_KEY) != null ? (String)descriptor.getState().getData().get(MainframeSearchViewer.REGEX_KEY) : "";
            this.comments = descriptor.getState().getData().get(MainframeSearchViewer.ISCOMMENT_KEY) != null ? (Boolean)descriptor.getState().getData().get(MainframeSearchViewer.ISCOMMENT_KEY) : false;
            this.sensitive = descriptor.getState().getData().get(MainframeSearchViewer.ISSENSITIVE_KEY) != null ? (Boolean)descriptor.getState().getData().get(MainframeSearchViewer.ISSENSITIVE_KEY) : false;
            this.isRegex = descriptor.getState().getData().get(MainframeSearchViewer.ISREGEX_KEY) != null ? (Boolean)descriptor.getState().getData().get(MainframeSearchViewer.ISREGEX_KEY) : false;
            this.previous = descriptor.getState().getData().get(MainframeSearchViewer.ISPREVIOUS_KEY) != null ? (Boolean)descriptor.getState().getData().get(MainframeSearchViewer.ISPREVIOUS_KEY) : false;
        }

        @Override
        public String getFileRegex() {
            return this.fileRegex;
        }

        @Override
        public String getContentRegex() {
            return this.contentRegex;
        }

        @Override
        public boolean inComment() {
            return this.comments;
        }

        @Override
        public boolean isCaseSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isRegularExpression() {
            return this.isRegex;
        }

        @Override
        public boolean isPrevious() {
            return this.previous;
        }

        @Override
        public Set<String> getPreviousPaths(String projectName) {
            return (Set)MainframeSearchViewer.this.previousResultsMap.get(projectName);
        }

        @Override
        public Map<Integer, Boolean> getEnabledFileTypes() {
            HashMap<Integer, Boolean> ret = new HashMap<Integer, Boolean>();
            for (ResType resType : MainframeSearchViewer.this.selectedResTypes) {
                List fileTypes = (List)fileTypesPerResType.get((Object)resType);
                for (Pair fileType : fileTypes) {
                    ret.put((Integer)fileType.getFirst(), (Boolean)fileType.getSecond());
                }
            }
            return ret;
        }
    }

    private static enum ResType {
        ADS_DIALOG(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.adsDialog")),
        ADS_MAP(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.adsMap")),
        ADS_PROCESS(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.adsProcess")),
        ASSEMBLER(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.assembler")),
        ASSEMBLER_INCLUDE(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.assemblerInclude")),
        BMS(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.bms")),
        COBOL(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.cobol")),
        COBOL_INCLUDE(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.cobolInclude")),
        JCL(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.jcl")),
        JCL_CTRL(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.jclCtrl")),
        JCL_INCLUDE(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.jclInclude")),
        JCL_PROC(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.jclProc")),
        MFS(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.mfs")),
        NATURAL(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.natural")),
        NATURAL_DATA_AREA(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.naturalDataArea")),
        NATURAL_DDM(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.naturalDdm")),
        NATURAL_INCLUDE(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.naturalInclude")),
        NATURAL_MAP(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.naturalMap")),
        PL1(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.pl1")),
        PL1_INCLUDE(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.pl1Include")),
        EXTERNAL(Messages.getString(MainframeSearchViewer.class, "resType.enum.label.external"));

        private String label;

        private ResType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    private class ResTypeComparator
    implements Comparator<ResType> {
        private ResTypeComparator() {
        }

        @Override
        public int compare(ResType o1, ResType o2) {
            return o1.name().compareTo(o2.name());
        }
    }

    class ResultAdder
    implements IResultHandler {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        private ProjectInfo projectInfo;

        public ResultAdder(ProjectInfo projectInfo) {
            this.projectInfo = projectInfo;
        }

        @Override
        public void onResult(String msgResult) {
            SearchItem fakeSearchItem = new SearchItem();
            fakeSearchItem.setErrMsg(msgResult);
            this.onResult(fakeSearchItem);
        }

        @Override
        public void onResult(SearchItem sItem) {
            ResultProjectData resultPrjData = (ResultProjectData)MainframeSearchViewer.this.resultsMap.get(this.projectInfo.getName());
            if (resultPrjData == null) {
                resultPrjData = new ResultProjectData(this.projectInfo);
                MainframeSearchViewer.this.resultsMap.put(resultPrjData.getProjectName(), resultPrjData);
                Map data = MainframeSearchViewer.this.descriptor.getState().getData();
                if (data.get(MainframeSearchViewer.RESULTS_MAP_KEY) == null) {
                    data.put(MainframeSearchViewer.RESULTS_MAP_KEY, MainframeSearchViewer.this.resultsMap);
                }
            }
            resultPrjData.addSearchItem(sItem);
        }

        @Override
        public void onError(String msg) {
            this.onResult(msg);
        }

        @Override
        public void onSummary(int noOfFiles, int occurrences) {
            ResultProjectData resultPrjData = (ResultProjectData)MainframeSearchViewer.this.resultsMap.get(this.projectInfo.getName());
            if (resultPrjData != null) {
                resultPrjData.setNumberOfFiles(noOfFiles);
                resultPrjData.setOccrrences(occurrences);
            }
        }
    }
}

