/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.search.project;

import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.views.AbstractScrollableItemsView;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeSearchInFilesAnalysis
extends AbstractAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeSearchInFilesAnalysis.class);
    public static final String SEARCH_IN_FILES_ANALYSIS = "com.ez.analysis.mainframe.search.project";

    protected String getAnalysisId() {
        return SEARCH_IN_FILES_ANALYSIS;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.MAINFRAME_PROJECT_SEARCH_IN_FILES;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        return null;
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    public boolean scopeIsShared() {
        return false;
    }

    protected void continueAnalysisForLocal() {
        AbstractActionContext state = new AbstractActionContext(){

            public Map<String, Object> getData() {
                Object notComputeResults;
                HashMap<String, Object> data = new HashMap<String, Object>();
                List<ProjectInfo> inputProjects = (List<ProjectInfo>)data.get("PROJECT_LIST");
                if (inputProjects == null) {
                    List objTypes = MainframeSearchInFilesAnalysis.this.getContextListValue("input_list");
                    inputProjects = MainframeSearchInFilesAnalysis.computeInputProjectList(objTypes);
                    data.put("PROJECT_LIST", inputProjects);
                }
                if ((notComputeResults = MainframeSearchInFilesAnalysis.this.getContextValue("NOT_COMPUTE_USAGE_RESULTS")) != null) {
                    data.put("NOT_COMPUTE_USAGE_RESULTS", notComputeResults);
                }
                if (MainframeSearchInFilesAnalysis.this.getContextValue("projects") != null) {
                    data.put("projects", MainframeSearchInFilesAnalysis.this.getContextValue("projects"));
                }
                return data;
            }

            public String getId() {
                return MainframeSearchInFilesAnalysis.this.getAnalysisId();
            }
        };
        Display.getDefault().syncExec(new Runnable((IActionContext)state){
            private final /* synthetic */ IActionContext val$state;
            {
                this.val$state = iActionContext;
            }

            @Override
            public void run() {
                String id = MainframeSearchInFilesAnalysis.this.getAnalysisId();
                try {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow window = workbench.getWorkbenchWindows()[0];
                    AbstractScrollableItemsView analysisBrowserViewPart = (AbstractScrollableItemsView)window.getActivePage().showView("com.ez.analysisbrowser.views.AnalysisBrowserView");
                    EZAnalysisType anaysisType = MainframeSearchInFilesAnalysis.this.getType();
                    analysisBrowserViewPart.launch(anaysisType, this.val$state);
                }
                catch (PartInitException e) {
                    L.error("while activating view: " + id, (Throwable)e);
                }
            }
        });
    }

    public static List<ProjectInfo> computeInputProjectList(List<EZObjectType> objTypes) {
        ArrayList<ProjectInfo> inputProjects = null;
        if (objTypes != null) {
            inputProjects = new ArrayList<ProjectInfo>();
            for (EZObjectType objType : objTypes) {
                ProjectInfo pi;
                EZSourceProjectIDSg prjIdSg = (EZSourceProjectIDSg)objType.getEntID().getSegment(EZSourceProjectIDSg.class);
                if (prjIdSg == null || inputProjects.contains(pi = prjIdSg.getProjectInfo())) continue;
                inputProjects.add(pi);
            }
        }
        return inputProjects;
    }

    protected void verifyLicenseForLocal() {
        this.continueAnalysisForLocal();
    }
}

