/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.search.project;

import com.ez.analysis.mainframe.search.project.MainframeSearchDescriptor;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.util.ActionUtils;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.EZInputFilter;
import com.ez.workspace.analysis.audit.IAudit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeSearchAction
implements IAction,
IAudit {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeSearchAction.class);
    public static final String PROJECTINFO = "projectinfo";
    public static final String PROJECT_STRUCTURE_MODEL = "projectStructureModel";
    private MainframeSearchDescriptor descriptor;
    private EZAnalysisType analysisType;
    private EZInputFilter filter;
    private IActionContext context;
    private ProjectInfo pinfo;

    public MainframeSearchAction(MainframeSearchDescriptor mainframeProjectStructureDescriptor) {
        this.descriptor = mainframeProjectStructureDescriptor;
        this.analysisType = this.descriptor.getAnalysisType();
        this.filter = this.analysisType.getInputFilterInstance();
    }

    public boolean canHandle(IActionContext context) {
        return ActionUtils.canHandle((EZAnalysisType)this.analysisType, (EZInputFilter)this.filter, (IActionContext)context);
    }

    public void setInputContext(IActionContext context) {
        Map data;
        List inputs;
        this.context = context;
        if (context != null && (inputs = (List)(data = context.getData()).get("ANALYSIS_TYPE_INPUTS")) != null && !inputs.isEmpty()) {
            this.context = this.createdContextFromData(data);
        }
    }

    public IActionContext getOutputContext() {
        return this.context;
    }

    public void execute(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        if (this.context != null) {
            this.descriptor.getState().getData().putAll(this.context.getData());
        }
        monitor.done();
    }

    public String getProjectNames4Audit() {
        List inputProjects = (List)this.descriptor.getState().getData().get("PROJECT_LIST");
        StringBuffer projectListSb = new StringBuffer();
        if (inputProjects != null) {
            for (com.ez.mainframe.model.ProjectInfo projectInfo : inputProjects) {
                projectListSb.append(String.valueOf(projectInfo.getName()) + ",");
            }
        }
        String projectListString = "";
        if (projectListSb.length() > 0) {
            projectListString = projectListSb.substring(0, projectListSb.length() - 1);
        }
        return projectListString;
    }

    public Integer getOperationCode() {
        return this.analysisType.getImplementorInstance().getOperationType().getOperationCode();
    }

    public String getOperationName() {
        return this.analysisType.getName();
    }

    private IActionContext createdContextFromData(final Map<String, Object> initialData) {
        AbstractActionContext context = new AbstractActionContext(){

            public Map<String, Object> getData() {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("projects", initialData.get("projects"));
                List inputProjects = (ArrayList)initialData.get("PROJECT_LIST");
                if (inputProjects == null) {
                    List objTypes = (List)initialData.get("ANALYSIS_TYPE_INPUTS");
                    inputProjects = Utils.computeInputProjectList((List)objTypes);
                } else {
                    inputProjects = new ArrayList(inputProjects);
                }
                data.put("PROJECT_LIST", inputProjects);
                return data;
            }

            public String getId() {
                return "com.ez.analysis.mainframe.search.project";
            }
        };
        return context;
    }
}

