/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.search.filter;

import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.mainframe.filters.MultipleMainframeProjectFilter;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.ProjectType;
import java.util.Collection;
import java.util.Map;

public class MainframeSearchInFilesFilter
extends MultipleMainframeProjectFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\ufffd Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public boolean checkProjectCount(Collection inputs) {
        return true;
    }

    public boolean checkAnalysisAvailability(Collection inputs) {
        boolean ret = true;
        if (this.checkProjectCount(inputs)) {
            int countProjects = this.countProjects(inputs);
            boolean bl = ret = countProjects > 0 && countProjects == inputs.size();
            if (ret) {
                ret = this.checkResources(inputs);
            }
        }
        return ret;
    }

    private boolean checkResources(Collection inputs) {
        boolean ret = true;
        for (Object inpObj : inputs) {
            Map info;
            EZSourceProjectInputType pit;
            ProjectInfo pInfo;
            if (!(inpObj instanceof EZSourceProjectInputType) || (pInfo = (ProjectInfo)(pit = (EZSourceProjectInputType)inpObj).getProperty("PROJECT_INFO")) == null || (info = pInfo.getInfo()) == null || info.isEmpty() || !info.containsKey("onMainframe") || !info.containsKey("environment")) continue;
            Boolean onMainframe = (Boolean)info.get("onMainframe");
            String environment = (String)info.get("environment");
            if (!"JVM".equals(environment) || onMainframe.booleanValue() || !ProjectType.javaWazi.equals((Object)pInfo.getType())) continue;
            ret = false;
            break;
        }
        return ret;
    }
}

