/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.srvcross.core.utils;

import com.ez.eclient.service.rsrv.cross.CrossService;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.internal.utils.Triplet;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import com.ibm.ad.oauth2.service.SSOService;
import com.ibm.ad.srvcross.core.internal.Messages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossUtils.class);
    public static final String SP_PROJECT_SUMMARY = "spRep_ProjectRelationSummary";
    public static final String SP_GETPROJECTS = "spRep_GetProjectDetails";
    public static final String SP_GETRESTYPES = "spRep_GetResourceTypes";
    public static final String SP_PROJDETAILS = "spRep_ProjectRelationDetails";
    public static final String SP_PROJINTERNAL = "spRep_ProjectInternalRelations";
    public static final String SP_GETRESOURCES = "spRep_GetResourceDetails";
    public static final String SP_STMT_POS = "spRep_GetStatementPositionDetails";
    public static final String ALL_CROSS_PROJECTS = "All cross projects filtered by the workspace restrictions";
    public static final String SELECTED_PROGRAMS = "selected programs as input";
    public static final String EXCLUDED_PROJECTS = "excluded cross projects";
    public static final String PROJECT_SUMMARY_DATA = "data from SP_PROJECT_SUMMARY";
    public static final String PROJECT_RELATION_DETAILS_DATA = "data from SP_PROJECT_RELATION_DETAILS";
    public static final String PROGRAMS_DETAILS = "data from SP_GETRESOURCES";
    public static final String INPUT_PROJECT_MAP = "cross input projects";
    public static final String ALL_PROJECT_MAP = "all projects";
    public static final String ALL_PROJECT_CROSS_INFO_MAP = "all cross projects";
    public static final String DATA_KEY = "data for request ";
    public static final String CROSS_ORIG_ID = "statement info id";
    public static final String EDITOR_ID = "editor type id";

    @SafeVarargs
    public static String prepareURL(String prefix, Pair<String, String> ... params) {
        String url = null;
        try {
            url = String.valueOf(prefix) + "?";
            int no = 1;
            Pair<String, String>[] pairArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Pair<String, String> parameter = pairArray[n2];
                String paramName = (String)parameter.getFirst();
                String paramVal = (String)parameter.getSecond();
                url = String.valueOf(url) + paramName + "=" + paramVal;
                if (no < params.length) {
                    url = String.valueOf(url) + "&";
                }
                ++no;
                ++n2;
            }
        }
        catch (Exception e) {
            L.error("error preparing url. prefix={}; params={}", new Object[]{prefix, params, e});
        }
        return url;
    }

    public static JsonArray runRequest(String request) throws Exception {
        JsonArray data = null;
        SSOService sso = (SSOService)ServiceUtils.getService(SSOService.class);
        if (sso != null) {
            HttpResponseConsumer consumer = new HttpResponseConsumer();
            URL url = new URL(request);
            sso.request(url, consumer);
            String ret = consumer.getContent();
            L.debug("requesting: {}", (Object)request);
            if (consumer.getHttpCode() == 200) {
                L.debug("response code 200");
                JsonReader reader = Json.createReader((InputStream)new ByteArrayInputStream(ret.getBytes()));
                JsonObject root = reader.readObject();
                data = root.getJsonArray("results");
                L.debug("results : {}", (Object)data);
            } else {
                if (consumer.getHttpCode() == -1) {
                    String msg = Messages.getString(CrossUtils.class, "request.cross.server.notstarted");
                    throw new Exception(msg);
                }
                String msg = Messages.getString(CrossUtils.class, "request.cross.response.error", new String[]{String.valueOf(consumer.getHttpCode())});
                LogUtil.displayErrorMessage((Status)new Status(4, "com.ibm.ad.srvcross.core", msg, null), (boolean)false);
            }
        } else {
            L.error("cannot find SSOService!");
        }
        return data;
    }

    public static String getQueryResultEndpoint() {
        CrossService srv = (CrossService)ServiceUtils.getService((String)CrossService.class.getName());
        L.trace("cross service={}", (Object)srv);
        if (srv == null) {
            throw new RuntimeException("no cross service available!");
        }
        if (!srv.isStarted()) {
            L.error("cross service not started!");
            return null;
        }
        return srv.getQueryResultEndpoint();
    }

    public static List<Triplet<String, String, String>> getCrossPrjs(Set<String> allPrjs) throws Exception {
        ArrayList<Triplet<String, String, String>> result = new ArrayList<Triplet<String, String, String>>();
        String endpoint = CrossUtils.getQueryResultEndpoint();
        if (endpoint != null && !endpoint.isEmpty()) {
            String request = CrossUtils.prepareURL(endpoint, new Pair((Object)"spName", (Object)SP_GETPROJECTS));
            JsonArray prjData = CrossUtils.runRequest(request);
            if (prjData != null) {
                int i = 0;
                while (i < prjData.size()) {
                    JsonObject prjInfo = prjData.getJsonObject(i);
                    String name = prjInfo.getString("ProjectName");
                    if (allPrjs == null || allPrjs.contains(name)) {
                        String id = prjInfo.getString("ProjectID");
                        String guid = prjInfo.getString("ProjectGUID");
                        result.add((Triplet<String, String, String>)new Triplet((Object)name, (Object)guid, (Object)id));
                    } else {
                        L.debug("project {} has cross details, but is not visible for the current user", (Object)name);
                    }
                    ++i;
                }
            } else {
                L.warn("no cross projects found. Check the cross service is working properly!");
            }
        } else {
            L.warn("request result endpoint is not filled in CCS");
        }
        return result;
    }
}

