/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.srvcross.core.itf.impl;

import com.ez.eclient.service.rsrv.cross.CrossService;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.srvcross.core.itf.ICrossService;
import com.ibm.ad.srvcross.core.utils.CrossUtils;
import java.util.HashSet;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossServiceImpl
implements ICrossService {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossServiceImpl.class);
    private Set<String> prjNames = new HashSet<String>();
    private CrossPooling thread = new CrossPooling();

    public void shouldStop() {
        this.thread.shouldStop();
    }

    public CrossServiceImpl() {
        this.thread.start();
    }

    @Override
    public boolean hasCross(String prjName) {
        return this.prjNames != null && this.prjNames.contains(prjName);
    }

    private class CrossPooling
    extends Thread {
        private final int INIT_SLEEPTIME = 1000;
        private final int SLEEPTIME = 120000;
        private final int EXCEPTION_SLEEPTIME = 10000;
        private int sleep = 1000;
        private boolean shouldStop = false;

        public CrossPooling() {
            this.setName("CrossService.pooling");
        }

        public void shouldStop() {
            this.shouldStop = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.shouldStop) {
                CrossServiceImpl.this.prjNames = this.updatePrjNames();
                try {
                    if (CrossServiceImpl.this.prjNames != null && CrossServiceImpl.this.prjNames.isEmpty()) {
                        Thread.sleep(this.sleep);
                        continue;
                    }
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            L.debug("CrossPooling stopped");
        }

        private Set<String> updatePrjNames() {
            CrossService srv = (CrossService)ServiceUtils.getService((String)"com.ez.eclient.service.rsrv.cross.CrossService");
            L.trace("analysis filter: cross service={}", (Object)srv);
            HashSet<String> names = new HashSet<String>();
            if (srv != null && srv.isStarted()) {
                String endpoint = srv.getQueryResultEndpoint();
                if (endpoint != null && !endpoint.isEmpty()) {
                    Pair params = new Pair((Object)"spName", (Object)"spRep_GetProjectDetails");
                    String request = CrossUtils.prepareURL(endpoint, params);
                    try {
                        JsonArray prjData = CrossUtils.runRequest(request);
                        if (prjData != null) {
                            int i = 0;
                            while (i < prjData.size()) {
                                JsonObject prjInfo = prjData.getJsonObject(i);
                                String name = prjInfo.getString("ProjectName");
                                names.add(name);
                                ++i;
                            }
                            this.sleep = 1000;
                        }
                    }
                    catch (Exception e) {
                        LogUtil.displayErrorMessage((Status)new Status(2, "com.ibm.ad.srvcross.core", e.getMessage(), null), (boolean)false);
                        L.debug("cross pooling will be stoped! Application's restart is required after starting Cross Applications Service");
                        this.shouldStop();
                    }
                } else {
                    L.warn("cross service not configured!");
                    this.sleep = 10000;
                    return null;
                }
            }
            return names;
        }
    }
}

